/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ContributorHelper {
    public static String getContributorName(IContributorHandle contributorHandle, ITeamRepository repository) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"contributorHandle", (Object)contributorHandle);
        ValidationHelper.validateNotNull((String)"repository", (Object)repository);
        ArrayList<String> requiredProperties = new ArrayList<String>();
        requiredProperties.add(IContributor.NAME_PROPERTY);
        IContributor contributor = (IContributor)repository.itemManager().fetchPartialItem((IItemHandle)contributorHandle, 0, requiredProperties, (IProgressMonitor)new NullProgressMonitor());
        return contributor.getName();
    }

    public static String getContributorLabelText(IContributor contributor) {
        ValidationHelper.validateNotNull((String)"contributor", (Object)contributor);
        return contributor.isArchived() ? NLS.bind((String)BuildUIHelperMessages.ContributorHelper_ARCHIVED_CONTRIBUTOR_LABEL, (Object[])new Object[]{contributor.getName()}) : contributor.getName();
    }
}

