/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class BuildUIHelper {
    public static boolean DIALOG_BLOCK_ON_OPEN = true;

    public static void openTextFileInEditor(File fileToOpen, String characterEncoding, IWorkbenchPage workbenchPage) throws CoreException {
        ValidationHelper.validateNotNull((String)"fileToOpen", (Object)fileToOpen);
        ValidationHelper.validateNotNull((String)"workbenchPage", (Object)workbenchPage);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
        FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
        String defaultEncoding = System.getProperty("file.encoding");
        boolean replaceEncoding = false;
        if (!defaultEncoding.equals(characterEncoding) && Charset.isSupported(characterEncoding)) {
            replaceEncoding = true;
        }
        try {
            if (replaceEncoding) {
                System.setProperty("file.encoding", characterEncoding);
            }
            IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor");
        }
        finally {
            if (replaceEncoding) {
                System.setProperty("file.encoding", defaultEncoding);
            }
        }
    }

    public static void openFileInEditor(File fileToOpen, IWorkbenchPage workbenchPage) throws CoreException {
        ValidationHelper.validateNotNull((String)"fileToOpen", (Object)fileToOpen);
        ValidationHelper.validateNotNull((String)"workbenchPage", (Object)workbenchPage);
        IEditorRegistry editorRegistry = workbenchPage.getWorkbenchWindow().getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(fileToOpen.getName());
        if (descriptor == null) {
            if (editorRegistry.isSystemInPlaceEditorAvailable(fileToOpen.getName())) {
                descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
            } else if (editorRegistry.isSystemExternalEditorAvailable(fileToOpen.getName())) {
                descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
            }
            if (descriptor == null) {
                descriptor = editorRegistry.findEditor("org.eclipse.ui.DefaultTextEditor");
            }
        }
        IDE.openEditor((IWorkbenchPage)workbenchPage, (URI)fileToOpen.toURI(), (String)descriptor.getId(), (boolean)true);
    }

    public static void showErrorDialog(String message) {
        IStatus errorStatus = BuildUIHelper.createErrorStatus(message);
        BuildUIHelper.showErrorDialog(null, null, errorStatus);
    }

    public static void showErrorDialog(String message, String title, Exception exception) {
        String dialogMessage = exception == null ? null : message;
        String statusMessage = exception == null ? message : TeamBuildJobHelper.getStatusMessage(exception);
        Status errorStatus = new Status(4, BuildUIPlugin.getUniqueIdentifier(), statusMessage, (Throwable)exception);
        BuildUIHelper.showErrorDialog(dialogMessage, title, TeamBuildJobHelper.createDisplayableStatus((IStatus)errorStatus));
    }

    public static void showErrorDialog(String message, String reason, String title, Exception exception) {
        Status errorStatus = new Status(4, BuildUIPlugin.getUniqueIdentifier(), reason, (Throwable)exception);
        BuildUIHelper.showErrorDialog(message, title, TeamBuildJobHelper.createDisplayableStatus((IStatus)errorStatus));
    }

    public static void showErrorDialog(String message, String title, IStatus status) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell parent = workbench.getWorkbenchWindowCount() > 0 ? workbench.getWorkbenchWindows()[0].getShell() : null;
        final ErrorDialog dialog = new ErrorDialog(parent, title, message, status, 7);
        dialog.setBlockOnOpen(DIALOG_BLOCK_ON_OPEN);
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
        } else {
            dialog.open();
        }
    }

    public static void showInfoDialog(final Shell parent, final String title, final String message) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BuildUIHelper.doShowMessageDialog(parent, title, message, 2);
                }
            });
        } else {
            BuildUIHelper.doShowMessageDialog(parent, title, message, 2);
        }
    }

    public static void showWarningDialog(final Shell parent, final String title, final String message) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BuildUIHelper.doShowMessageDialog(parent, title, message, 4);
                }
            });
        } else {
            BuildUIHelper.doShowMessageDialog(parent, title, message, 4);
        }
    }

    private static void doShowMessageDialog(Shell parent, String title, String message, int severity) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, severity, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.setBlockOnOpen(DIALOG_BLOCK_ON_OPEN);
        dialog.open();
    }

    public static boolean showQueryDialog(String title, String message) {
        MessageDialog dialog = new MessageDialog(null, title, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        dialog.setBlockOnOpen(DIALOG_BLOCK_ON_OPEN);
        return dialog.open() == 0;
    }

    public static IStatus createErrorStatus(String errorMessage) {
        ValidationHelper.validateNotEmpty((String)"errorMessage", (String)errorMessage);
        return new Status(4, BuildUIPlugin.getUniqueIdentifier(), errorMessage);
    }
}

