/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.feed;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.feed.Messages;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IFeedManagerConfigurer;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IFeedServiceConstants;
import com.ibm.team.repository.common.Location;
import java.net.URI;
import org.eclipse.osgi.util.NLS;

public class BuildFeedConfigurer
implements IFeedManagerConfigurer,
ITeamRepositoryService.IRepositoryServiceListener,
ITeamRepository.ILoginParticipant {
    private FeedManager fFeedManager;

    public void configure(FeedManager manager) {
        ITeamRepository[] teamRepositories;
        this.fFeedManager = manager;
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = this.getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            teamRepository.addLoginParticipant((ITeamRepository.ILoginParticipant)this);
            if (teamRepository.loggedIn()) {
                this.addDefaultBuildChannel(manager, teamRepository);
            }
            ++n2;
        }
    }

    public Channel addDefinitionChannel(String buildDefinitionId, IBuildDefinitionHandle buildDefinitionHandle, FeedManager feedManager) {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinitionHandle.getOrigin();
        String url = this.getBuildDefinitionChannelUrl(teamRepository, buildDefinitionHandle);
        Channel channel = feedManager.getChannel(url);
        if (channel == null) {
            channel = this.createChannel(url, NLS.bind((String)Messages.BuildFeedConfigurer_BUILD_DEFINITION_EVENTS_TITLE, (Object)buildDefinitionId), NLS.bind((String)Messages.BuildFeedConfigurer_BUILD_DEFINITION_EVENTS_DESCRIPTION, (Object)buildDefinitionId));
            feedManager.addChannel(channel);
            feedManager.loadNews(channel);
        }
        return channel;
    }

    private Channel addDefaultBuildChannel(FeedManager feedManager, ITeamRepository teamRepository) {
        String url;
        Channel channel = this.getBuildChannel(feedManager, teamRepository);
        if (channel == null && (channel = feedManager.getChannel(url = this.getDefaultBuildChannelUrl(teamRepository))) == null) {
            channel = this.createChannel(url, Messages.BuildFeedConfigurer_FEED_TITLE, Messages.BuildFeedConfigurer_FEED_DESCRIPTION);
            feedManager.addChannel(channel);
            feedManager.loadNews(channel);
        }
        return channel;
    }

    private Channel getBuildChannel(FeedManager feedManager, ITeamRepository teamRepository) {
        Channel[] channelArray = feedManager.getChannels();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            String channelRepositoryUri = this.getRepositoryUri(channel);
            if (channelRepositoryUri != null && this.equalRepositoryUris(teamRepository.getRepositoryURI(), channelRepositoryUri) && this.isBuildProvider(channel)) {
                return channel;
            }
            ++n2;
        }
        return null;
    }

    private boolean isBuildProvider(Channel channel) {
        String url = channel.getUrl();
        String buildProvider = "provider=build";
        return url.contains(buildProvider);
    }

    private String getRepositoryUri(Channel channel) {
        String repositoryUri = null;
        String url = channel.getUrl();
        try {
            url = url.replace("{$user}", "x");
            Location location = Location.location((URI)new URI(url));
            repositoryUri = location.getRepoUri();
        }
        catch (Exception exception) {}
        return repositoryUri;
    }

    private void removeAllBuildChannels(FeedManager feedManager, ITeamRepository teamRepository) {
        Channel[] channelArray = feedManager.getChannels();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            String channelRepositoryUri = this.getRepositoryUri(channel);
            if (channelRepositoryUri != null && this.equalRepositoryUris(teamRepository.getRepositoryURI(), channelRepositoryUri) && this.isBuildProvider(channel)) {
                feedManager.removeChannel(channel);
            }
            ++n2;
        }
    }

    private String getDefaultBuildChannelUrl(ITeamRepository teamRepository) {
        StringBuffer url = new StringBuffer();
        url.append(teamRepository.getRepositoryURI());
        url.append("service/");
        url.append(IFeedServiceConstants.SERVICE_NAME);
        url.append("?");
        url.append("provider");
        url.append("=");
        url.append("build");
        url.append("&user=").append("{$user}");
        return url.toString();
    }

    private String getBuildDefinitionChannelUrl(ITeamRepository teamRepository, IBuildDefinitionHandle buildDefinitionHandle) {
        StringBuffer url = new StringBuffer();
        url.append(teamRepository.getRepositoryURI());
        url.append("service/");
        url.append(IFeedServiceConstants.SERVICE_NAME);
        url.append("?");
        url.append("provider");
        url.append("=");
        url.append("build");
        url.append("&");
        url.append("buildDefinitionUUID");
        url.append("=");
        url.append(buildDefinitionHandle.getItemId().getUuidValue());
        url.append("&user=").append("{$user}");
        return url.toString();
    }

    private Channel createChannel(String url, String title, String description) {
        Channel channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(url);
        channel.setTitle(title);
        channel.setDescription(description);
        channel.setForceDownload(true);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        channel.setUpdateInterval(3);
        return channel;
    }

    public void addedRepository(ITeamRepository repository) {
        repository.addLoginParticipant((ITeamRepository.ILoginParticipant)this);
        this.addDefaultBuildChannel(this.fFeedManager, repository);
    }

    public void removedRepository(ITeamRepository repository) {
        repository.removeLoginParticipant((ITeamRepository.ILoginParticipant)this);
        this.removeAllBuildChannels(this.fFeedManager, repository);
    }

    public void handleLogin(ITeamRepository repository) {
        this.addDefaultBuildChannel(this.fFeedManager, repository);
    }

    public void handleLogout(ITeamRepository repository) {
    }

    protected ITeamRepository[] getTeamRepositories() {
        return TeamPlatform.getTeamRepositoryService().getTeamRepositories();
    }

    private boolean equalRepositoryUris(String uri1, String uri2) {
        boolean equal = false;
        if (uri1.equals(uri2)) {
            equal = true;
        } else {
            if (uri1.endsWith("/")) {
                uri1 = uri1.substring(0, uri1.length() - 1);
            }
            if (uri2.endsWith("/")) {
                uri2 = uri2.substring(0, uri2.length() - 1);
            }
            equal = uri1.equals(uri2);
        }
        return equal;
    }
}

