/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.workitem;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.editors.result.workitem.Messages;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemHyperlinkListener;
import com.ibm.team.build.internal.ui.workitems.WorkItemHelper;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;

public class WorkItemCreationHyperlinkListener
extends WorkItemHyperlinkListener {
    private IBuildResult fBuildResult;
    private IProjectAreaHandle fProjectAreaHandle;

    public WorkItemCreationHyperlinkListener(ITeamRepository teamRepository, SubStatusLineManager statusLineManager, IBuildResult buildResult, IProjectAreaHandle projectAreaHandle) {
        super(statusLineManager);
        this.fBuildResult = buildResult;
        this.fProjectAreaHandle = projectAreaHandle;
    }

    public void linkActivated(HyperlinkEvent e) {
        String summary = NLS.bind((String)Messages.WorkItemCreationHyperlinkListener_BUILD_PROBLEM, (Object)this.fBuildResult.getLabel());
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.createAndLinkWorkItem(shell, summary, "", this.fBuildResult, this.fProjectAreaHandle);
    }

    protected void createAndLinkWorkItem(Shell shell, String summary, String string, IBuildResult buildResult, IProjectAreaHandle projectAreaHandle) {
        WorkItemHelper.getInstance().createAndLinkWorkItem(shell, summary, "", (IBuildResultHandle)buildResult, projectAreaHandle);
    }

    protected String getStatusLineText() {
        return Messages.CREATE_WORK_ITEM_STATUS;
    }
}

