/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.links;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.OpenURLAction;
import com.ibm.team.build.internal.ui.actions.SaveURLAction;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.OpenURLHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.StatusLineHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.download.CopyToClipboardAction;
import com.ibm.team.build.internal.ui.editors.result.links.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinksPage
extends BuildResultPage {
    private StatusLineHyperlinkListener fURLLinkListener;
    private FormEditor fEditor;
    public static final String LINK_ICON_IMAGE_FILENAME = "icons/obj16/extnal_artfct_obj.gif";
    public static final String LABEL_KEY = "LABEL";
    FormToolkit fToolkit = null;

    public LinksPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext) {
        super(editor, id, title, contributionIds, buildResultContext);
        this.fEditor = editor;
        this.fURLLinkListener = new OpenURLHyperlinkListener(true, (IEditorPart)this.fEditor);
    }

    @Override
    protected void doCreatePageContent(Composite parent) {
        this.fToolkit = this.getManagedForm().getToolkit();
        this.fToolkit.setBorderStyle(2048);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.createLinksSections(parent);
        parent.layout(true);
    }

    protected MenuManager createMenuManager() {
        return new MenuManager("#PopupMenu");
    }

    protected IMenuListener createMenuListener(final Hyperlink hyperlink) {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new OpenURLAction((String)hyperlink.getHref(), (IWorkbenchPartSite)LinksPage.this.getFormEditor().getEditorSite(), true));
                manager.add((IAction)new SaveURLAction((String)hyperlink.getHref(), LinksPage.this.getFormEditor().getEditorSite().getShell()));
                manager.add((IAction)new CopyToClipboardAction((String)hyperlink.getHref(), true));
            }
        };
    }

    protected void createHyperlinkContextMenu(Hyperlink hyperlink) {
        MenuManager menuMgr = this.createMenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.createMenuListener(hyperlink));
        Menu menu = menuMgr.createContextMenu((Control)hyperlink);
        hyperlink.setMenu(menu);
    }

    protected void createLinksSections(Composite parent) {
        Hashtable contributionsByComponent = new Hashtable();
        IBuildResultContribution[] contributions = this.getContributions();
        IBuildResultContribution[] iBuildResultContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            String componentName = contribution.getComponentName();
            if (!contributionsByComponent.containsKey(componentName)) {
                contributionsByComponent.put(componentName, new LinkedList());
            }
            ((LinkedList)contributionsByComponent.get(componentName)).add(contribution);
            ++n2;
        }
        int expansionStyle = contributionsByComponent.size() > 1 ? 2 : 0;
        String noComponentSectionTitle = contributionsByComponent.size() > 1 ? Messages.LinksContributionProvider_OTHER_SECTION_TITLE : Messages.LinksContributionProvider_PAGE_TITLE;
        for (String componentName : contributionsByComponent.keySet()) {
            String sectionTitle = componentName.length() == 0 ? noComponentSectionTitle : componentName;
            this.createSection(parent, sectionTitle, (LinkedList)contributionsByComponent.get(componentName), expansionStyle);
        }
    }

    protected void createSection(Composite parent, String sectionTitle, LinkedList<IBuildResultContribution> contributions, int expansionStyle) {
        Section section = this.fToolkit.createSection(parent, 0x100 | expansionStyle);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        section.setText(sectionTitle);
        section.setExpanded(true);
        Composite outerComposite = this.fToolkit.createComposite((Composite)section);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)outerComposite);
        GridLayoutFactory.fillDefaults().applyTo(outerComposite);
        section.setClient((Control)outerComposite);
        Composite hyperlinkComposite = this.fToolkit.createComposite(outerComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hyperlinkComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(hyperlinkComposite);
        this.createHyperlinks(hyperlinkComposite, contributions);
    }

    protected Image getIconImage(IBuildResultContribution contribution) {
        return BuildUIPlugin.getImage(LINK_ICON_IMAGE_FILENAME);
    }

    protected void createHyperlinks(Composite composite, LinkedList<IBuildResultContribution> contributions) {
        for (IBuildResultContribution buildResultContribution : contributions) {
            Label imageLabel = this.fToolkit.createLabel(composite, null);
            Image artImage = this.getIconImage(buildResultContribution);
            if (artImage != null) {
                imageLabel.setImage(artImage);
            }
            String fileURL = buildResultContribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_URL);
            Hyperlink hyperlink = this.createHyperlink(composite, buildResultContribution.getLabel());
            hyperlink.setData((Object)buildResultContribution);
            hyperlink.setData(LABEL_KEY, (Object)buildResultContribution.getLabel());
            hyperlink.setHref((Object)fileURL);
            hyperlink.addListener(6, (Listener)this.fURLLinkListener);
            hyperlink.addListener(7, (Listener)this.fURLLinkListener);
            hyperlink.addHyperlinkListener((IHyperlinkListener)this.fURLLinkListener);
            GridDataFactory.fillDefaults().grab(true, false).indent(3, -1).applyTo((Control)hyperlink);
            this.createHyperlinkContextMenu(hyperlink);
        }
    }

    protected Hyperlink createHyperlink(Composite composite, String fileName) {
        return this.getFormToolkit().createHyperlink(composite, fileName, 0);
    }

    protected FormEditor getFormEditor() {
        return this.fEditor;
    }

    protected FormToolkit getFormToolkit() {
        return this.fToolkit;
    }

    @Override
    protected Viewer getViewer() {
        return null;
    }

    @Override
    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.DOWNLOADS;
    }

    @Override
    public String getContextHelpId() {
        return "com.ibm.team.build.ui.editorpage_buildresultlink";
    }
}

