/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.hyperlink.AbstractJavaSourceHyperlink;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorSite;

public class JavaStackTraceHyperlinkNoConsole
extends AbstractJavaSourceHyperlink {
    private final String fLine;
    private final IRegion fRegion;
    private String fFileName;

    public JavaStackTraceHyperlinkNoConsole(String line, IRegion region, IEditorSite editorSite) {
        super(editorSite);
        this.fLine = line;
        this.fRegion = region;
    }

    protected String getLinkText() {
        int linkMiddle = this.fLine.indexOf(".java:");
        int linkStart = this.fLine.lastIndexOf(32, linkMiddle);
        int linkEnd = this.fLine.indexOf(41, linkMiddle);
        return this.fLine.substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1);
    }

    public String getHyperlinkText() {
        return this.fLine;
    }

    public String getTypeLabel() {
        return BuildResultEditorMessages.JavaStackTraceHyperlinkNoConsole_JAVA_STACK_TRACE_LABEL;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    protected String getFileName() {
        return this.fFileName;
    }

    public String getTypeName() {
        String linkText = this.getLinkText();
        int start = linkText.indexOf(40);
        int end = linkText.indexOf(41);
        if (start >= 0 && end > start) {
            String typeName = linkText.substring(start + 1, end);
            int index = typeName.indexOf(":");
            if (index >= 0) {
                typeName = typeName.substring(0, index);
            }
            this.fFileName = typeName;
            String qualifier = linkText.substring(0, start);
            if ((start = qualifier.lastIndexOf(46)) >= 0 && (start = qualifier.substring(0, start).lastIndexOf(46)) == -1) {
                start = 0;
            }
            if (start >= 0) {
                qualifier = qualifier.substring(0, start);
            }
            if ((index = typeName.indexOf(".java")) >= 0) {
                typeName = typeName.substring(0, index);
            }
            if (qualifier.length() > 0) {
                typeName = String.valueOf(qualifier) + "." + typeName;
            }
            return typeName;
        }
        return null;
    }

    public int getLineNumber() {
        String linkText = this.getLinkText();
        int index = linkText.lastIndexOf(58);
        if (index >= 0) {
            String numText = linkText.substring(index + 1);
            if ((index = numText.indexOf(41)) >= 0) {
                numText = numText.substring(0, index);
            }
            try {
                return Integer.parseInt(numText);
            }
            catch (NumberFormatException e) {
                BuildUIPlugin.log(e);
            }
        }
        return -1;
    }
}

