/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IJUnitTestCase;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.AbstractBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.junit.IJUnitRunErrorDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.junit.JUnitTestClassNode;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.repository.common.IContent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class JUnitTestCaseNode
extends AbstractBuildTreeNode
implements IJUnitRunErrorDetailProvider {
    private IJUnitTestCase fTestCase = null;
    private String fDetailString = null;

    public JUnitTestCaseNode(JUnitTestClassNode parentNode, IJUnitTestCase testCase) {
        super(parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"testCase", (Object)testCase);
        this.fTestCase = testCase;
    }

    public IJUnitTestCase getTestCase() {
        return this.fTestCase;
    }

    public Object[] doFetchChildren(IProgressMonitor monitor) {
        return null;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image newImage = BuildUIPlugin.getImage("icons/view16/junit.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.fTestCase.isError() || this.fTestCase.isFailure()) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage(newImage, status);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fTestCase.getName();
            }
            case 1: {
                return "1";
            }
            case 2: {
                return this.fTestCase.isFailure() ? "1" : "0";
            }
            case 3: {
                return this.fTestCase.isError() ? "1" : "0";
            }
            case 4: {
                return TimeFormatHelper.formatAbbreviatedTime(this.fTestCase.getTimeTaken());
            }
            case 5: {
                return String.valueOf(Integer.toString(this.fTestCase.getOrdinal())) + "    ";
            }
        }
        return null;
    }

    public int getColumnAsInt(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return 1;
            }
            case 2: {
                return this.fTestCase.isFailure() ? 1 : 0;
            }
            case 3: {
                return this.fTestCase.isError() ? 1 : 0;
            }
            case 4: {
                return (int)this.fTestCase.getTimeTaken();
            }
            case 5: {
                return this.fTestCase.getOrdinal();
            }
        }
        return 0;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean hasProblems() {
        return this.fTestCase.isError() || this.fTestCase.isFailure();
    }

    public String getNodeName() {
        return this.getJUnitClassName();
    }

    public String getJUnitClassName() {
        return this.fTestCase.getClassName();
    }

    public IContent getErrorData() {
        return this.fTestCase.getErrorData();
    }

    public IContent getFailureData() {
        return this.fTestCase.getFailureData();
    }

    public String getJUnitName() {
        return this.fTestCase.getName();
    }

    public long getTimeTaken() {
        return this.fTestCase.getTimeTaken();
    }

    public boolean isError() {
        return this.fTestCase.isError();
    }

    public boolean isFailure() {
        return this.fTestCase.isFailure();
    }

    public String getDetailString() {
        return this.fDetailString;
    }

    public void setDetailString(String detailString) {
        this.fDetailString = detailString;
    }
}

