/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditor;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.junit.CopyToClipboardAction;
import com.ibm.team.build.internal.ui.editors.result.junit.IJUnitDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.junit.IJUnitRunErrorDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.junit.JavaStackTraceConfiguration;
import com.ibm.team.build.internal.ui.editors.result.junit.Messages;
import com.ibm.team.build.internal.ui.editors.result.junit.ViewAction;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.helper.WorkspaceHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.FindReplaceAction;

public class JUnitDetailBlock {
    private Hyperlink fTestHyperlink;
    private Hyperlink fClassNameHyperlink;
    private Label fTimeTakenLabel;
    private StyledText fDetailText;
    private SourceViewer fDetailTextViewer;
    private Label fDetailLabel;
    private ActionFactory.IWorkbenchAction fCopyAction;
    private ActionFactory.IWorkbenchAction fSelectAllAction;
    private FindReplaceAction fFind;
    private FormEditor fEditor;
    private CopyToClipboardAction fCopyTrace;
    private DetailTextFocusListener fFocusListener;
    private IMenuListener fMenuListener;
    private Composite detailComposite;

    public Composite createContents(Composite parent, FormToolkit toolkit, FormEditor editor) {
        this.fEditor = editor;
        Composite composite = toolkit.createComposite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.detailComposite = toolkit.createComposite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.detailComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.detailComposite);
        this.createLabel(this.detailComposite, toolkit, Messages.JUnitDetailBlock_CLASS_NAME_LABEL);
        this.fClassNameHyperlink = toolkit.createHyperlink(this.detailComposite, "", 0);
        GridDataFactory.swtDefaults().applyTo((Control)this.fClassNameHyperlink);
        this.fClassNameHyperlink.addHyperlinkListener(this.getHyperlinkListener(false));
        this.fClassNameHyperlink.setVisible(false);
        this.createLabel(this.detailComposite, toolkit, Messages.JUnitDetailBlock_METHOD_LABEL);
        this.fTestHyperlink = toolkit.createHyperlink(this.detailComposite, "", 0);
        GridDataFactory.swtDefaults().applyTo((Control)this.fTestHyperlink);
        this.fTestHyperlink.addHyperlinkListener(this.getHyperlinkListener(true));
        this.fTestHyperlink.setVisible(false);
        this.createLabel(this.detailComposite, toolkit, Messages.JUnitDetailBlock_TIME_TAKEN_LABEL);
        this.fTimeTakenLabel = this.createLabel(this.detailComposite, toolkit, "");
        this.fDetailLabel = this.createLabel(this.detailComposite, toolkit, "");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fDetailLabel);
        this.fDetailLabel.setVisible(false);
        this.fDetailTextViewer = new SourceViewer(composite, null, 2826);
        this.fDetailTextViewer.configure((SourceViewerConfiguration)new JavaStackTraceConfiguration(editor.getEditorSite()));
        this.fDetailTextViewer.setDocument((IDocument)new Document());
        this.fDetailText = this.fDetailTextViewer.getTextWidget();
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.fDetailText);
        this.fDetailText.setVisible(false);
        this.fDetailText.addFocusListener(this.getDetailTextFocusListener());
        this.createActions(this.fEditor.getEditorSite(), parent);
        this.createContextMenu(this.fEditor.getEditorSite());
        return composite;
    }

    protected IHyperlinkListener getHyperlinkListener(final boolean testcase) {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (testcase) {
                    JUnitDetailBlock.this.openJUnitSourceFile(JUnitDetailBlock.this.fClassNameHyperlink.getText(), JUnitDetailBlock.this.fTestHyperlink.getText(), JUnitDetailBlock.this.fEditor.getEditorSite());
                } else {
                    JUnitDetailBlock.this.openJavaSourceFile(JUnitDetailBlock.this.fClassNameHyperlink.getText(), JUnitDetailBlock.this.fEditor.getEditorSite());
                }
            }
        };
    }

    protected boolean openJUnitSourceFile(String className, String junitTestName, IEditorSite editorSite) {
        return WorkspaceHelper.openJUnitSourceFile(className, junitTestName, editorSite);
    }

    protected boolean openJavaSourceFile(String className, IEditorSite editorSite) {
        return WorkspaceHelper.openJavaSourceFile(className, 1, editorSite);
    }

    protected FocusListener getDetailTextFocusListener() {
        if (this.fFocusListener == null) {
            this.fFocusListener = new DetailTextFocusListener();
        }
        return this.fFocusListener;
    }

    private void createContextMenu(IEditorSite site) {
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.getMenuListener());
        this.fCopyAction = ActionFactory.COPY.create(site.getWorkbenchWindow());
        this.setActionPart(this.fCopyAction);
        this.fSelectAllAction = ActionFactory.SELECT_ALL.create(site.getWorkbenchWindow());
        this.setActionPart(this.fSelectAllAction);
        this.fSelectAllAction.setEnabled(true);
        Menu menu = menuMgr.createContextMenu((Control)this.fDetailText);
        this.fDetailText.setMenu(menu);
        site.registerContextMenu(menuMgr, this.fDetailTextViewer.getSelectionProvider());
    }

    protected void setActionPart(ActionFactory.IWorkbenchAction action) {
        if (action instanceof RetargetAction) {
            ((RetargetAction)action).partActivated((IWorkbenchPart)this.getEditor());
        }
    }

    protected IMenuListener getMenuListener() {
        if (this.fMenuListener == null) {
            this.fMenuListener = new MenuListener();
        }
        return this.fMenuListener;
    }

    protected void fillContextMenu(IMenuManager menu) {
        if (this.fDetailTextViewer.getDocument() == null) {
            return;
        }
        this.fCopyAction.setEnabled(this.fDetailText.getSelectionText().length() > 0);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fCopyAction);
        menu.add((IAction)this.fCopyTrace);
        menu.add((IAction)this.fSelectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fFind);
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void createActions(final IEditorSite site, Composite parent) {
        IHandlerService handlerService = this.getHandlerService(site);
        ListResourceBundle findReplaceBundle = new ListResourceBundle(){
            private final Object[][] CONTENTS = new Object[][]{{"JUnit.Find.label", Messages.JUnitDetailBlock_FIND_ACTION_LABEL}, {"JUnit.Find.tooltip", Messages.JUnitDetailBlock_FIND_ACTION_TOOLTIP}, {"JUnit.Find.image", ""}, {"JUnit.Find.description", Messages.JUnitDetailBlock_FIND_ACTION_DESCRIPTION}};

            protected Object[][] getContents() {
                return this.CONTENTS;
            }
        };
        this.fFind = new FindReplaceAction((ResourceBundle)findReplaceBundle, "JUnit.Find.", site.getPart());
        this.fFind.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        ActionHandler findHandler = new ActionHandler((IAction)this.fFind);
        final IHandlerActivation findActivation = handlerService.activateHandler(this.fFind.getActionDefinitionId(), (IHandler)findHandler);
        this.fCopyTrace = new CopyToClipboardAction(this.fDetailTextViewer);
        this.fCopyTrace.setText(Messages.JUnitDetailBlock_COPY_STACK_TRACE_ACTION_LABEL);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IHandlerService service = JUnitDetailBlock.this.getHandlerService(site);
                if (service != null) {
                    service.deactivateHandler(findActivation);
                }
            }
        });
    }

    protected ViewAction createViewAction(ITextOperationTarget target, int operationCode) {
        return new ViewAction(target, operationCode);
    }

    protected IHandlerService getHandlerService(IEditorSite site) {
        return (IHandlerService)site.getService(IHandlerService.class);
    }

    protected void setDetailProvider(IJUnitDetailProvider provider, ITeamRepository teamRepository) {
        if (provider == null) {
            this.fClassNameHyperlink.setText("");
            this.fClassNameHyperlink.setVisible(false);
            this.fTestHyperlink.setText("");
            this.fTestHyperlink.setVisible(false);
            this.fTimeTakenLabel.setText("");
            this.fDetailLabel.setText("");
            this.fDetailText.setVisible(false);
        } else {
            this.fClassNameHyperlink.setText(provider.getJUnitClassName());
            ((GridData)this.fClassNameHyperlink.getLayoutData()).widthHint = this.fClassNameHyperlink.computeSize((int)-1, (int)-1, (boolean)true).x;
            this.fClassNameHyperlink.setVisible(this.fClassNameHyperlink.getText().length() > 0);
            this.fClassNameHyperlink.pack(true);
            this.fTestHyperlink.setText(provider.getJUnitName());
            ((GridData)this.fTestHyperlink.getLayoutData()).widthHint = this.fTestHyperlink.computeSize((int)-1, (int)-1, (boolean)true).x;
            this.fTestHyperlink.pack(true);
            this.fTestHyperlink.setVisible(this.fTestHyperlink.getText().length() > 0);
            this.fTimeTakenLabel.setText(TimeFormatHelper.formatTime(provider.getTimeTaken()));
            this.detailComposite.pack(true);
            if (provider instanceof IJUnitRunErrorDetailProvider) {
                this.updateDetailsAsynch((IJUnitRunErrorDetailProvider)provider, teamRepository);
            } else {
                this.fDetailText.setVisible(false);
                this.fDetailLabel.setText("");
            }
        }
    }

    private void updateDetailsAsynch(IJUnitRunErrorDetailProvider provider, ITeamRepository teamRepository) {
        Job job = this.getUpdateDetailsJob(provider, teamRepository);
        job.schedule();
    }

    protected Job getUpdateDetailsJob(final IJUnitRunErrorDetailProvider provider, final ITeamRepository teamRepository) {
        return new Job(BuildResultEditorMessages.JUnitDetailBlock_FETCHING_JUNIT_DETAILS){

            protected IStatus run(IProgressMonitor monitor) {
                String problemString = provider.getDetailString();
                String detailLabel = "";
                try {
                    if (provider.isError()) {
                        detailLabel = Messages.JUnitDetailBlock_ERROR_DETAIL_LABEL;
                        if (problemString == null) {
                            problemString = JUnitDetailBlock.this.getProblemContentAsString(provider.getErrorData(), teamRepository, monitor);
                            provider.setDetailString(problemString);
                        }
                    } else if (provider.isFailure()) {
                        detailLabel = Messages.JUnitDetailBlock_FAILURE_DETAIL_LABEL;
                        if (problemString == null) {
                            problemString = JUnitDetailBlock.this.getProblemContentAsString(provider.getFailureData(), teamRepository, monitor);
                            provider.setDetailString(problemString);
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    BuildUIPlugin.log(e);
                    problemString = NLS.bind((String)Messages.JUnitDetailBlock_FAILURE_TO_RETRIEVE_PROBLEM_DATA, (Object)e.toString());
                }
                final String finalProblemString = problemString == null ? "" : problemString;
                final String finalDetailLabel = detailLabel;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        JUnitDetailBlock.this.updateDetailArea(finalProblemString, finalDetailLabel);
                    }
                });
                return Status.OK_STATUS;
            }
        };
    }

    private Label createLabel(Composite parent, FormToolkit toolkit, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setLayoutData((Object)new GridData(text.length() == 0 ? 768 : 0));
        return label;
    }

    protected SourceViewer getDetailTextViewer() {
        return this.fDetailTextViewer;
    }

    protected Hyperlink getTestHyperlink() {
        return this.fTestHyperlink;
    }

    protected Hyperlink getClassNameHyperlink() {
        return this.fClassNameHyperlink;
    }

    protected Label getTimeTakenLabel() {
        return this.fTimeTakenLabel;
    }

    protected Label getDetailLabel() {
        return this.fDetailLabel;
    }

    protected StyledText getDetailText() {
        return this.fDetailText;
    }

    protected FormEditor getEditor() {
        return this.fEditor;
    }

    protected String getProblemContentAsString(IContent contentToRetrieve, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return ContentUtil.contentToString((ITeamRepository)teamRepository, (IContent)contentToRetrieve, (IProgressMonitor)monitor);
    }

    protected void updateDetailArea(String problemString, String detailLabel) {
        if (!this.fDetailLabel.isDisposed()) {
            this.fDetailLabel.setText(detailLabel);
            this.fDetailLabel.setVisible(true);
            this.fDetailTextViewer.getDocument().set(problemString);
            this.fDetailText.setVisible(problemString.length() != 0);
        }
    }

    private final class DetailTextFocusListener
    implements FocusListener {
        private DetailTextFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            ((BuildResultEditor)JUnitDetailBlock.this.fEditor).setFindReplaceTarget(null);
            JUnitDetailBlock.this.fFind.update();
        }

        public void focusGained(FocusEvent e) {
            ((BuildResultEditor)JUnitDetailBlock.this.fEditor).setFindReplaceTarget(JUnitDetailBlock.this.fDetailTextViewer.getFindReplaceTarget());
            JUnitDetailBlock.this.fFind.update();
        }
    }

    private final class MenuListener
    implements IMenuListener {
        private MenuListener() {
        }

        public void menuAboutToShow(IMenuManager mgr) {
            JUnitDetailBlock.this.fillContextMenu(mgr);
        }
    }
}

