/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.AbstractBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.junit.JUnitBuildResultNode;
import com.ibm.team.build.internal.ui.editors.result.junit.JUnitTestSuiteNode;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class JUnitComponentNode
extends AbstractBuildTreeNode {
    private List<IBuildResultContribution> fBuildResultContributions = new ArrayList<IBuildResultContribution>();
    private List<IJUnitTestSuiteContribution> fTestSuites = new ArrayList<IJUnitTestSuiteContribution>();
    private String fComponentName;

    public JUnitComponentNode(JUnitBuildResultNode parentNode, String componentName) {
        super(parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        this.fComponentName = componentName;
    }

    public void addContribution(IBuildResultContribution contribution, IJUnitTestSuiteContribution testSuite) {
        this.fBuildResultContributions.add(contribution);
        this.fTestSuites.add(testSuite);
    }

    public boolean hasChildren() {
        return true;
    }

    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] testSuiteNodes = new JUnitTestSuiteNode[this.fTestSuites.size()];
        int i = 0;
        while (i < this.fTestSuites.size()) {
            IJUnitTestSuiteContribution testSuite = this.fTestSuites.get(i);
            testSuiteNodes[i] = new JUnitTestSuiteNode(this, this.fBuildResultContributions.get(i), testSuite);
            ++i;
        }
        return testSuiteNodes;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image image = BuildUIPlugin.getImage("icons/obj16/component_obj.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.componentContainsErrors()) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage(image, status);
        }
        return null;
    }

    private boolean componentContainsErrors() {
        for (IBuildResultContribution contribution : this.fBuildResultContributions) {
            if (contribution.getStatus() != BuildStatus.ERROR) continue;
            return true;
        }
        return false;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getNodeName();
            }
            case 1: {
                return Integer.toString(this.getTestCount());
            }
            case 2: {
                return Integer.toString(this.getFailureCount());
            }
            case 3: {
                return Integer.toString(this.getErrorCount());
            }
            case 4: {
                return TimeFormatHelper.formatAbbreviatedTime(this.getTimeTaken());
            }
        }
        return null;
    }

    private int getTestCount() {
        int testCount = 0;
        for (IJUnitTestSuiteContribution testSuite : this.fTestSuites) {
            testCount += testSuite.getTestCount();
        }
        return testCount;
    }

    private int getFailureCount() {
        int failureCount = 0;
        for (IJUnitTestSuiteContribution testSuite : this.fTestSuites) {
            failureCount += testSuite.getFailureCount();
        }
        return failureCount;
    }

    private int getErrorCount() {
        int errorCount = 0;
        for (IJUnitTestSuiteContribution testSuite : this.fTestSuites) {
            errorCount += testSuite.getErrorCount();
        }
        return errorCount;
    }

    private long getTimeTaken() {
        long timeTaken = 0L;
        for (IBuildResultContribution contribution : this.fBuildResultContributions) {
            timeTaken += contribution.getTimeTaken();
        }
        return timeTaken;
    }

    public int getColumnAsInt(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return this.getTestCount();
            }
            case 2: {
                return this.getFailureCount();
            }
            case 3: {
                return this.getErrorCount();
            }
            case 4: {
                return (int)this.getTimeTaken();
            }
        }
        return 0;
    }

    public boolean hasProblems() {
        return this.getErrorCount() > 0 || this.getFailureCount() > 0;
    }

    public String getNodeName() {
        if (this.fComponentName == null || this.fComponentName.equals("")) {
            return BuildResultEditorMessages.NO_COMPONENT_LABEL;
        }
        return this.fComponentName;
    }
}

