/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.junit;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.common.model.IJUnitTestSuiteContributionHandle;
import com.ibm.team.build.internal.ui.editors.result.AbstractBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.junit.JUnitComponentNode;
import com.ibm.team.build.internal.ui.editors.result.junit.JUnitTestSuiteNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitBuildResultNode
extends AbstractBuildTreeNode {
    private static final List PARTIAL_TEST_SUITE_PROPERTIES = new LinkedList();
    private IBuildResultContribution[] fBuildResultContributions;
    private Map<String, JUnitComponentNode> fComponentNodeMap = new HashMap<String, JUnitComponentNode>();
    private JUnitComponentNode fUnnamedComponentNode;

    static {
        PARTIAL_TEST_SUITE_PROPERTIES.add(IJUnitTestSuiteContribution.PROPERTY_ERROR_DATA);
        PARTIAL_TEST_SUITE_PROPERTIES.add(IJUnitTestSuiteContribution.PROPERTY_ERROR_COUNT);
        PARTIAL_TEST_SUITE_PROPERTIES.add(IJUnitTestSuiteContribution.PROPERTY_FAILURE_COUNT);
        PARTIAL_TEST_SUITE_PROPERTIES.add(IJUnitTestSuiteContribution.PROPERTY_TEST_COUNT);
        PARTIAL_TEST_SUITE_PROPERTIES.add(IJUnitTestSuiteContribution.PROPERTY_TEST_SUITE_CLASS_NAME);
    }

    public JUnitBuildResultNode(IBuildResultContribution[] buildResultContributions) {
        super(null);
        this.fBuildResultContributions = buildResultContributions;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] children = null;
        if (this.fBuildResultContributions.length > 0) {
            List<IJUnitTestSuiteContribution> testSuites = this.fetchTestSuites(this.fBuildResultContributions, monitor);
            children = this.hasComponents(this.fBuildResultContributions) ? this.getComponentNodes(this.fBuildResultContributions, testSuites) : this.getTestSuiteNodes(this.fBuildResultContributions, testSuites, monitor);
        }
        return children;
    }

    protected List<IJUnitTestSuiteContribution> fetchTestSuites(IBuildResultContribution[] contributions, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IJUnitTestSuiteContribution> testSuites = new ArrayList<IJUnitTestSuiteContribution>();
        ArrayList<IJUnitTestSuiteContributionHandle> testSuiteHandles = new ArrayList<IJUnitTestSuiteContributionHandle>();
        ITeamRepository teamRepository = (ITeamRepository)contributions[0].getExtendedContribution().getOrigin();
        IBuildResultContribution[] iBuildResultContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            testSuiteHandles.add((IJUnitTestSuiteContributionHandle)contribution.getExtendedContribution());
            ++n2;
        }
        testSuites.addAll(teamRepository.itemManager().fetchPartialItems(testSuiteHandles, 0, (Collection)PARTIAL_TEST_SUITE_PROPERTIES, monitor));
        return testSuites;
    }

    private IDeferredBuildTreeNode[] getTestSuiteNodes(IBuildResultContribution[] contributions, List<IJUnitTestSuiteContribution> testSuites, IProgressMonitor monitor) {
        ArrayList<JUnitTestSuiteNode> testSuiteNodes = new ArrayList<JUnitTestSuiteNode>(testSuites.size());
        int i = 0;
        while (i < testSuites.size()) {
            testSuiteNodes.add(new JUnitTestSuiteNode(this, contributions[i], testSuites.get(i)));
            ++i;
        }
        return testSuiteNodes.toArray(new IDeferredBuildTreeNode[testSuiteNodes.size()]);
    }

    private IDeferredBuildTreeNode[] getComponentNodes(IBuildResultContribution[] contributions, List<IJUnitTestSuiteContribution> testSuites) {
        this.fComponentNodeMap.clear();
        int i = 0;
        while (i < contributions.length) {
            JUnitComponentNode node = this.getComponentNode(contributions[i]);
            node.addContribution(contributions[i], testSuites.get(i));
            ++i;
        }
        return this.fComponentNodeMap.values().toArray(new IDeferredBuildTreeNode[this.fComponentNodeMap.size()]);
    }

    private JUnitComponentNode getComponentNode(IBuildResultContribution contribution) {
        JUnitComponentNode node = null;
        if (contribution.getComponentName() != null) {
            node = this.fComponentNodeMap.get(contribution.getComponentName());
            if (node == null) {
                node = new JUnitComponentNode(this, contribution.getComponentName());
                this.fComponentNodeMap.put(contribution.getComponentName(), node);
            }
        } else {
            node = this.getUnnamedComponentNode();
        }
        return node;
    }

    private JUnitComponentNode getUnnamedComponentNode() {
        if (this.fUnnamedComponentNode == null) {
            this.fUnnamedComponentNode = new JUnitComponentNode(this, null);
        }
        return this.fUnnamedComponentNode;
    }

    private boolean hasComponents(IBuildResultContribution[] contributions) {
        IBuildResultContribution[] iBuildResultContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            if (contribution.getComponentName() != null && contribution.getComponentName().length() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        return null;
    }

    @Override
    public String getColumnText(int columnIndex) {
        return null;
    }

    @Override
    public int getColumnAsInt(int columnIndex) {
        return 0;
    }

    @Override
    public boolean hasProblems() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }
}

