/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.download;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.IBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.download.DownloadContributionNode;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class DownloadsComponentNode
implements IBuildTreeNode {
    private String fComponentName = null;
    private IBuildTreeNode fParentNode;
    private List<DownloadContributionNode> fNodes = new ArrayList<DownloadContributionNode>();
    private Object[] fChildren;
    private ITeamRepository fRepository;

    public DownloadsComponentNode(IBuildTreeNode parent, String componentName, ITeamRepository repository) {
        ValidationHelper.validateNotNull((String)"parent", (Object)parent);
        ValidationHelper.validateNotNull((String)"componentName", (Object)componentName);
        ValidationHelper.validateNotNull((String)"repository", (Object)repository);
        this.fParentNode = parent;
        this.fComponentName = componentName.length() == 0 ? BuildResultEditorMessages.NO_COMPONENT_LABEL : componentName;
        this.fRepository = repository;
    }

    public DownloadContributionNode add(IBuildResultContribution contribution) {
        DownloadContributionNode node = new DownloadContributionNode(this, contribution, this.fRepository);
        this.fNodes.add(node);
        this.fChildren = this.fNodes.toArray();
        return node;
    }

    public int remove(DownloadContributionNode node) {
        this.fNodes.remove(node);
        this.fChildren = this.fNodes.toArray();
        return this.fNodes.size();
    }

    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = this.fNodes.toArray();
        }
        return this.fChildren;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            return BuildUIPlugin.getImage("icons/obj16/component_obj.gif");
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fComponentName;
            }
        }
        return null;
    }

    public int getColumnAsInt(int columnIndex) {
        return 0;
    }

    public String getNodeName() {
        return this.fComponentName;
    }

    public IBuildTreeNode getParentNode() {
        return this.fParentNode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DownloadsComponentNode)) {
            return false;
        }
        return this.fComponentName.equals(((DownloadsComponentNode)object).getNodeName());
    }

    public int hashCode() {
        return this.fComponentName.hashCode();
    }
}

