/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.compile;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.editors.result.compile.AbstractCompileTreeNode;
import com.ibm.team.build.internal.ui.editors.result.compile.CompilePackageNode;
import com.ibm.team.build.internal.ui.editors.result.compile.IComplexCompileDetailProvider;
import com.ibm.team.build.internal.ui.editors.result.compile.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class CompileSourceNode
extends AbstractCompileTreeNode
implements IComplexCompileDetailProvider {
    private ICompileSource fCompileSource;

    public CompileSourceNode(CompilePackageNode parentNode, ICompileSource compileSource) {
        super(parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"compileSource", (Object)compileSource);
        this.fCompileSource = compileSource;
    }

    public ICompileSource getCompileSource() {
        return this.fCompileSource;
    }

    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            ISharedImages sharedImages = JavaUI.getSharedImages();
            Image newImage = sharedImages.getImage("org.eclipse.jdt.ui.jcu_obj.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.fCompileSource.getWarningCount() > 0) {
                status = BuildStatus.WARNING;
            }
            if (this.fCompileSource.getErrorCount() > 0) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage(newImage, status, false);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fCompileSource.getSourceName();
            }
            case 2: {
                return Integer.toString(this.fCompileSource.getWarningCount());
            }
            case 1: {
                return Integer.toString(this.fCompileSource.getErrorCount());
            }
        }
        return null;
    }

    public int getColumnAsInt(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return this.fCompileSource.getWarningCount();
            }
            case 1: {
                return this.fCompileSource.getErrorCount();
            }
        }
        return 0;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getNodeName() {
        return this.fCompileSource.getSourceName();
    }

    public boolean hasProblems() {
        return this.fCompileSource.getErrorCount() > 0 || this.fCompileSource.getWarningCount() > 0;
    }

    public boolean hasWarnings() {
        return this.fCompileSource.getWarningCount() > 0;
    }

    public boolean hasErrors() {
        return this.fCompileSource.getErrorCount() > 0;
    }

    public ICompileProblem[] getErrors(IProgressMonitor monitor) throws TeamRepositoryException {
        List errors = this.fCompileSource.getErrors();
        return errors.toArray(new ICompileProblem[errors.size()]);
    }

    public ICompileProblem[] getWarnings(IProgressMonitor monitor) throws TeamRepositoryException {
        List warnings = this.fCompileSource.getWarnings();
        return warnings.toArray(new ICompileProblem[warnings.size()]);
    }

    public String getErrorDetails(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getDetails("ERROR", this.fCompileSource.getErrors());
    }

    public String getWarningDetails(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getDetails("WARNING", this.fCompileSource.getWarnings());
    }

    private String getDetails(String type, Collection problems) {
        StringBuffer details = new StringBuffer();
        for (Object object : problems) {
            ICompileProblem problem = (ICompileProblem)object;
            details.append(NLS.bind((String)Messages.CompileSourceNode_PROBLEM_STRING, (Object[])new String[]{String.valueOf(problem.getLineNumber()), type, problem.getMessageText(), problem.getSourceText()}));
            int spaces = problem.getSourceStart() + 4;
            while (spaces-- > 0) {
                details.append(' ');
            }
            int carets = problem.getSourceEnd() - problem.getSourceStart();
            while (carets-- >= 0) {
                details.append('^');
            }
            details.append('\n');
            details.append('\n');
        }
        return new String(details);
    }
}

