/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.compile;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompileContributionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.compile.AbstractCompileTreeNode;
import com.ibm.team.build.internal.ui.editors.result.compile.CompileComponentNode;
import com.ibm.team.build.internal.ui.editors.result.compile.ICompileTreeNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileBuildResultNode
extends AbstractCompileTreeNode {
    private static final List PARTIAL_COMPILE_CONTRIBUTION_PROPERTIES = new LinkedList();
    private IBuildResultContribution[] fBuildResultContributions;
    private Hashtable<String, CompileComponentNode> fComponentNodeMap = new Hashtable();

    static {
        PARTIAL_COMPILE_CONTRIBUTION_PROPERTIES.add(ICompileContribution.PROPERTY_ERRORS);
        PARTIAL_COMPILE_CONTRIBUTION_PROPERTIES.add(ICompileContribution.PROPERTY_WARNINGS);
        PARTIAL_COMPILE_CONTRIBUTION_PROPERTIES.add(ICompileContribution.PROPERTY_ERROR_COUNT);
        PARTIAL_COMPILE_CONTRIBUTION_PROPERTIES.add(ICompileContribution.PROPERTY_WARNING_COUNT);
        PARTIAL_COMPILE_CONTRIBUTION_PROPERTIES.add(ICompileContribution.PROPERTY_CLASS_COUNT);
    }

    public CompileBuildResultNode(IBuildResultContribution[] buildResultContributions) {
        super(null);
        ValidationHelper.validateNotNull((String)"buildResultContributions", (Object[])buildResultContributions);
        this.fBuildResultContributions = buildResultContributions;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] children = null;
        if (this.fBuildResultContributions.length > 0) {
            Enumeration<String> componentNames;
            String name;
            List<ICompileContribution> compileContributions = this.fetchCompileContributions(this.fBuildResultContributions, monitor);
            this.createComponentNodeChildren(this.fBuildResultContributions, compileContributions);
            if (this.fComponentNodeMap.size() == 1 && (name = (componentNames = this.fComponentNodeMap.keys()).nextElement()).length() == 0) {
                children = (ICompileTreeNode[])this.fComponentNodeMap.get(name).fetchChildren(monitor);
            }
            if (children == null) {
                children = this.fComponentNodeMap.values().toArray(new ICompileTreeNode[this.fComponentNodeMap.size()]);
            }
        }
        return children;
    }

    protected void logException(TeamRepositoryException exception) {
        BuildUIPlugin.log(exception);
    }

    private void createComponentNodeChildren(IBuildResultContribution[] contributions, List<ICompileContribution> compileContributions) {
        int i = 0;
        while (i < contributions.length) {
            CompileComponentNode node;
            String componentName = contributions[i].getComponentName();
            if (componentName == null) {
                componentName = "";
            }
            if ((node = this.fComponentNodeMap.get(componentName)) == null) {
                node = new CompileComponentNode(this, componentName);
                this.fComponentNodeMap.put(componentName, node);
            }
            node.addCompileContribution(contributions[i], compileContributions.get(i));
            ++i;
        }
    }

    private List<ICompileContribution> fetchCompileContributions(IBuildResultContribution[] contributions, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<ICompileContribution> compileContributions = new ArrayList<ICompileContribution>();
        ArrayList<ICompileContributionHandle> compileContributionHandles = new ArrayList<ICompileContributionHandle>();
        IBuildResultContribution[] iBuildResultContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            compileContributionHandles.add((ICompileContributionHandle)contribution.getExtendedContribution());
            ++n2;
        }
        ITeamRepository teamRepository = (ITeamRepository)contributions[0].getExtendedContribution().getOrigin();
        compileContributions.addAll(teamRepository.itemManager().fetchPartialItems(compileContributionHandles, 0, (Collection)PARTIAL_COMPILE_CONTRIBUTION_PROPERTIES, monitor));
        return compileContributions;
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        return null;
    }

    @Override
    public String getColumnText(int columnIndex) {
        return null;
    }

    @Override
    public int getColumnAsInt(int columnIndex) {
        return 0;
    }

    @Override
    public boolean hasProblems() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public boolean hasWarnings() {
        return false;
    }

    @Override
    public boolean hasErrors() {
        return false;
    }
}

