/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.StatusLineHyperlinkListener;
import com.ibm.team.build.internal.ui.helper.RepositoryFileHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class FileContentHyperlinkListener
extends StatusLineHyperlinkListener
implements Listener {
    private final ITeamRepository fTeamRepository;

    public FileContentHyperlinkListener(IEditorPart part, ITeamRepository repository) {
        super(part);
        this.fTeamRepository = repository;
    }

    public void linkActivated(HyperlinkEvent e) {
        IBuildResultContribution contribution = (IBuildResultContribution)((Hyperlink)e.getSource()).getData();
        IContent content = contribution.getExtendedContributionData();
        String fileName = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
        if (content != null && content.getRawLength() > 0L) {
            this.saveRepositoryFile(fileName, content, this.fTeamRepository, this.getEditorPart().getEditorSite());
        }
    }

    protected void saveRepositoryFile(String fileName, IContent content, ITeamRepository teamRepository, IEditorSite editorSite) {
        RepositoryFileHelper.saveRepositoryFile(fileName, content, teamRepository, editorSite.getShell());
    }
}

