/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.editors.result.BuildLabelProvider;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TreeColumn;

public class BuildResultsTreeViewerComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int comparison;
        this.validate(viewer);
        TreeViewer treeViewer = (TreeViewer)viewer;
        TreeColumn sortColumn = treeViewer.getTree().getSortColumn();
        if (treeViewer.getTree().getSortColumn() == null) {
            return super.compare(viewer, e1, e2);
        }
        int sortingColumnIndex = treeViewer.getTree().indexOf(sortColumn);
        BuildLabelProvider prov = (BuildLabelProvider)((ContentViewer)viewer).getLabelProvider();
        switch (sortingColumnIndex) {
            case 0: {
                String name1 = prov.getColumnText(e1, 0);
                String name2 = prov.getColumnText(e2, 0);
                if (name1.equals(BuildResultEditorMessages.NO_COMPONENT_LABEL)) {
                    comparison = 1;
                    break;
                }
                if (name2.equals(BuildResultEditorMessages.NO_COMPONENT_LABEL)) {
                    comparison = -1;
                    break;
                }
                comparison = this.getComparator().compare(name1, name2);
                break;
            }
            default: {
                int val1 = prov.getColumnAsInt(e1, sortingColumnIndex);
                int val2 = prov.getColumnAsInt(e2, sortingColumnIndex);
                if (val1 != 0 || val2 != 0) {
                    comparison = val1 - val2;
                    break;
                }
                String name1 = prov.getColumnText(e1, 0);
                String name2 = prov.getColumnText(e2, 0);
                comparison = name1 != null && name2 != null ? this.getComparator().compare(name1, name2) : 0;
            }
        }
        return treeViewer.getTree().getSortDirection() == 128 ? comparison : -comparison;
    }

    private void validate(Viewer viewer) throws IllegalArgumentException {
        ValidationHelper.validateIsType((String)"viewer", TreeViewer.class, (Object)viewer);
        ValidationHelper.validateIsType((String)"viewer.getLabelProvider()", BuildLabelProvider.class, (Object)((ContentViewer)viewer).getLabelProvider());
    }
}

