/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class BuildResultEditorInput
implements IEditorInput {
    private IBuildResultRecord fResultRecord;
    private ITeamRepository fTeamRepository;
    private String fUUIDValue = null;

    public BuildResultEditorInput(IBuildResultRecord resultRecord, ITeamRepository teamRepository) {
        this.fResultRecord = resultRecord;
        this.fTeamRepository = teamRepository;
    }

    public IBuildResult getResult() {
        return this.fResultRecord.getBuildResult();
    }

    public IBuildResultRecord getResultRecord() {
        return this.fResultRecord;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.fResultRecord != null) {
            String name = this.fResultRecord.getBuildResult().getLabel();
            if (name == null || name.equals("")) {
                name = this.fResultRecord.getBuildDefinition().getId();
            }
            return name;
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.fResultRecord != null) {
            return this.fResultRecord.getBuildResult().getLabel();
        }
        return "";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildResultEditorInput)) {
            return false;
        }
        BuildResultEditorInput input = (BuildResultEditorInput)obj;
        return this.getResultUUIDValue().equals(input.getResultUUIDValue());
    }

    public int hashCode() {
        return this.getResultUUIDValue().hashCode();
    }

    public String getResultUUIDValue() {
        if (this.fUUIDValue == null) {
            this.fUUIDValue = this.fResultRecord.getBuildResult().getItemId().getUuidValue();
        }
        return this.fUUIDValue;
    }
}

