/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.MultipleErrorTeamBuildException;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.IBuildResultRecordListener;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultStatusTrend;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildJob;
import com.ibm.team.build.internal.ui.BuildStatusCompositeImageDescriptor;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.BuildItemEditorJob;
import com.ibm.team.build.internal.ui.editors.result.BuildResultContributionExtension;
import com.ibm.team.build.internal.ui.editors.result.BuildResultContributionExtensionManager;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorInput;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.summary.BuildResultSummaryPage;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultEditor
extends BuildItemEditor
implements IBuildResultContext,
ISharedItemChangeListener,
IBuildResultRecordListener {
    protected static final String PAGE_ID_SUMMARY = "com.ibm.team.build.editor.summarypage";
    private static final int STATUS_TREND_ITEM_COUNT = 14;
    private static final String MESSAGE_KEY_REFRESH = "refreshKey";
    protected List<AbstractBuildResultContributionProvider> fContributionProviders = null;
    protected Map<String, AbstractBuildResultContributionProvider> fPageIdToProviderMap = new Hashtable<String, AbstractBuildResultContributionProvider>();
    private String[] fContributionIds = null;
    private IBuildResultRecord fResultRecord;
    private IBuildResultContribution[] fResultContributions;
    private IBuildResultStatusTrend fBuildResultStatusTrend;
    protected IBuildResult fBuildResultWorkingCopy;
    private Map<AbstractBuildResultPage.PageGroup, Integer> fPageIndices = new EnumMap<AbstractBuildResultPage.PageGroup, Integer>(AbstractBuildResultPage.PageGroup.class);
    private Job fFetchJob;
    private IFindReplaceTarget fFindReplaceTarget;
    private Form fHeaderForm;
    protected Action fRequestBuildAction;
    protected Action fRequestRebuildAction;
    private LocalResourceManager fResourceManager;
    private BuildResultSummaryPage fSummaryPage;
    protected boolean fDirty;
    private UUID fLastSavedBuildResultStateId;

    public BuildResultEditor() {
        for (AbstractBuildResultPage.PageGroup group : EnumSet.range(AbstractBuildResultPage.PageGroup.SUMMARY, AbstractBuildResultPage.PageGroup.LAST)) {
            this.fPageIndices.put(group, 0);
        }
    }

    protected FormToolkit createToolkit(Display display) {
        FormColors formColors = new FormColors(display){

            protected void initializeColorTable() {
                super.initializeColorTable();
                this.initializeFormHeaderColors();
            }
        };
        return new FormToolkit(formColors);
    }

    @Override
    protected void createHeaderContents(IManagedForm headerForm) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getEditorSite().getShell());
        this.initializeBuildResult();
        this.fHeaderForm = headerForm.getForm().getForm();
        IToolBarManager toolBarManager = this.fHeaderForm.getToolBarManager();
        this.fRequestBuildAction = new Action(BuildResultEditorMessages.BuildResultEditor_REQUEST_BUILD_ACTION, 1){

            public ImageDescriptor getImageDescriptor() {
                return BuildUIPlugin.getImageDescriptor("icons/elcl16/rquebuild.gif");
            }

            public void run() {
                BuildResultEditor.this.handleRequestBuild(false);
            }
        };
        this.fRequestRebuildAction = new Action(BuildResultEditorMessages.BuildResultEditor_REQUEST_REBUILD_ACTION, 1){

            public ImageDescriptor getImageDescriptor() {
                return BuildUIPlugin.getImageDescriptor("icons/elcl16/req_rebuild_co.gif");
            }

            public void run() {
                BuildResultEditor.this.handleRequestBuild(true);
            }
        };
        toolBarManager.add((IAction)this.fRequestBuildAction);
        toolBarManager.add((IAction)this.fRequestRebuildAction);
        this.fHeaderForm.updateToolBar();
        this.createContextMenu(this.fHeaderForm);
        this.fHeaderForm.addMessageHyperlinkListener(this.getRefreshHyperlinkListener());
        super.createHeaderContents(headerForm);
    }

    protected IHyperlinkListener getRefreshHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IMessage[] messages = (IMessage[])e.getHref();
                if (messages.length == 1 && BuildResultEditor.MESSAGE_KEY_REFRESH.equals(messages[0].getKey())) {
                    BuildResultEditor.this.removeHeaderMessage(BuildResultEditor.MESSAGE_KEY_REFRESH);
                    BuildResultEditor.this.fRefreshAction.run();
                }
            }
        };
    }

    protected void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.getMenuListener());
        if (menuMgr instanceof MenuManager) {
            this.getSite().registerContextMenu(this.getSite().getId(), (MenuManager)menuMgr, this.getSelectionProvider());
        }
    }

    protected IMenuListener getMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
            }
        };
    }

    protected ISelectionProvider getSelectionProvider() {
        return new ISelectionProvider(){

            public ISelection getSelection() {
                return new StructuredSelection((Object)BuildResultEditor.this.fResultRecord);
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
    }

    protected Action getRequestBuildAction() {
        return this.fRequestBuildAction;
    }

    protected Action getRequestRebuildAction() {
        return this.fRequestRebuildAction;
    }

    protected void handleRequestBuild(boolean isRebuild) {
        RequestBuildDialog dialog = this.createRequestBuildDialog(isRebuild);
        dialog.open();
    }

    protected RequestBuildDialog createRequestBuildDialog(boolean isRebuild) {
        if (isRebuild) {
            return new RequestBuildDialog(this.getEditorSite().getShell(), (IBuildResultHandle)this.fResultRecord.getBuildResult(), true);
        }
        return new RequestBuildDialog(this.getEditorSite().getShell(), (IBuildDefinitionHandle)this.fResultRecord.getBuildDefinition());
    }

    @Override
    protected String getBuildItemTypeName() {
        return BuildResultEditorMessages.BuildResultEditor_BUILD_RESULT_ITEM_NAME;
    }

    protected List<AbstractBuildResultContributionProvider> getContributionProviders() {
        if (this.fContributionProviders == null) {
            BuildResultContributionExtension[] extensions;
            this.fContributionProviders = new LinkedList<AbstractBuildResultContributionProvider>();
            BuildResultContributionExtension[] buildResultContributionExtensionArray = extensions = this.getAllContributionExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                BuildResultContributionExtension extension = buildResultContributionExtensionArray[n2];
                try {
                    this.fContributionProviders.add(this.createContributionProvider(extension));
                }
                catch (CoreException exception) {
                    this.logException((Exception)((Object)exception));
                }
                catch (IllegalArgumentException exception) {
                    this.logException(exception);
                }
                ++n2;
            }
        }
        return this.fContributionProviders;
    }

    @Override
    protected String getHeaderTitleText() {
        if (this.getBuildResult().isPersonalBuild()) {
            return NLS.bind((String)BuildResultEditorMessages.BuildResultEditor_BUILD_RESULT_HEADER_TEXT_PERSONAL_BUILD, (Object[])new String[]{this.getBuildResultRecord().getBuildDefinition().getId(), this.getBuildResultRecord().getRequestor().getName(), this.getBuildResult().getLabel()});
        }
        return NLS.bind((String)BuildResultEditorMessages.BuildResultEditor_BUILD_RESULT_HEADER_TEXT, (Object)this.getBuildResultRecord().getBuildDefinition().getId(), (Object)this.getBuildResult().getLabel());
    }

    @Override
    protected Image getHeaderTitleImage() {
        Image image = BuildUIPlugin.getImage("icons/obj16/bld_rslt.gif");
        if (this.fResultRecord.getBuildResult().isPersonalBuild()) {
            image = BuildCompositeImageRegistry.getPersonalBuildImage(image);
        }
        return image;
    }

    protected void addPages() {
        this.setPartName(this.fResultRecord.getBuildResult().getLabel());
        this.fSummaryPage = this.createBuildResultSummaryPage();
        this.fSummaryPage.setNeedsContentRefreshed(false);
        try {
            this.addPage(this.fSummaryPage, AbstractBuildResultPage.PageGroup.SUMMARY);
        }
        catch (PartInitException exception) {
            throw new RuntimeException(exception);
        }
        BuildResultEditorInput input = (BuildResultEditorInput)this.getEditorInput();
        this.initializeDataAndPages(input.getTeamRepository());
        input.getTeamRepository().itemManager().addItemChangeListener((IItem)this.fResultRecord.getBuildResult(), (ISharedItemChangeListener)this);
    }

    protected BuildResultSummaryPage createBuildResultSummaryPage() {
        List<AbstractBuildResultContributionProvider> providers = this.getContributionProviders();
        return new BuildResultSummaryPage(this, PAGE_ID_SUMMARY, BuildResultEditorMessages.BuildResultEditor_SUMMARY_PAGE_TITLE, providers.toArray(new AbstractBuildResultContributionProvider[providers.size()]), (IBuildResultContext)this);
    }

    protected void initializeBuildResult() {
        BuildResultEditorInput input = (BuildResultEditorInput)this.getEditorInput();
        this.fResultRecord = input.getResultRecord();
        this.fLastSavedBuildResultStateId = this.fResultRecord.getBuildResult().getStateId();
        this.fBuildResultWorkingCopy = (IBuildResult)this.fResultRecord.getBuildResult().getWorkingCopy();
    }

    public void itemsChanged(List events) {
        Iterator iter = events.iterator();
        boolean isUpdateNeeded = false;
        IBuildResult beforeResult = null;
        while (iter.hasNext()) {
            ISharedItemChangeEvent event = (ISharedItemChangeEvent)iter.next();
            if (!event.getSharedItem().getItemId().equals((Object)this.fResultRecord.getBuildResult().getItemId())) continue;
            IBuildResult afterResult = (IBuildResult)event.getAfterState();
            beforeResult = (IBuildResult)event.getBeforeState();
            if (afterResult == null || beforeResult == null) continue;
            isUpdateNeeded = true;
            break;
        }
        if (isUpdateNeeded) {
            this.createUpdateJob(beforeResult).schedule();
        }
    }

    protected BuildItemEditorJob createUpdateJob(final IBuildResult buildResult) {
        String jobName = BuildResultEditorMessages.BuildResultEditor_FETCHING_DATA_JOB_TITLE;
        return new BuildItemEditorJob(jobName, false, this){

            public void internalRunProtected(IProgressMonitor monitor) throws Exception {
                BuildResultEditor.this.updatePages(buildResult, monitor);
            }
        };
    }

    protected void updatePages(IBuildResult beforeResult, IProgressMonitor monitor) throws Exception {
        if (this.isDisposed()) {
            return;
        }
        this.addRefreshWarningMessageIfItemChanged();
        if (this.isDirty()) {
            return;
        }
        IBuildResultRecord buildResultRecord = this.getRecordClient().getBuildResultRecord((IBuildResultHandle)this.fResultRecord.getBuildResult(), IBuildResult.PROPERTIES_COMPLETE, monitor);
        IBuildResult result = (IBuildResult)this.fResultRecord.getBuildResult().getWorkingCopy();
        IBuildResultStatusTrend buildResultStatusTrend = this.getRecordClient().getBuildResultStatusTrend((IBuildResultHandle)this.fResultRecord.getBuildResult(), 14, monitor);
        if (this.isDisposed()) {
            return;
        }
        this.fResultRecord = buildResultRecord;
        this.fBuildResultWorkingCopy = result;
        this.fBuildResultStatusTrend = buildResultStatusTrend;
        for (AbstractBuildResultPage nextPage : this.pages) {
            nextPage.handleBuildResultChanged(beforeResult);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!BuildResultEditor.this.isDisposed()) {
                    BuildResultEditor.this.updateTitleTab();
                    BuildResultEditor.this.updateHeaderFormText(BuildResultEditor.this.getHeaderTitleText());
                }
            }
        });
    }

    protected void updateHeaderFormText(String text) {
        this.fHeaderForm.setText(this.getHeaderTitleText());
    }

    private void addRefreshWarningMessageIfItemChanged() {
        this.asyncExec(new Runnable(){

            public void run() {
                IBuildResult sharedResult;
                if (!BuildResultEditor.this.isDisposed() && (sharedResult = BuildResultEditor.this.getSharedBuildResultIfKnown()) != null && !sharedResult.getStateId().equals((Object)BuildResultEditor.this.fLastSavedBuildResultStateId)) {
                    BuildResultEditor.this.addLifecycleErrorMessage(BuildResultEditor.MESSAGE_KEY_REFRESH, BuildResultEditorMessages.BuildResultEditor_REFRESH_FOR_UPDATES, 2);
                }
            }
        });
    }

    protected IBuildResult getSharedBuildResultIfKnown() {
        return (IBuildResult)this.getTeamRepository().itemManager().getSharedItemIfKnown((IItemHandle)this.fResultRecord.getBuildResult());
    }

    protected void removeHeaderMessage(Object key) {
        this.fMessageManager.removeMessage(key);
    }

    protected void initializeDataAndPages(ITeamRepository teamRepository) {
        this.fFetchJob = this.getInitialFetchJob(teamRepository);
        this.fFetchJob.setSystem(true);
        this.fFetchJob.schedule();
    }

    protected String[] getContributionIdsToFetch() {
        if (this.fContributionIds == null) {
            HashSet<String> extendedContributionIDs = new HashSet<String>();
            for (AbstractBuildResultContributionProvider provider : this.getContributionProviders()) {
                String[] stringArray = provider.getExtendedContributionIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    extendedContributionIDs.add(id);
                    ++n2;
                }
            }
            this.fContributionIds = extendedContributionIDs.toArray(new String[extendedContributionIDs.size()]);
        }
        return this.fContributionIds;
    }

    protected void postFetchInitialization() {
        this.initializeContributionProviders();
        this.internalAddPages();
        this.fDirty = false;
        this.fireDirtyPropertyChangeEvent();
        BuildRecordEventManager.getInstance().addListener((IBuildResultRecordListener)this);
        this.getTeamRepository().itemManager().addItemChangeListener((IItem)this.fResultRecord.getBuildResult(), (ISharedItemChangeListener)this);
    }

    protected void initializeContributionProviders() {
        for (AbstractBuildResultContributionProvider provider : this.getContributionProviders()) {
            provider.initialize();
        }
    }

    protected AbstractBuildResultContributionProvider createContributionProvider(BuildResultContributionExtension extension) throws IllegalArgumentException, CoreException {
        return extension.createContributionProvider((FormEditor)this, this);
    }

    protected BuildResultContributionExtension[] getAllContributionExtensions() {
        return BuildResultContributionExtensionManager.getInstance().getContributionExtensions();
    }

    protected void performFetch(boolean isRefresh, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        ((BuildResultEditorInput)this.getEditorInput()).getTeamRepository().itemManager().purgeItemChangeListener((ISharedItemChangeListener)this);
        BuildRecordEventManager.getInstance().removeListener((IBuildResultRecordListener)this);
        ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuildResultEditorMessages.BuildResultEditor_FETCHING_DATA_JOB_TITLE, (int)3);
        if (isRefresh) {
            this.fResultRecord = this.getRecordClient().getBuildResultRecord((IBuildResultHandle)this.fResultRecord.getBuildResult(), IBuildResult.PROPERTIES_COMPLETE, (IProgressMonitor)subMonitor.newChild(1, 0));
            this.fLastSavedBuildResultStateId = this.fResultRecord.getBuildResult().getStateId();
            this.fBuildResultWorkingCopy = (IBuildResult)this.fResultRecord.getBuildResult().getWorkingCopy();
        }
        subMonitor.setWorkRemaining(2);
        this.fetchBuildResultContributions(teamBuildClient, (IProgressMonitor)subMonitor.newChild(1, 0));
        this.fBuildResultStatusTrend = this.getRecordClient().getBuildResultStatusTrend((IBuildResultHandle)this.fResultRecord.getBuildResult(), 14, (IProgressMonitor)subMonitor.newChild(1, 0));
    }

    private void fetchBuildResultContributions(ITeamBuildClient teamBuildClient, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fResultContributions = teamBuildClient.getBuildResultContributions((IBuildResultHandle)this.fResultRecord.getBuildResult(), this.getContributionIdsToFetch(), monitor);
    }

    protected Job getInitialFetchJob(final ITeamRepository teamRepository) {
        String jobName = BuildResultEditorMessages.BuildResultEditor_FETCHING_DATA_JOB_TITLE;
        BuildItemEditorJob job = new BuildItemEditorJob(jobName, true, this){

            protected void internalRunProtected(IProgressMonitor progressMonitor) throws Exception {
                BuildResultEditor.this.performFetch(false, teamRepository, progressMonitor);
            }

            protected void internalJobFinished(IStatus status) {
                if (status.isOK()) {
                    BuildResultEditor.this.postFetchInitialization();
                }
            }
        };
        return job;
    }

    protected void addPage(AbstractBuildResultPage newPage, AbstractBuildResultPage.PageGroup groupId) throws PartInitException {
        ImageDescriptor descriptor;
        AbstractBuildResultPage page = (AbstractBuildResultPage)this.findPage(newPage.getId());
        if (page == null) {
            int pageIndex = this.fPageIndices.get((Object)groupId);
            this.addPage(pageIndex, (IFormPage)newPage);
            page = newPage;
            int i = pageIndex + 1;
            while (i < this.pages.size()) {
                ((IFormPage)this.pages.get(i)).setIndex(i);
                ++i;
            }
            for (AbstractBuildResultPage.PageGroup group : EnumSet.range(groupId, AbstractBuildResultPage.PageGroup.LAST)) {
                this.fPageIndices.put(group, this.fPageIndices.get((Object)group) + 1);
            }
        }
        if ((descriptor = page.getStatusImageDescriptor()) != null) {
            this.setPageImage(page.getIndex(), this.fResourceManager.createImage(descriptor));
        }
    }

    protected void addContributedPages() {
        if (this.isDisposed()) {
            return;
        }
        for (final AbstractBuildResultContributionProvider provider : this.getContributionProviders()) {
            if (provider.isInitialized()) {
                this.addContributedPage(provider);
                continue;
            }
            BuildJob addPageJob = new BuildJob(BuildResultEditorMessages.BuildResultEditor_ADD_PAGE_JOB_TITLE){

                protected IStatus run(IProgressMonitor monitor) {
                    BuildResultEditor.this.waitForProviderToBeInitialized(provider);
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (!BuildResultEditor.this.isDisposed()) {
                                BuildResultEditor.this.addContributedPage(provider);
                                BuildResultEditor.this.setBusy(false);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            addPageJob.setSystem(true);
            this.setBusy(true);
            addPageJob.scheduleJob();
        }
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected void waitForProviderToBeInitialized(AbstractBuildResultContributionProvider provider) {
        provider.waitForInitialization();
    }

    protected void addContributedPage(AbstractBuildResultContributionProvider provider) {
        AbstractBuildResultPage page;
        if ((provider.initializationSucceeded() && provider.isContributionPresent() || !provider.initializationSucceeded()) && (page = provider.getBuildResultPage()) != null) {
            this.fPageIdToProviderMap.put(page.getId(), provider);
            try {
                this.addPage(page, page.getPageGroup());
            }
            catch (PartInitException exception) {
                this.logException((Exception)((Object)exception));
            }
        }
    }

    protected void logException(Exception exception) {
        BuildUIPlugin.log(exception);
    }

    protected Job getFetchJob() {
        return this.fFetchJob;
    }

    @Override
    public void dispose() {
        if (this.getFetchJob() != null) {
            this.getFetchJob().cancel();
        }
        ((BuildResultEditorInput)this.getEditorInput()).getTeamRepository().itemManager().purgeItemChangeListener((ISharedItemChangeListener)this);
        BuildRecordEventManager.getInstance().removeListener((IBuildResultRecordListener)this);
        super.dispose();
    }

    protected void pageChange(int pageIndex) {
        final AbstractBuildResultPage page = (AbstractBuildResultPage)((Object)this.pages.get(pageIndex));
        final AbstractBuildResultContributionProvider provider = this.getProviderForPage(page);
        if (provider == null || provider.isInitialized()) {
            this.refreshPage(page, provider);
        } else {
            String jobName = NLS.bind((String)BuildResultEditorMessages.BuildResultEditor_PAGE_REFRESH_JOB_TITLE, (Object)page.getTitle());
            BuildItemEditorJob job = new BuildItemEditorJob(jobName, false, this){

                protected void internalRunProtected(IProgressMonitor monitor) {
                    if (!BuildResultEditor.this.isDisposed()) {
                        provider.waitForInitialization();
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (!BuildResultEditor.this.isDisposed()) {
                                    BuildResultEditor.this.refreshPage(page, provider);
                                }
                            }
                        });
                    }
                }
            };
            job.schedule();
        }
    }

    protected AbstractBuildResultContributionProvider getProviderForPage(AbstractBuildResultPage page) {
        return this.fPageIdToProviderMap.get(page.getId());
    }

    protected void refreshPage(AbstractBuildResultPage page, AbstractBuildResultContributionProvider provider) {
        if (provider != null && !provider.initializationSucceeded()) {
            page.setPageError(BuildResultEditorMessages.BuildResultEditor_BUILD_RESULT_PAGE_PROVIDER_INIT_ERROR, provider.getInitializationError());
        }
        super.pageChange(page.getIndex());
        if (page.refreshContents()) {
            page.getManagedForm().reflow(true);
        }
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void updateTitleTab() {
        Image newImage = BuildStatusCompositeImageDescriptor.getBuildResultComposite(this.fResultRecord.getBuildResult(), (ResourceManager)this.fResourceManager);
        this.setTitleImage(newImage);
        this.setPartName(this.getEditorInput().getName());
        this.setTitleToolTip(this.getEditorInput().getToolTipText());
    }

    public Object getAdapter(Class required) {
        if (IFindReplaceTarget.class.equals((Object)required)) {
            return this.fFindReplaceTarget;
        }
        return super.getAdapter(required);
    }

    public void setFindReplaceTarget(IFindReplaceTarget target) {
        this.fFindReplaceTarget = target;
    }

    public boolean performGlobalAction(String id) {
        IFormPage activePage = this.getActivePageInstance();
        if (activePage instanceof AbstractBuildResultPage) {
            return ((AbstractBuildResultPage)activePage).performGlobalAction(id);
        }
        return false;
    }

    protected void internalAddPages() {
        if (!this.isDisposed()) {
            Object[] pageCopies = new Object[this.pages.size()];
            this.pages.copyInto(pageCopies);
            this.addContributedPages();
            Object[] objectArray = pageCopies;
            int n = pageCopies.length;
            int n2 = 0;
            while (n2 < n) {
                Object page = objectArray[n2];
                ((AbstractBuildResultPage)((Object)page)).disposeContents();
                ++n2;
            }
            this.setActivePage(this.getActivePage());
            this.updateTitleTab();
            this.fHeaderForm.setText(this.getHeaderTitleText());
        }
    }

    @Override
    public IBuildResult getBuildResult() {
        return this.fResultRecord.getBuildResult();
    }

    @Override
    public IBuildResultRecord getBuildResultRecord() {
        return this.fResultRecord;
    }

    public IBuildResultStatusTrend getBuildStatusTrend() {
        return this.fBuildResultStatusTrend;
    }

    protected boolean questionDialog(String message) {
        MessageDialog dialog = this.getQuestionDialog(message);
        return dialog.open() == 0;
    }

    protected MessageDialog getQuestionDialog(String message) {
        return new MessageDialog(this.getSite().getShell(), BuildResultEditorMessages.BuildResultEditor_ERROR_FETCHING_RESULT, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
    }

    protected void closeEditor() {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return (ITeamRepository)this.fResultRecord.getBuildResult().getOrigin();
    }

    protected IBuildResultContribution[] getAllContributions() {
        return this.fResultContributions;
    }

    @Override
    public IBuildResultContribution[] getBuildResultContributions(String[] extendedContributionTypeIds) {
        ValidationHelper.validateNotNull((String)"extendedContributionTypeIds", (Object[])extendedContributionTypeIds);
        LinkedList<IBuildResultContribution> contributions = new LinkedList<IBuildResultContribution>();
        IBuildResultContribution[] iBuildResultContributionArray = this.getAllContributions();
        int n = iBuildResultContributionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            String[] stringArray = extendedContributionTypeIds;
            int n3 = extendedContributionTypeIds.length;
            int n4 = 0;
            while (n4 < n3) {
                String id = stringArray[n4];
                if (id.equals(contribution.getExtendedContributionTypeId())) {
                    contributions.add(contribution);
                }
                ++n4;
            }
            ++n2;
        }
        return contributions.toArray(new IBuildResultContribution[contributions.size()]);
    }

    @Override
    public void setBusy(boolean isBusy) {
        super.setBusy(isBusy);
    }

    @Override
    protected void refreshBuildItem(IProgressMonitor monitor) throws TeamRepositoryException {
        this.refreshDataAndPages(this.getTeamRepository(), monitor);
    }

    @Override
    protected void handleRefreshComplete() {
        this.postFetchInitialization();
    }

    protected void refreshDataAndPages(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        this.performFetch(true, teamRepository, monitor);
    }

    @Override
    protected void disposeEditorSections() {
    }

    @Override
    public IItem getBuildItem() {
        return this.fResultRecord.getBuildResult();
    }

    @Override
    protected boolean isNewItem() {
        return false;
    }

    @Override
    protected boolean preSave() {
        boolean isValid = true;
        ((BuildResultEditorInput)this.getEditorInput()).getTeamRepository().itemManager().purgeItemChangeListener((ISharedItemChangeListener)this);
        BuildRecordEventManager.getInstance().removeListener((IBuildResultRecordListener)this);
        for (Object page : this.pages) {
            AbstractBuildResultPage editorPage = (AbstractBuildResultPage)((Object)page);
            if (editorPage.needsContentCreated() || editorPage.validate()) continue;
            isValid = false;
        }
        return isValid;
    }

    @Override
    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        int workUnits = 1;
        boolean dirtyPages = false;
        for (Object page : this.pages) {
            AbstractBuildResultPage editorPage = (AbstractBuildResultPage)((Object)page);
            if (!editorPage.isDirty()) continue;
            dirtyPages = true;
            ++workUnits;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuildResultEditorMessages.BuildResultEditor_SAVING_BUILD_RESULT_MESSAGE, (int)workUnits);
        LinkedList<TeamRepositoryException> errors = null;
        try {
            IBuildResult result = this.getBuildClient().save(this.fBuildResultWorkingCopy, (IProgressMonitor)subMonitor.newChild(1, 0));
            this.fLastSavedBuildResultStateId = result.getStateId();
            if (dirtyPages) {
                for (Object page : this.pages) {
                    AbstractBuildResultPage editorPage = (AbstractBuildResultPage)((Object)page);
                    if (!editorPage.isDirty()) continue;
                    try {
                        editorPage.save((IProgressMonitor)subMonitor.newChild(1, 0));
                    }
                    catch (TeamRepositoryException exception) {
                        if (errors == null) {
                            errors = new LinkedList<TeamRepositoryException>();
                        }
                        errors.add(exception);
                    }
                }
                this.fResultRecord = this.getRecordClient().getBuildResultRecord((IBuildResultHandle)this.fResultRecord.getBuildResult(), IBuildResult.PROPERTIES_COMPLETE, monitor);
                this.fetchBuildResultContributions(ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository()), (IProgressMonitor)subMonitor.newChild(1, 0));
            }
        }
        finally {
            monitor.done();
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw (TeamRepositoryException)((Object)errors.get(0));
            }
            throw new MultipleErrorTeamBuildException((Throwable[])errors.toArray(new TeamRepositoryException[errors.size()]));
        }
    }

    @Override
    public IBuildResult getBuildResultWorkingCopy() {
        return this.fBuildResultWorkingCopy;
    }

    @Override
    protected void postSave(boolean saveSucceeded) {
        if (saveSucceeded) {
            this.fDirty = false;
        }
        this.getTeamRepository().itemManager().addItemChangeListener((IItem)this.fResultRecord.getBuildResult(), (ISharedItemChangeListener)this);
        BuildRecordEventManager.getInstance().addListener((IBuildResultRecordListener)this);
        this.fBuildResultWorkingCopy = (IBuildResult)this.fResultRecord.getBuildResult().getWorkingCopy();
        for (Object page : this.pages) {
            AbstractBuildResultPage editorPage;
            if (!(page instanceof AbstractBuildResultPage) || !(editorPage = (AbstractBuildResultPage)((Object)page)).checkSaveSuccessful()) continue;
            editorPage.postSave();
        }
        if (saveSucceeded) {
            this.fireDirtyPropertyChangeEvent();
        }
    }

    public void fireDirtyPropertyChangeEvent() {
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        if (this.fDirty) {
            return true;
        }
        for (Object page : this.pages) {
            AbstractBuildResultPage editorPage = (AbstractBuildResultPage)((Object)page);
            if (!editorPage.isDirty()) continue;
            return true;
        }
        return false;
    }

    private ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
    }

    private ITeamBuildRecordClient getRecordClient() {
        return (ITeamBuildRecordClient)this.getTeamRepository().getClientLibrary(ITeamBuildRecordClient.class);
    }

    @Override
    protected String getHelpId() {
        return "com.ibm.team.build.ui.editor_buildresult";
    }

    public void recordsReceived(final IBuildResultRecord[] records) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!BuildResultEditor.this.isDisposed()) {
                    BuildResultEditor.this.handleRecordsReceivedAsync(records);
                }
            }
        });
    }

    protected void handleRecordsReceivedAsync(IBuildResultRecord[] records) {
        IBuildResultRecord[] iBuildResultRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultRecord record = iBuildResultRecordArray[n2];
            if (record.getBuildResult().getItemId().equals((Object)this.getBuildResult().getItemId()) && record.getLastModified() > this.getBuildResultRecord().getLastModified()) {
                this.addLifecycleErrorMessage((Object)MESSAGE_KEY_REFRESH, BuildResultEditorMessages.BuildResultEditor_REFRESH_FOR_UPDATES, 2);
                return;
            }
            ++n2;
        }
    }
}

