/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultContributionExtension;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class BuildResultContributionExtensionManager {
    public static final String EXTENSION_POINT_ID_BUILD_CONTRIBUTION_PROVIDERS = "com.ibm.team.build.ui.buildContributionProviders";
    protected static BuildResultContributionExtensionManager fManager = null;
    private LinkedList<BuildResultContributionExtension> fExtensions = new LinkedList();

    protected BuildResultContributionExtensionManager() {
        this.loadBuildContributionExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildResultContributionExtensionManager getInstance() {
        Class<BuildResultContributionExtensionManager> clazz = BuildResultContributionExtensionManager.class;
        synchronized (BuildResultContributionExtensionManager.class) {
            if (fManager == null) {
                fManager = new BuildResultContributionExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public BuildResultContributionExtension[] getContributionExtensions() {
        return this.fExtensions.toArray(new BuildResultContributionExtension[this.fExtensions.size()]);
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private void loadBuildContributionExtensions() {
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_BUILD_CONTRIBUTION_PROVIDERS);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    BuildResultContributionExtension extension = new BuildResultContributionExtension(configElement);
                    if (!this.fExtensions.contains(extension)) {
                        this.fExtensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("id"), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_DUPLICATE_EXTENSION_POINT, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_MISSING_OR_INVALID, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

