/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.build.ui.editors.result.IBuildResultContributionProviderDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.forms.editor.FormEditor;

public class BuildResultContributionExtension {
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String EXPECTABLE_ATTRIBUTE = "expectable";
    private String fIdAttribute;
    private String fClassAttribute;
    private String fNameAttribute;
    private boolean fExpectableAttribute;
    private IConfigurationElement fConfigElement;

    public BuildResultContributionExtension(IConfigurationElement configElement) {
        ValidationHelper.validateNotNull((String)"configElement", (Object)configElement);
        this.fConfigElement = configElement;
        this.fIdAttribute = configElement.getAttribute(ID_ATTRIBUTE);
        this.fClassAttribute = configElement.getAttribute(CLASS_ATTRIBUTE);
        this.fNameAttribute = configElement.getAttribute(NAME_ATTRIBUTE);
        String expectedAttribute = configElement.getAttribute(EXPECTABLE_ATTRIBUTE);
        this.fExpectableAttribute = expectedAttribute == null || !expectedAttribute.equalsIgnoreCase("false");
        this.validateAttributes();
    }

    public BuildResultContributionExtension(String id, String name, String className) {
        ValidationHelper.validateNotNull((String)ID_ATTRIBUTE, (Object)id);
        ValidationHelper.validateNotNull((String)NAME_ATTRIBUTE, (Object)name);
        this.fIdAttribute = id;
        this.fClassAttribute = className;
        this.fNameAttribute = name;
        this.fExpectableAttribute = true;
    }

    public String getClassAttribute() {
        return this.fClassAttribute;
    }

    public String getIdAttribute() {
        return this.fIdAttribute;
    }

    public String getNameAttribute() {
        return this.fNameAttribute;
    }

    public boolean getExpectableAttribute() {
        return this.fExpectableAttribute;
    }

    public AbstractBuildResultContributionProvider createContributionProvider(FormEditor editor, IBuildResultContext context) throws IllegalArgumentException, CoreException {
        return this.createExecutableExtension().getBuildResultContributionProvider(editor, this.fIdAttribute, context);
    }

    public int hashCode() {
        return this.fIdAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildResultContributionExtension other = (BuildResultContributionExtension)obj;
        return this.fIdAttribute.equals(other.fIdAttribute);
    }

    public String toString() {
        return this.fNameAttribute;
    }

    private void validateAttributes() {
        ValidationHelper.validateNotNull((String)ID_ATTRIBUTE, (Object)this.fIdAttribute);
        ValidationHelper.validateNotEmpty((String)ID_ATTRIBUTE, (String)this.fIdAttribute.trim());
        ValidationHelper.validateNotNull((String)CLASS_ATTRIBUTE, (Object)this.fClassAttribute);
        ValidationHelper.validateNotEmpty((String)CLASS_ATTRIBUTE, (String)this.fClassAttribute.trim());
        ValidationHelper.validateNotNull((String)NAME_ATTRIBUTE, (Object)this.fNameAttribute);
        ValidationHelper.validateNotEmpty((String)NAME_ATTRIBUTE, (String)this.fNameAttribute.trim());
        ValidationHelper.validateNotNull((String)EXPECTABLE_ATTRIBUTE, (Object)this.fExpectableAttribute);
    }

    private IBuildResultContributionProviderDelegate createExecutableExtension() throws CoreException, IllegalArgumentException {
        Object executableExtension = this.fConfigElement.createExecutableExtension(CLASS_ATTRIBUTE);
        ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, IBuildResultContributionProviderDelegate.class, (Object)executableExtension);
        return (IBuildResultContributionProviderDelegate)executableExtension;
    }
}

