/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.process;

import com.ibm.team.build.internal.ui.editors.process.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CheckNumberOfBuildsAspectEditor
extends OperationDetailsAspectEditor {
    private static final String ELEMENT_ALLOW = "allow";
    private static final String ATTRIBUTE_BUILDS = "maximumBuilds";
    protected static final int DEFAULT_MAX_BUILDS = 1;
    protected int fOriginalMaxBuilds;
    protected int fMaxBuilds;
    protected Text fMaxBuildsText;

    public void restoreState(IMemento memento) {
        if (memento.getChild(ELEMENT_ALLOW) != null) {
            this.fMaxBuilds = memento.getChild(ELEMENT_ALLOW).getInteger(ATTRIBUTE_BUILDS);
        } else {
            this.fMaxBuilds = 1;
            this.setDirty();
        }
        this.fOriginalMaxBuilds = this.fMaxBuilds;
    }

    public boolean saveState(IMemento memento) {
        try {
            this.fMaxBuilds = Integer.valueOf(this.fMaxBuildsText.getText());
            if (this.fMaxBuilds < 1) {
                this.fMaxBuilds = this.fOriginalMaxBuilds;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fMaxBuilds = this.fOriginalMaxBuilds;
        }
        this.fOriginalMaxBuilds = this.fMaxBuilds;
        this.fMaxBuildsText.setText(Integer.toString(this.fMaxBuilds));
        memento.createChild(ELEMENT_ALLOW).putInteger(ATTRIBUTE_BUILDS, this.fMaxBuilds);
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(5, 8).applyTo(parent);
        toolkit.createLabel(parent, Messages.AspectEditor_CONSTRAINTS_SECTION_HEADER).setFont(this.getBoldFont());
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(10, 0).spacing(5, 8).numColumns(2).applyTo(composite);
        toolkit.createLabel(composite, Messages.CheckNumberOfBuildsAspectEditor_MAX_BUILDS_LABEL);
        this.fMaxBuildsText = toolkit.createText(composite, Integer.toString(this.fMaxBuilds), 133124);
        GridDataFactory.fillDefaults().hint(20, -1).applyTo((Control)this.fMaxBuildsText);
        this.fMaxBuildsText.addModifyListener(this.getModifyListener());
    }

    protected ModifyListener getModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckNumberOfBuildsAspectEditor.this.setDirty();
            }
        };
    }

    public void dispose() {
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }
}

