/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.buildengine;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.IBuildPropertyControlListener;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.BuildItemEditorOverviewPage;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildDefinitionsContentProvider;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorInput;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorMessages;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.TeamAreaSelectionDialog;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEngineEditor
extends BuildItemEditor {
    private static final int MINIMUM_NUMBER_CHARACTERS_IN_BUILD_DEFINITIONS = 25;
    private static final int MINIMUM_NUMBER_BUILD_DEFINITIONS = 5;
    private FormToolkit fToolkit;
    private ScrolledForm fForm;
    private boolean fDirty;
    protected ITeamRepository fTeamRepository;
    protected IBuildEngine fBuildEngine;
    protected IBuildEngineStatusRecord fBuildEngineStatusRecord;
    private Composite fGeneralAndDefinitionsGroup;
    private Composite fGeneralGroup;
    private Section fGeneralSection;
    private Section fBuildDefinitionsSection;
    private Section fActivationSection;
    private Section fPropertiesSection;
    protected Text fEngineIdText;
    protected Text fTeamAreaText;
    private Button fAssignTeamAreaButton;
    protected Button fEngineActiveButton;
    private Section fRequestProcessingSection;
    protected Button fMonitoringButton;
    protected Text fMonitoringThresholdText;
    protected Button fRequestProcessingButton;
    private IBuildPropertyControlListener fBuildPropertyListener = this.getPropertyListener();
    private BuildPropertyControl fBuildPropertyControl;
    protected CheckboxTableViewer fBuildDefinitionsTableViewer;
    private Button fSelectAllTypesButton;
    private Button fDeselectAllTypesButton;
    private BuildEngineEditorInput fEditorInput;
    protected IBuildDefinition[] fBuildDefinitions = new IBuildDefinition[0];
    protected IBuildDefinition[] fSupportedBuildDefinitions = new IBuildDefinition[0];
    protected ITeamArea fBuildTeamArea;
    private boolean fIsNewEngine;
    protected boolean fSaveAttempted;
    private static final int SECTION_WIDTH_HINT = 100;
    private static final String LAST_CONTACT_WARNING_ID = "last.contact.warning.id";

    @Override
    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    @Override
    protected String getHeaderTitleText() {
        return BuildEngineEditorMessages.BUILD_ENGINE_EDITOR_TITLE;
    }

    @Override
    protected Image getHeaderTitleImage() {
        return BuildUIPlugin.getImage("icons/obj16/bld_srvr.gif");
    }

    @Override
    public IItem getBuildItem() {
        return this.fBuildEngine;
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new BuildEngineFormPage(this));
        }
        catch (PartInitException exception) {
            BuildUIPlugin.log(exception);
        }
    }

    protected TeamAreaSelectionDialog getTeamAreaSelectionDialog() {
        return new TeamAreaSelectionDialog(this.getSite().getShell());
    }

    @Override
    protected void disposeEditorSections() {
        if (this.fBuildPropertyControl != null) {
            this.fBuildPropertyControl.removeListener(this.fBuildPropertyListener);
        }
        if (this.fGeneralAndDefinitionsGroup != null && !this.fGeneralAndDefinitionsGroup.isDisposed()) {
            this.fGeneralAndDefinitionsGroup.dispose();
        }
        if (this.fBuildDefinitionsSection != null && !this.fBuildDefinitionsSection.isDisposed()) {
            this.fBuildDefinitionsSection.dispose();
        }
        if (this.fPropertiesSection != null && !this.fPropertiesSection.isDisposed()) {
            this.fPropertiesSection.dispose();
        }
    }

    private void createEditor(Composite parent) {
        this.fGeneralAndDefinitionsGroup = this.getToolkit().createComposite(parent);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.fGeneralAndDefinitionsGroup.setLayoutData((Object)data);
        FormLayout formLayout = new FormLayout();
        this.fGeneralAndDefinitionsGroup.setLayout((Layout)formLayout);
        this.fGeneralGroup = this.getToolkit().createComposite(this.fGeneralAndDefinitionsGroup, 0);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(50);
        this.fGeneralGroup.setLayoutData((Object)data);
        formLayout = new FormLayout();
        this.fGeneralGroup.setLayout((Layout)formLayout);
        this.createGeneralSection(this.fGeneralGroup);
        this.createActivationSection(this.fGeneralGroup);
        this.createRequestProcessingSection(this.fGeneralGroup);
        this.createBuildDefinitionsSection(this.fGeneralAndDefinitionsGroup);
        this.createPropertiesSection(parent);
        this.validateLastContactTime();
        this.fForm.reflow(true);
    }

    private void validateLastContactTime() {
        if (this.fBuildEngineStatusRecord != null) {
            if (this.fBuildEngineStatusRecord.isEngineInWarningState()) {
                if (this.fBuildEngineStatusRecord.getLastContactTime() == null) {
                    Status status = new Status(2, BuildUIPlugin.getUniqueIdentifier(), BuildEngineEditorMessages.BuildEngineEditor_NEVER_CONTACTED);
                    this.addErrorMessage((Object)LAST_CONTACT_WARNING_ID, BuildEngineEditorMessages.BuildEngineEditor_NOT_RUNNING, (IStatus)status);
                } else if (this.fBuildEngineStatusRecord.isMonitoringThresholdExceeded()) {
                    Status status = new Status(2, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_EXCEEDED, (Object)this.fBuildEngine.getMonitoringThreshold()));
                    this.addErrorMessage((Object)LAST_CONTACT_WARNING_ID, BuildEngineEditorMessages.BuildEngineEditor_NOT_RUNNING, (IStatus)status);
                }
            } else {
                this.removeErrorMessage(LAST_CONTACT_WARNING_ID);
            }
        }
    }

    @Override
    protected void refreshBuildItem(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamAreaHandle teamAreaHandle;
        this.fBuildDefinitions = this.fetchBuildDefinitions(monitor);
        if (!this.fIsNewEngine) {
            this.fBuildEngineStatusRecord = this.fetchBuildEngineStatusRecord((IBuildEngineHandle)this.fBuildEngine, monitor);
            this.fBuildEngine = this.fBuildEngineStatusRecord.getBuildEngine();
        }
        if ((teamAreaHandle = this.fBuildEngine.getTeamArea()) != null) {
            this.fBuildTeamArea = (ITeamArea)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 1, monitor);
        }
        this.fSupportedBuildDefinitions = this.fetchSupportedBuildDefinitions(this.fBuildEngine, monitor);
    }

    private ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.fTeamRepository);
    }

    protected IBuildDefinition[] fetchBuildDefinitions(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager itemManager = this.fTeamRepository.itemManager();
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(this.getBuildClient(), itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList buildDefinitions = new LinkedList();
        while (iter.hasNext(monitor)) {
            List definitionHandles = iter.next(512, monitor);
            buildDefinitions.addAll(itemManager.fetchCompleteItems(definitionHandles, 0, monitor));
        }
        Iterator definitionsIter = buildDefinitions.iterator();
        while (definitionsIter.hasNext()) {
            Object next = definitionsIter.next();
            if (next != null) continue;
            definitionsIter.remove();
        }
        return buildDefinitions.toArray(new IBuildDefinition[buildDefinitions.size()]);
    }

    protected IBuildEngineStatusRecord fetchBuildEngineStatusRecord(IBuildEngineHandle engine, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)this.fTeamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        return client.getBuildEngineStatusRecord(engine, monitor);
    }

    protected IBuildDefinition[] fetchSupportedBuildDefinitions(IBuildEngine buildEngine, IProgressMonitor monitor) throws TeamRepositoryException {
        List buildDefinitions = this.fTeamRepository.itemManager().fetchCompleteItems(buildEngine.getSupportedBuildDefinitions(), 0, monitor);
        ArrayList<IBuildDefinition> validDefinitions = new ArrayList<IBuildDefinition>();
        for (Object obj : buildDefinitions) {
            if (obj == null) continue;
            validDefinitions.add((IBuildDefinition)obj);
        }
        return validDefinitions.toArray(new IBuildDefinition[validDefinitions.size()]);
    }

    @Override
    protected void handleRefreshComplete() {
        if (!this.fForm.isDisposed()) {
            this.createEditor(this.fForm.getBody());
            this.setPartName();
            this.setDirty(false);
        }
    }

    protected void createGeneralSection(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        this.fGeneralSection = toolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.fGeneralSection.setLayoutData((Object)data);
        this.fGeneralSection.setLayout((Layout)new GridLayout(1, false));
        this.fGeneralSection.setText(BuildEngineEditorMessages.GENERAL_HEADER);
        this.fGeneralSection.setDescription(BuildEngineEditorMessages.GENERAL_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label label = toolkit.createLabel(composite, BuildEngineEditorMessages.ID_LABEL);
        label.setToolTipText(BuildEngineEditorMessages.ID_TOOLTIP);
        label.setLayoutData((Object)new GridData());
        this.fEngineIdText = toolkit.createText(composite, this.fBuildEngine.getId(), 2052);
        if (this.fEditorInput.isNewBuildEngine()) {
            this.fEngineIdText.setFocus();
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        gridData.horizontalSpan = 2;
        this.fEngineIdText.setLayoutData((Object)gridData);
        this.fEngineIdText.addModifyListener(this.getEngineIdModifiedListener());
        label = toolkit.createLabel(composite, BuildEngineEditorMessages.TEAM_AREA_LABEL);
        label.setLayoutData((Object)new GridData());
        label.setToolTipText(BuildEngineEditorMessages.TEAM_AREA_TOOLTIP);
        String teamAreaTextValue = this.fBuildTeamArea == null ? "" : this.fBuildTeamArea.getName();
        this.fTeamAreaText = toolkit.createText(composite, teamAreaTextValue, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.fTeamAreaText.setLayoutData((Object)gridData);
        this.fTeamAreaText.setEditable(false);
        this.fAssignTeamAreaButton = toolkit.createButton(composite, BuildEngineEditorMessages.BUTTON_LABEL_ASSIGN_TEAM_AREA, 8);
        gridData = new GridData(128);
        this.fAssignTeamAreaButton.setLayoutData((Object)gridData);
        this.fAssignTeamAreaButton.addSelectionListener((SelectionListener)this.getTeamAreaSelectionListener());
        if (this.fEditorInput.getDefaultTeamArea() != null) {
            this.fTeamAreaText.setText(this.fEditorInput.getDefaultTeamArea().getName());
            this.fBuildTeamArea = this.fEditorInput.getDefaultTeamArea();
        }
        this.fGeneralSection.setClient((Control)composite);
    }

    protected ModifyListener getEngineIdModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildEngineEditor.this.fBuildEngine = (IBuildEngine)BuildEngineEditor.this.fBuildEngine.getWorkingCopy();
                BuildEngineEditor.this.fBuildEngine.setId(BuildEngineEditor.this.fEngineIdText.getText());
                BuildEngineEditor.this.setPartName();
                if (BuildEngineEditor.this.shouldValidate()) {
                    BuildEngineEditor.this.validate();
                }
                BuildEngineEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionAdapter getTeamAreaSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamAreaSelectionDialog dialog = BuildEngineEditor.this.getTeamAreaSelectionDialog();
                dialog.setInput((Object)BuildEngineEditor.this.fTeamRepository);
                if (dialog.open() == 0) {
                    BuildEngineEditor.this.fBuildTeamArea = dialog.getSelectedTeamArea();
                    BuildEngineEditor.this.fTeamAreaText.setText(BuildEngineEditor.this.fBuildTeamArea.getName());
                    BuildEngineEditor.this.fBuildEngine = (IBuildEngine)BuildEngineEditor.this.fBuildEngine.getWorkingCopy();
                    BuildEngineEditor.this.fBuildEngine.setTeamArea((ITeamAreaHandle)BuildEngineEditor.this.fBuildTeamArea);
                    if (BuildEngineEditor.this.shouldValidate()) {
                        BuildEngineEditor.this.validate();
                    }
                    BuildEngineEditor.this.setDirty(true);
                }
            }
        };
    }

    private void createActivationSection(Composite parent) {
        this.fActivationSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralSection, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.fActivationSection.setLayoutData((Object)data);
        this.fActivationSection.setLayout((Layout)new GridLayout(1, false));
        this.fActivationSection.setText(BuildEngineEditorMessages.ACTIVATION_HEADER);
        this.fActivationSection.setDescription(BuildEngineEditorMessages.ACTIVATION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fActivationSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fEngineActiveButton = this.fToolkit.createButton(composite, BuildEngineEditorMessages.ACTIVE_BUTTON, 32);
        this.fEngineActiveButton.setLayoutData((Object)new GridData());
        this.fEngineActiveButton.setSelection(this.fBuildEngine.isActive());
        this.fEngineActiveButton.addSelectionListener(this.getActiveButtonSelectionListener());
        this.fActivationSection.setClient((Control)composite);
    }

    private void createRequestProcessingSection(Composite parent) {
        this.fRequestProcessingSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fActivationSection, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, -10);
        this.fRequestProcessingSection.setLayoutData((Object)data);
        this.fRequestProcessingSection.setLayout((Layout)new GridLayout(1, false));
        this.fRequestProcessingSection.setText(BuildEngineEditorMessages.BuildEngineEditor_REQUEST_PROCESSING_SECTION);
        this.fRequestProcessingSection.setDescription(BuildEngineEditorMessages.BuildEngineEditor_REQUEST_PROCESSING_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fRequestProcessingSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fRequestProcessingButton = this.fToolkit.createButton(composite, BuildEngineEditorMessages.BuildEngineEditor_REQUEST_PROCESSING_BUTTON, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fRequestProcessingButton.setLayoutData((Object)gridData);
        this.fRequestProcessingButton.setSelection(this.fBuildEngine.isRequestProcessingEnabled());
        this.fRequestProcessingButton.addSelectionListener(this.getRequestProcessingButtonSelectionListener());
        this.fRequestProcessingButton.setEnabled(this.fEngineActiveButton.getSelection());
        this.fMonitoringButton = this.fToolkit.createButton(composite, BuildEngineEditorMessages.BuildEngineEditor_MONITOR_BUTTON, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fMonitoringButton.setLayoutData((Object)gridData);
        this.fMonitoringButton.setSelection(this.isMonitoring());
        this.fMonitoringButton.addSelectionListener(this.getMonitoringButtonSelectionListener());
        this.fMonitoringButton.setEnabled(this.fEngineActiveButton.getSelection() && this.fRequestProcessingButton.getSelection());
        Label label = this.fToolkit.createLabel(composite, BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        label.setLayoutData((Object)gridData);
        this.fMonitoringThresholdText = this.fToolkit.createText(composite, this.getThresholdString());
        this.fMonitoringThresholdText.setLayoutData((Object)new GridData(768));
        this.fMonitoringThresholdText.addModifyListener(this.getMonitoringTextModifyListener());
        this.fMonitoringThresholdText.addListener(25, this.getIntegerInputListener());
        this.fMonitoringThresholdText.setEnabled(this.fEngineActiveButton.getSelection() && this.fRequestProcessingButton.getSelection() && this.fMonitoringButton.getSelection());
        this.fRequestProcessingSection.setClient((Control)composite);
    }

    private String getThresholdString() {
        String threshold = "";
        if (this.fBuildEngine.getMonitoringThreshold() > 0) {
            threshold = String.valueOf(this.fBuildEngine.getMonitoringThreshold());
        }
        return threshold;
    }

    protected ModifyListener getMonitoringTextModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildEngineEditor.this.fMonitoringThresholdText.getText().trim().length() > 0) {
                    BuildEngineEditor.this.fBuildEngine = (IBuildEngine)BuildEngineEditor.this.fBuildEngine.getWorkingCopy();
                    BuildEngineEditor.this.fBuildEngine.setMonitoringThreshold(Integer.parseInt(BuildEngineEditor.this.fMonitoringThresholdText.getText().trim()));
                }
                BuildEngineEditor.this.setDirty(true);
                BuildEngineEditor.this.validate();
            }
        };
    }

    protected Listener getIntegerInputListener() {
        return new Listener(){

            public void handleEvent(Event e) {
                char[] chars = e.text.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    if (!Character.isDigit(chars[i])) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        };
    }

    private boolean isMonitoring() {
        return this.fBuildEngine.getMonitoringThreshold() > 0;
    }

    protected SelectionListener getActiveButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildEngineEditor.this.fBuildEngine = (IBuildEngine)BuildEngineEditor.this.fBuildEngine.getWorkingCopy();
                BuildEngineEditor.this.fBuildEngine.setActive(BuildEngineEditor.this.fEngineActiveButton.getSelection());
                BuildEngineEditor.this.fRequestProcessingButton.setEnabled(BuildEngineEditor.this.fEngineActiveButton.getSelection());
                BuildEngineEditor.this.fMonitoringButton.setEnabled(BuildEngineEditor.this.fEngineActiveButton.getSelection() && BuildEngineEditor.this.fRequestProcessingButton.getSelection());
                BuildEngineEditor.this.fMonitoringThresholdText.setEnabled(BuildEngineEditor.this.fEngineActiveButton.getSelection() && BuildEngineEditor.this.fRequestProcessingButton.getSelection() && BuildEngineEditor.this.fMonitoringButton.getSelection());
                BuildEngineEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getMonitoringButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildEngineEditor.this.fBuildEngine = (IBuildEngine)BuildEngineEditor.this.fBuildEngine.getWorkingCopy();
                if (BuildEngineEditor.this.fMonitoringButton.getSelection()) {
                    if (BuildEngineEditor.this.fMonitoringThresholdText.getText().trim().length() > 0) {
                        BuildEngineEditor.this.fBuildEngine.setMonitoringThreshold(Integer.parseInt(BuildEngineEditor.this.fMonitoringThresholdText.getText().trim()));
                    }
                } else {
                    BuildEngineEditor.this.fBuildEngine.setMonitoringThreshold(0);
                }
                BuildEngineEditor.this.fMonitoringThresholdText.setEnabled(BuildEngineEditor.this.fMonitoringButton.getSelection());
                BuildEngineEditor.this.setDirty(true);
                BuildEngineEditor.this.validate();
            }
        };
    }

    protected SelectionListener getRequestProcessingButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildEngineEditor.this.fBuildEngine = (IBuildEngine)BuildEngineEditor.this.fBuildEngine.getWorkingCopy();
                BuildEngineEditor.this.fBuildEngine.setRequestProcessingEnabled(BuildEngineEditor.this.fRequestProcessingButton.getSelection());
                BuildEngineEditor.this.fMonitoringButton.setSelection(BuildEngineEditor.this.fRequestProcessingButton.getSelection());
                BuildEngineEditor.this.getMonitoringButtonSelectionListener().widgetSelected(null);
                BuildEngineEditor.this.fMonitoringButton.setEnabled(BuildEngineEditor.this.fRequestProcessingButton.getSelection());
                BuildEngineEditor.this.fMonitoringThresholdText.setEnabled(BuildEngineEditor.this.fRequestProcessingButton.getSelection());
                BuildEngineEditor.this.setDirty(true);
                BuildEngineEditor.this.validate();
            }
        };
    }

    private void createPropertiesSection(Composite parent) {
        this.fPropertiesSection = this.fToolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralAndDefinitionsGroup, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, -10);
        this.fPropertiesSection.setLayoutData((Object)data);
        this.fPropertiesSection.setLayout((Layout)new GridLayout(1, false));
        this.fPropertiesSection.setText(BuildEngineEditorMessages.BuildEngineEditor_PROPERTIES_SECTION);
        this.fPropertiesSection.setDescription(BuildEngineEditorMessages.BuildEngineEditor_PROPERTIES_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fPropertiesSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fBuildPropertyControl = this.createBuildPropertyControl(composite, this.copyProperties(this.fBuildEngine.getProperties()));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.fBuildPropertyControl.getComposite().setLayoutData((Object)gridData);
        this.fBuildPropertyControl.addListener(this.fBuildPropertyListener);
        this.fPropertiesSection.setClient((Control)composite);
    }

    protected BuildPropertyControl createBuildPropertyControl(Composite parent, List<IBuildProperty> buildProperties) {
        return new BuildPropertyControl(parent, this.fToolkit, buildProperties, this.fTeamRepository, true, BuildPropertyControl.LayoutSize.FULL);
    }

    private List copyProperties(List<IBuildProperty> properties) {
        LinkedList<IBuildProperty> propertyCopies = new LinkedList<IBuildProperty>();
        for (IBuildProperty buildProperty : properties) {
            propertyCopies.add(buildProperty.copyProperty());
        }
        return propertyCopies;
    }

    protected void createBuildDefinitionsSection(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        this.fBuildDefinitionsSection = toolkit.createSection(parent, 384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment((Control)this.fGeneralGroup, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, -10);
        this.fBuildDefinitionsSection.setLayoutData((Object)data);
        this.fBuildDefinitionsSection.setLayout((Layout)new GridLayout(1, false));
        this.fBuildDefinitionsSection.setText(BuildEngineEditorMessages.BUILD_DEFINITIONS_HEADER);
        this.fBuildDefinitionsSection.setDescription(BuildEngineEditorMessages.BUILD_DEFINITIONS_DESCRIPTION);
        if (this.getBuildDefinitions().length == 0) {
            this.populateEmptyBuildDefinitionsSection();
        } else {
            Composite composite = toolkit.createComposite((Composite)this.fBuildDefinitionsSection);
            toolkit.setBorderStyle(2048);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)new GridLayout(2, false));
            Table table = toolkit.createTable(composite, 66336);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.heightHint = table.getItemHeight() * 5;
            int width = this.getAverageCharacterWidth(composite);
            gridData.widthHint = width * 25;
            table.setLayoutData((Object)gridData);
            this.fBuildDefinitionsTableViewer = new CheckboxTableViewer(table);
            this.fBuildDefinitionsTableViewer.setComparator(this.getComparator());
            this.fBuildDefinitionsTableViewer.setContentProvider((IContentProvider)new BuildDefinitionsContentProvider(this.getBuildDefinitions()));
            this.fBuildDefinitionsTableViewer.setLabelProvider((IBaseLabelProvider)new BuildDefinitionLabelProvider());
            this.fBuildDefinitionsTableViewer.setInput((Object)this.getBuildDefinitions());
            this.fBuildDefinitionsTableViewer.setCheckedElements((Object[])this.getSupportedBuildDefinitions());
            this.fBuildDefinitionsTableViewer.addDoubleClickListener(this.getDoubleClickListener());
            block0: for (IBuildDefinitionHandle supportedDefinition : this.fEditorInput.getDefaultSupportedBuildDefinitions()) {
                IBuildDefinition[] iBuildDefinitionArray = this.fBuildDefinitions;
                int n = this.fBuildDefinitions.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildDefinition definition = iBuildDefinitionArray[n2];
                    if (definition.getItemId().equals((Object)supportedDefinition.getItemId())) {
                        this.fBuildDefinitionsTableViewer.setChecked((Object)definition, true);
                        continue block0;
                    }
                    ++n2;
                }
            }
            this.fBuildDefinitionsTableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    BuildEngineEditor.this.updateSupportedDefinitions();
                    BuildEngineEditor.this.setDirty(true);
                }
            });
            this.createButtonBar(composite);
            this.fBuildDefinitionsSection.setClient((Control)composite);
        }
    }

    protected IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IBuildDefinition definition;
                IStructuredSelection selection = (IStructuredSelection)BuildEngineEditor.this.fBuildDefinitionsTableViewer.getSelection();
                if (selection.size() == 1 && (definition = (IBuildDefinition)selection.getFirstElement()) != null) {
                    EditBuildDefinitionActionDelegate.run(definition, BuildEngineEditor.this.getSite().getPage());
                }
            }
        };
    }

    private int getAverageCharacterWidth(Composite composite) {
        int width;
        GC gc = null;
        try {
            try {
                gc = new GC((Drawable)composite);
                width = gc.getFontMetrics().getAverageCharWidth();
            }
            catch (Exception exception) {
                width = 20;
                if (gc != null) {
                    gc.dispose();
                }
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return width;
    }

    protected ViewerComparator getComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof IBuildDefinition && object2 instanceof IBuildDefinition) {
                    IBuildDefinition buildDefinition1 = (IBuildDefinition)object1;
                    IBuildDefinition buildDefinition2 = (IBuildDefinition)object2;
                    return super.compare(viewer, (Object)buildDefinition1.getId(), (Object)buildDefinition2.getId());
                }
                return super.compare(viewer, object1, object2);
            }
        };
    }

    private void createButtonBar(Composite parent) {
        FormToolkit toolkit = this.getToolkit();
        Composite buttonBar = toolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fSelectAllTypesButton = toolkit.createButton(buttonBar, BuildEngineEditorMessages.SELECT_ALL_LABEL, 8);
        this.fSelectAllTypesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildEngineEditor.this.fBuildDefinitionsTableViewer.setAllChecked(true);
                BuildEngineEditor.this.updateSupportedDefinitions();
                BuildEngineEditor.this.setDirty(true);
            }
        });
        this.fDeselectAllTypesButton = toolkit.createButton(buttonBar, BuildEngineEditorMessages.SELECT_NONE_LABEL, 8);
        this.fDeselectAllTypesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildEngineEditor.this.fBuildDefinitionsTableViewer.setAllChecked(false);
                BuildEngineEditor.this.updateSupportedDefinitions();
                BuildEngineEditor.this.setDirty(true);
            }
        });
        this.setButtonLayoutData();
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fSelectAllTypesButton);
        gc.setFont(this.fSelectAllTypesButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fSelectAllTypesButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fDeselectAllTypesButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fSelectAllTypesButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fDeselectAllTypesButton.setLayoutData((Object)gridData);
    }

    private void populateEmptyBuildDefinitionsSection() {
        ValidationHelper.validateNotNull((String)"fBuildDefinitionsSection", (Object)this.getBuildDefinitionsSection());
        Section section = this.getBuildDefinitionsSection();
        FormToolkit toolkit = this.getToolkit();
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        toolkit.createLabel(composite, BuildEngineEditorMessages.NO_TYPES_DEFINED);
        section.setClient((Control)composite);
    }

    public void setFocus() {
        this.fForm.setFocus();
    }

    private void updateSupportedDefinitions() {
        if (this.fBuildDefinitionsTableViewer != null) {
            this.fBuildEngine = (IBuildEngine)this.fBuildEngine.getWorkingCopy();
            List supportedBuildDefinitions = this.fBuildEngine.getSupportedBuildDefinitions();
            supportedBuildDefinitions.clear();
            Object[] checkedBuildDefinitions = this.fBuildDefinitionsTableViewer.getCheckedElements();
            int i = 0;
            while (i < checkedBuildDefinitions.length) {
                supportedBuildDefinitions.add(checkedBuildDefinitions[i]);
                ++i;
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (BuildEngineEditorInput)input;
        this.fTeamRepository = this.fEditorInput.getTeamRepository();
        this.fIsNewEngine = this.fEditorInput.isNewBuildEngine();
        this.fBuildEngine = this.fEditorInput.getBuildEngine();
        if (this.fIsNewEngine) {
            for (IBuildDefinitionHandle supportedDefinition : this.fEditorInput.getDefaultSupportedBuildDefinitions()) {
                this.fBuildEngine.getSupportedBuildDefinitions().add(supportedDefinition);
            }
            if (this.fEditorInput.getDefaultTeamArea() != null) {
                this.fBuildTeamArea = this.fEditorInput.getDefaultTeamArea();
                this.fBuildEngine.setTeamArea((ITeamAreaHandle)this.fBuildTeamArea);
            }
        }
    }

    @Override
    protected boolean isNewItem() {
        return this.fIsNewEngine;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    protected boolean validate() {
        boolean isValid = true;
        if (this.fEngineIdText.getText().trim().equals("")) {
            this.addErrorMessage((Object)this.fEngineIdText, BuildEngineEditorMessages.ID_MUST_NOT_BE_EMPTY, (Control)this.fEngineIdText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fEngineIdText, (Control)this.fEngineIdText);
        }
        if (this.fTeamAreaText.getText().trim().equals("")) {
            this.addErrorMessage((Object)this.fTeamAreaText, BuildEngineEditorMessages.TEAM_AREA_MUST_NOT_BE_EMPTY, (Control)this.fTeamAreaText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fTeamAreaText, (Control)this.fTeamAreaText);
        }
        if (this.fMonitoringButton.getSelection() && this.fMonitoringThresholdText.getText().trim().equals("")) {
            this.addErrorMessage((Object)BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_NOT_BE_EMPTY, BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_NOT_BE_EMPTY, (Control)this.fMonitoringThresholdText);
            isValid = false;
        } else {
            this.removeErrorMessage(BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_NOT_BE_EMPTY, (Control)this.fMonitoringThresholdText);
        }
        if (this.fMonitoringButton.getSelection() && this.fMonitoringThresholdText.getText().trim().equals("0")) {
            this.addErrorMessage((Object)BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_BE_GREATER_ZERO, BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_BE_GREATER_ZERO, (Control)this.fMonitoringThresholdText);
            isValid = false;
        } else {
            this.removeErrorMessage(BuildEngineEditorMessages.BuildEngineEditor_THRESHOLD_MUST_BE_GREATER_ZERO, (Control)this.fMonitoringThresholdText);
        }
        this.validateLastContactTime();
        return isValid;
    }

    private boolean shouldValidate() {
        return !this.fIsNewEngine || this.fSaveAttempted;
    }

    private void setPartName() {
        String label = this.fBuildEngine.getId();
        if (label.equals("")) {
            label = BuildEngineEditorMessages.BuildEngineEditor_PART_NAME_NEW_DEFINITION;
        }
        this.setPartName(label);
    }

    @Override
    protected String getBuildItemTypeName() {
        return BuildEngineEditorMessages.BuildEngineEditor_BUILD_ENGINE_ITEM_NAME;
    }

    @Override
    protected boolean preSave() {
        this.fSaveAttempted = true;
        return this.validate();
    }

    @Override
    protected void postSave(boolean saveSucceeded) {
        if (saveSucceeded) {
            this.validateLastContactTime();
            this.fBuildPropertyControl.setBuildProperties(this.copyProperties(this.fBuildEngine.getProperties()));
            this.setPartName();
            this.setDirty(false);
        }
    }

    @Override
    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(BuildEngineEditorMessages.SAVING_MESSAGE, 2);
        try {
            this.applyPropertyChanges();
            this.fBuildEngine = this.getBuildClient().save(this.fBuildEngine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fBuildEngineStatusRecord = this.fetchBuildEngineStatusRecord((IBuildEngineHandle)this.fBuildEngine, monitor);
            this.fBuildEngine = this.fBuildEngineStatusRecord.getBuildEngine();
            this.fIsNewEngine = false;
            this.fSupportedBuildDefinitions = this.fetchSupportedBuildDefinitions(this.fBuildEngine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private void applyPropertyChanges() {
        this.fBuildEngine = (IBuildEngine)this.fBuildEngine.getWorkingCopy();
        Iterator iterator = this.fBuildEngine.getProperties().iterator();
        while (iterator.hasNext()) {
            IBuildProperty property = (IBuildProperty)iterator.next();
            if (!property.isGenericEditAllowed()) continue;
            iterator.remove();
        }
        for (Object object : this.fBuildPropertyControl.getBuildProperties()) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.isGenericEditAllowed()) continue;
            this.fBuildEngine.getProperties().add(property);
        }
    }

    protected Section getBuildDefinitionsSection() {
        return this.fBuildDefinitionsSection;
    }

    protected IBuildDefinition[] getBuildDefinitions() {
        return this.fBuildDefinitions;
    }

    protected IBuildDefinition[] getSupportedBuildDefinitions() {
        return this.fSupportedBuildDefinitions;
    }

    protected IBuildEngine getBuildEngine() {
        return this.fBuildEngine;
    }

    protected IBuildPropertyControlListener getPropertyListener() {
        return new IBuildPropertyControlListener(){

            public void propertyAdded(IBuildProperty buildProperty) {
                BuildEngineEditor.this.handlePropertyAdded(buildProperty);
            }

            public void propertyEdited(IBuildProperty buildProperty) {
                BuildEngineEditor.this.handlePropertyEdited(buildProperty);
            }

            public void propertiesRemoved(IBuildProperty[] buildProperties) {
                BuildEngineEditor.this.handlePropertiesRemoved(buildProperties);
            }
        };
    }

    private void handlePropertyAdded(IBuildProperty buildProperty) {
        this.setDirty(true);
    }

    private void handlePropertyEdited(IBuildProperty editedProperty) {
        this.setDirty(true);
    }

    private void handlePropertiesRemoved(IBuildProperty[] removedProperties) {
        this.setDirty(true);
    }

    private void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
        this.firePropertyChange(257);
    }

    @Override
    protected String getHelpId() {
        return "com.ibm.team.build.ui.editor_buildengine";
    }

    class BuildEngineFormPage
    extends BuildItemEditorOverviewPage {
        BuildEngineFormPage(BuildEngineEditor formEditor) {
            super(formEditor, "BuildEngineFormPage.id");
        }

        protected void createFormContent(IManagedForm managedForm) {
            BuildEngineEditor.this.fToolkit = managedForm.getToolkit();
            BuildEngineEditor.this.fToolkit.setBorderStyle(2048);
            BuildEngineEditor.this.fForm = managedForm.getForm();
            BuildEngineEditor.this.fForm.setLayoutData((Object)new FormData());
            Composite body = BuildEngineEditor.this.fForm.getBody();
            FormLayout layout = new FormLayout();
            layout.marginHeight = 10;
            layout.spacing = 10;
            body.setLayout((Layout)layout);
            BuildEngineEditor.this.refreshBuildItem();
        }
    }
}

