/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildSchedule;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDaysContentProvider;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ScheduleConfigurationEditor
extends AbstractConfigurationElementEditor {
    public static final String MONDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_MONDAY;
    public static final String TUESDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_TUESDAY;
    public static final String WEDNESDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_WEDNESDAY;
    public static final String THURSDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_THURSDAY;
    public static final String FRIDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_FRIDAY;
    public static final String SATURDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_SATURDAY;
    public static final String SUNDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_SUNDAY;
    public static final int TEXT_FIELD_WIDTH_NUMBER = 25;
    protected Button fScheduleEnabledButton;
    protected Button fContinuousIntervalButton;
    protected Button fTimeButton;
    protected Text fContinuousIntervalText;
    protected Combo fHourCombo;
    protected Combo fMinuteCombo;
    protected boolean fUse24HourFormat;
    protected boolean fAmPmAppearsFirst;
    protected Combo fAmPmCombo;
    protected Button fSelectAllDaysButton;
    protected Button fDeselectAllDaysButton;
    protected CheckboxTableViewer fBuildDaysTableViewer;
    private Section fScheduleSection;
    private FormToolkit fToolkit;
    protected IBuildDefinition fBuildDefinitionWorkingCopy;
    private TeamBuildJob fScheduleValidationJob;

    public ScheduleConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        this.initializeForLocale(Locale.getDefault());
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new GridLayout());
        this.fScheduleSection = this.fToolkit.createSection(parent, 384);
        this.fScheduleSection.setLayoutData((Object)new GridData(768));
        this.fScheduleSection.setLayout((Layout)new GridLayout(1, false));
        this.fScheduleSection.setText(BuildDefinitionEditorMessages.BuildDefinitionEditor_SECTION_TITLE_SCHEDULE);
        this.fScheduleSection.setDescription(BuildDefinitionEditorMessages.BuildDefinitionEditor_SECTION_DESCRIPTION_SCHEDULE);
        Composite composite = this.fToolkit.createComposite((Composite)this.fScheduleSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createWidgets(composite);
        this.initializeWidgets();
        this.addListeners();
        this.fScheduleSection.setClient((Control)composite);
    }

    private void createWidgets(Composite parent) {
        this.createScheduleEnablementButton(parent);
        this.createBuildTimeGroup(parent);
        this.createBuildDaysGroup(parent);
    }

    private void initializeWidgets() {
        this.initializeWidgetData();
        this.initializeBuildDays();
        this.initializeWidgetEnablement(this.fBuildDefinitionWorkingCopy.getBuildSchedule().isScheduleEnabled());
        this.initializeBuildTimeEnablement();
        this.validate();
    }

    private void addListeners() {
        this.fScheduleEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleScheduleEnableButtonSelected();
            }
        });
        this.fContinuousIntervalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleContinuousIntervalButtonSelected();
            }
        });
        this.fContinuousIntervalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScheduleConfigurationEditor.this.handleContinuousIntervalTextModified();
            }
        });
        this.fTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleTimeButtonSelected();
            }
        });
        this.fHourCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleHourSelected();
            }
        });
        this.fMinuteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleMinuteSelected();
            }
        });
        this.fAmPmCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleAmPmSelected();
            }
        });
        this.fBuildDaysTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ScheduleConfigurationEditor.this.handleDayCheckBoxSelected();
            }
        });
        this.fSelectAllDaysButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleSelectAllDaysButtonSelected();
            }
        });
        this.fDeselectAllDaysButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleConfigurationEditor.this.handleDeselectAllDaysButtonSelected();
            }
        });
    }

    private void updateBuildDefinition() {
        IBuildSchedule schedule = this.fBuildDefinitionWorkingCopy.getBuildSchedule();
        schedule.setScheduleEnabled(this.fScheduleEnabledButton.getSelection());
        if (this.fScheduleEnabledButton.getSelection()) {
            if (this.fContinuousIntervalButton.getSelection()) {
                schedule.setBuildInterval(this.getContinuousInterval());
            } else {
                schedule.setBuildInterval(0);
                schedule.setBuildHourLocalTime(this.getBuildHour());
                schedule.setBuildMinute(this.getBuildMinute());
            }
            schedule.setBuildOnMonday(this.isBuildOnMonday());
            schedule.setBuildOnTuesday(this.isBuildOnTuesday());
            schedule.setBuildOnWednesday(this.isBuildOnWednesday());
            schedule.setBuildOnThursday(this.isBuildOnThursday());
            schedule.setBuildOnFriday(this.isBuildOnFriday());
            schedule.setBuildOnSaturday(this.isBuildOnSaturday());
            schedule.setBuildOnSunday(this.isBuildOnSunday());
        }
    }

    protected void handleScheduleEnableButtonSelected() {
        this.setDirty(true);
        this.setWidgetsEnabled(this.fScheduleEnabledButton.getSelection());
        if (this.fScheduleEnabledButton.getSelection() && this.noBuildDaysSelected()) {
            this.fBuildDaysTableViewer.setAllChecked(true);
            this.setBuildAllDays(true);
        }
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    private void setBuildAllDays(boolean build) {
        this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildOnMonday(build);
        this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildOnTuesday(build);
        this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildOnWednesday(build);
        this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildOnThursday(build);
        this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildOnFriday(build);
        this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildOnSaturday(build);
        this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildOnSunday(build);
    }

    protected void handleContinuousIntervalButtonSelected() {
        this.setDirty(true);
        this.fContinuousIntervalText.setEnabled(true);
        if (this.fContinuousIntervalText.getText().equals("")) {
            this.fContinuousIntervalText.setText("30");
            this.fBuildDefinitionWorkingCopy.getBuildSchedule().setBuildInterval(30);
        }
        this.fContinuousIntervalText.setFocus();
        this.fContinuousIntervalText.selectAll();
        this.fTimeButton.setSelection(false);
        this.fHourCombo.setEnabled(false);
        this.fMinuteCombo.setEnabled(false);
        this.fAmPmCombo.setEnabled(false);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleContinuousIntervalTextModified() {
        this.setDirty(true);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleTimeButtonSelected() {
        this.setDirty(true);
        this.fHourCombo.setEnabled(true);
        this.fMinuteCombo.setEnabled(true);
        this.fAmPmCombo.setEnabled(true);
        this.fContinuousIntervalButton.setSelection(false);
        this.fContinuousIntervalText.setEnabled(false);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleHourSelected() {
        this.setDirty(true);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleMinuteSelected() {
        this.setDirty(true);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleAmPmSelected() {
        this.setDirty(true);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleSelectAllDaysButtonSelected() {
        this.setDirty(true);
        this.fBuildDaysTableViewer.setAllChecked(true);
        this.setBuildAllDays(true);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleDeselectAllDaysButtonSelected() {
        this.setDirty(true);
        this.fBuildDaysTableViewer.setAllChecked(false);
        this.setBuildAllDays(false);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    protected void handleDayCheckBoxSelected() {
        this.setDirty(true);
        if (this.validate()) {
            this.updateBuildDefinition();
        }
    }

    public boolean getScheduleEnabled() {
        return this.fScheduleEnabledButton.getSelection();
    }

    protected int getContinuousInterval() {
        if (this.fContinuousIntervalButton.getSelection()) {
            return Integer.parseInt(this.fContinuousIntervalText.getText());
        }
        return 0;
    }

    public int getBuildHour() {
        int hour = Integer.parseInt(this.fHourCombo.getText());
        if (!this.getUse24HourFormat()) {
            String ampm = this.fAmPmCombo.getItem(this.fAmPmCombo.getSelectionIndex());
            if (ampm.equals(BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_TIME_PM) && hour != 12) {
                hour += 12;
            } else if (ampm.equals(BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_TIME_AM) && hour == 12) {
                hour = 0;
            }
        }
        return hour;
    }

    public int getBuildMinute() {
        return Integer.parseInt(this.fMinuteCombo.getText());
    }

    public boolean isBuildOnMonday() {
        return this.fBuildDaysTableViewer.getChecked((Object)MONDAY);
    }

    public boolean isBuildOnTuesday() {
        return this.fBuildDaysTableViewer.getChecked((Object)TUESDAY);
    }

    public boolean isBuildOnWednesday() {
        return this.fBuildDaysTableViewer.getChecked((Object)WEDNESDAY);
    }

    public boolean isBuildOnThursday() {
        return this.fBuildDaysTableViewer.getChecked((Object)THURSDAY);
    }

    public boolean isBuildOnFriday() {
        return this.fBuildDaysTableViewer.getChecked((Object)FRIDAY);
    }

    public boolean isBuildOnSaturday() {
        return this.fBuildDaysTableViewer.getChecked((Object)SATURDAY);
    }

    public boolean isBuildOnSunday() {
        return this.fBuildDaysTableViewer.getChecked((Object)SUNDAY);
    }

    private boolean noBuildDaysSelected() {
        return !this.isBuildOnMonday() && !this.isBuildOnTuesday() && !this.isBuildOnWednesday() && !this.isBuildOnThursday() && !this.isBuildOnFriday() && !this.isBuildOnSaturday() && !this.isBuildOnSunday();
    }

    private void createScheduleEnablementButton(Composite parent) {
        this.fScheduleEnabledButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_USE_TEAM_SCHEDULER, 32);
    }

    private void createBuildTimeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_BUILD_TIME);
        GridData gridData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        this.createContinuousContainer(group);
        this.createTimeContainer(group);
    }

    private void createContinuousContainer(Group group) {
        Composite composite = this.fToolkit.createComposite((Composite)group);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 8;
        composite.setLayout((Layout)layout);
        this.fContinuousIntervalButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_CONTINUOUS_INTERVAL, 16);
        this.fContinuousIntervalText = this.fToolkit.createText(composite, "", 2048);
        gridData = new GridData(25, -1);
        this.fContinuousIntervalText.setLayoutData((Object)gridData);
    }

    private void createTimeContainer(Group group) {
        int i;
        Composite composite = this.fToolkit.createComposite((Composite)group);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(5, false);
        composite.setLayout((Layout)layout);
        this.fTimeButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_AT, 16);
        ArrayList<String> hours = new ArrayList<String>();
        if (this.getUse24HourFormat()) {
            i = 0;
            while (i < 24) {
                hours.add(String.format("%02d", i));
                ++i;
            }
        } else {
            i = 1;
            while (i <= 12) {
                hours.add(String.format("%02d", i));
                ++i;
            }
        }
        this.fHourCombo = new Combo(composite, 8);
        this.fHourCombo.setVisibleItemCount(24);
        this.fHourCombo.setItems(hours.toArray(new String[hours.size()]));
        this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.BuildScheduleControl_TIME_SEPARATOR, 0);
        ArrayList<String> minutes = new ArrayList<String>();
        int i2 = 0;
        while (i2 < 60) {
            minutes.add(String.format("%02d", i2));
            ++i2;
        }
        this.fMinuteCombo = new Combo(composite, 8);
        this.fMinuteCombo.setVisibleItemCount(30);
        this.fMinuteCombo.setItems(minutes.toArray(new String[minutes.size()]));
        this.fAmPmCombo = new Combo(composite, 8);
        this.fAmPmCombo.setItems(new String[]{BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_TIME_AM, BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_TIME_PM});
        this.fAmPmCombo.setVisible(!this.getUse24HourFormat());
        if (!this.getUse24HourFormat() && this.getAmPmAppearsFirst()) {
            this.fAmPmCombo.moveAbove((Control)this.fHourCombo);
        }
    }

    private void createBuildDaysGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_BUILD_DAYS);
        GridData gridData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        Table table = this.fToolkit.createTable((Composite)group, 68384);
        gridData = new GridData(768);
        gridData.widthHint = 50;
        gridData.heightHint = 150;
        gridData.verticalAlignment = 128;
        table.setLayoutData((Object)gridData);
        this.fBuildDaysTableViewer = new CheckboxTableViewer(table);
        this.fBuildDaysTableViewer.setContentProvider((IContentProvider)new BuildDaysContentProvider());
        this.fBuildDaysTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fBuildDaysTableViewer.setInput((Object)this);
        this.createDaysButtonBar((Composite)group);
    }

    private void createDaysButtonBar(Composite parent) {
        Composite buttonBar = this.fToolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fSelectAllDaysButton = this.fToolkit.createButton(buttonBar, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_SELECT_ALL, 8);
        this.fDeselectAllDaysButton = this.fToolkit.createButton(buttonBar, BuildDefinitionEditorMessages.BuildScheduleControl_LABEL_DESELECT_ALL, 8);
        this.setButtonLayoutData();
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fSelectAllDaysButton);
        gc.setFont(this.fSelectAllDaysButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fSelectAllDaysButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fDeselectAllDaysButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fSelectAllDaysButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fDeselectAllDaysButton.setLayoutData((Object)gridData);
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fScheduleEnabledButton.getSelection()) {
            if (this.fBuildDaysTableViewer.getCheckedElements().length < 1) {
                this.addErrorMessage((Object)this.fBuildDaysTableViewer, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_NO_DAYS_SELECTED, (Control)this.fBuildDaysTableViewer.getTable());
                isValid = false;
            } else {
                this.removeErrorMessage(this.fBuildDaysTableViewer, (Control)this.fBuildDaysTableViewer.getTable());
            }
            if (this.fContinuousIntervalButton.getSelection()) {
                if (!this.isPositiveInteger(this.fContinuousIntervalText.getText())) {
                    this.addErrorMessage((Object)this.fContinuousIntervalText, BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_INVALID_NUMBER, (Control)this.fContinuousIntervalText);
                    isValid = false;
                } else {
                    this.removeErrorMessage(this.fContinuousIntervalText, (Control)this.fContinuousIntervalText);
                }
            }
        }
        if (isValid) {
            this.removeErrorMessage(this.fBuildDaysTableViewer, (Control)this.fBuildDaysTableViewer.getTable());
            this.removeErrorMessage(this.fContinuousIntervalText, (Control)this.fContinuousIntervalText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void dispose() {
        super.dispose();
        if (this.fScheduleValidationJob != null) {
            this.fScheduleValidationJob.cancel();
        }
    }

    private boolean isPositiveInteger(String number) {
        try {
            int i = Integer.parseInt(number);
            return i > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void setWidgetsEnabled(boolean scheduleButtonSelected) {
        this.fContinuousIntervalButton.setEnabled(scheduleButtonSelected);
        this.fContinuousIntervalText.setEnabled(scheduleButtonSelected ? this.fContinuousIntervalButton.getSelection() : false);
        this.fTimeButton.setEnabled(scheduleButtonSelected);
        this.fHourCombo.setEnabled(scheduleButtonSelected ? this.fTimeButton.getSelection() : false);
        this.fMinuteCombo.setEnabled(scheduleButtonSelected ? this.fTimeButton.getSelection() : false);
        this.fAmPmCombo.setEnabled(scheduleButtonSelected ? this.fTimeButton.getSelection() : false);
        this.fBuildDaysTableViewer.getTable().setEnabled(scheduleButtonSelected);
        this.fSelectAllDaysButton.setEnabled(scheduleButtonSelected);
        this.fDeselectAllDaysButton.setEnabled(scheduleButtonSelected);
    }

    private void initializeWidgetData() {
        IBuildSchedule schedule = this.fBuildDefinitionWorkingCopy.getBuildSchedule();
        this.fScheduleEnabledButton.setSelection(schedule.isScheduleEnabled());
        String intervalText = "";
        if (schedule.getBuildInterval() > 0) {
            intervalText = String.valueOf(schedule.getBuildInterval());
        }
        this.fContinuousIntervalText.setText(intervalText);
        if (this.getUse24HourFormat()) {
            this.fHourCombo.select(schedule.getBuildHourLocalTime());
        } else {
            this.fHourCombo.select(this.get12HourFrom24HourFormat(schedule.getBuildHourLocalTime()) - 1);
        }
        this.fMinuteCombo.select(schedule.getBuildMinute());
        if (this.getAmPmFrom24HourFormat(schedule.getBuildHourLocalTime()).equals(BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_TIME_AM)) {
            this.fAmPmCombo.select(0);
        } else {
            this.fAmPmCombo.select(1);
        }
    }

    private void initializeWidgetEnablement(boolean scheduleEnabled) {
        this.fContinuousIntervalButton.setEnabled(scheduleEnabled);
        this.fContinuousIntervalText.setEnabled(scheduleEnabled);
        this.fTimeButton.setEnabled(scheduleEnabled);
        this.fHourCombo.setEnabled(scheduleEnabled);
        this.fMinuteCombo.setEnabled(scheduleEnabled);
        this.fAmPmCombo.setEnabled(scheduleEnabled);
        this.fBuildDaysTableViewer.getTable().setEnabled(scheduleEnabled);
        this.fSelectAllDaysButton.setEnabled(scheduleEnabled);
        this.fDeselectAllDaysButton.setEnabled(scheduleEnabled);
    }

    private void initializeBuildTimeEnablement() {
        if (this.fBuildDefinitionWorkingCopy.getBuildSchedule().getBuildInterval() > 0) {
            this.fContinuousIntervalButton.setSelection(true);
            this.fTimeButton.setSelection(false);
            this.fHourCombo.setEnabled(false);
            this.fMinuteCombo.setEnabled(false);
            this.fAmPmCombo.setEnabled(false);
        } else {
            this.fTimeButton.setSelection(true);
            this.fContinuousIntervalButton.setSelection(false);
            this.fContinuousIntervalText.setEnabled(false);
        }
    }

    private int get12HourFrom24HourFormat(int hourIn24HourFormat) {
        if (hourIn24HourFormat == 0) {
            return 12;
        }
        if (hourIn24HourFormat <= 12) {
            return hourIn24HourFormat;
        }
        return hourIn24HourFormat - 12;
    }

    private String getAmPmFrom24HourFormat(int hourIn24HourFormat) {
        if (hourIn24HourFormat < 12) {
            return BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_TIME_AM;
        }
        return BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_TIME_PM;
    }

    private void initializeBuildDays() {
        IBuildSchedule schedule = this.fBuildDefinitionWorkingCopy.getBuildSchedule();
        if (schedule.isBuildOnMonday()) {
            this.fBuildDaysTableViewer.setChecked((Object)MONDAY, true);
        }
        if (schedule.isBuildOnTuesday()) {
            this.fBuildDaysTableViewer.setChecked((Object)TUESDAY, true);
        }
        if (schedule.isBuildOnWednesday()) {
            this.fBuildDaysTableViewer.setChecked((Object)WEDNESDAY, true);
        }
        if (schedule.isBuildOnThursday()) {
            this.fBuildDaysTableViewer.setChecked((Object)THURSDAY, true);
        }
        if (schedule.isBuildOnFriday()) {
            this.fBuildDaysTableViewer.setChecked((Object)FRIDAY, true);
        }
        if (schedule.isBuildOnSaturday()) {
            this.fBuildDaysTableViewer.setChecked((Object)SATURDAY, true);
        }
        if (schedule.isBuildOnSunday()) {
            this.fBuildDaysTableViewer.setChecked((Object)SUNDAY, true);
        }
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionschedule";
    }

    public Control getFocusControl() {
        return this.fScheduleEnabledButton;
    }

    protected void initializeForLocale(Locale locale) {
        this.fUse24HourFormat = TimeFormatHelper.getUses24HourFormat(locale);
        this.fAmPmAppearsFirst = TimeFormatHelper.getAmPmAppearsFirst(locale);
    }

    protected boolean getUse24HourFormat() {
        return this.fUse24HourFormat;
    }

    protected boolean getAmPmAppearsFirst() {
        return this.fAmPmAppearsFirst;
    }
}

