/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MavenConfigurationEditor
extends AbstractConfigurationElementEditor {
    private static final int FIELD_SPACING = 20;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Section fBuildSection;
    protected Text fProjectLocationText;
    protected Text fMavenHomeText;
    protected Text fMavenGoalsText;
    protected Text fJavaHomeText;
    protected Text fJavaArgsText;
    protected Text fPropertiesFileText;
    private FormToolkit fToolkit;
    private Section fConfigurationSection;

    public MavenConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.fBuildSection = this.fToolkit.createSection(parent, 384);
        this.fBuildSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fBuildSection.setLayout((Layout)new TableWrapLayout());
        this.fBuildSection.setText(BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_BUILD_SECTION);
        this.fBuildSection.setDescription(BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_BUILD_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fBuildSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createProjectLocationWidgets(composite);
        this.createMavenGoalsWidgets(composite);
        this.fBuildSection.setClient((Control)composite);
        this.createSpacer(parent, 15, 1);
        this.fConfigurationSection = this.fToolkit.createSection(parent, 450);
        this.fConfigurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fConfigurationSection.setLayout((Layout)new TableWrapLayout());
        this.fConfigurationSection.setText(BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_CONFIG_SECTION);
        this.fConfigurationSection.setDescription(BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_CONFIG_SECTION_DESCRIPTION);
        composite = this.fToolkit.createComposite((Composite)this.fConfigurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createMavenHomeWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        this.fConfigurationSection.setClient((Control)composite);
    }

    private void createPropertiesFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.propertiesFile");
        this.createSpacer(parent, 20, 2);
        this.fPropertiesFileText = this.createLabeledText(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_PROPERTIES_FILE, BuildDefinitionEditorMessages.MavenConfigurationEditor_PROPERTIES_FILE_DESC, property.getValue());
        this.fPropertiesFileText.addModifyListener(this.getPropertiesFileModifiedListener());
    }

    private void createProjectLocationWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.projectLocation");
        this.createSpacer(parent, 5, 2);
        this.fProjectLocationText = this.createLabeledText(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_PROJECT_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_PROJECT_DESCRIPTION, property.getValue());
        this.fProjectLocationText.addModifyListener(this.getProjectLocationModifiedListener());
    }

    private void createMavenHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.mavenHome");
        this.createSpacer(parent, 20, 2);
        this.fMavenHomeText = this.createLabeledText(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_HOME_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_MAVEN_HOME_DESCRIPTION, property.getValue());
        this.fMavenHomeText.addModifyListener(this.getMavenHomeModifiedListener());
    }

    private void createMavenGoalsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.mavenGoals");
        this.createSpacer(parent, 20, 2);
        this.fMavenGoalsText = this.createLabeledText(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_GOALS_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_GOALS_DESCRIPTION, property.getValue());
        this.fMavenGoalsText.addModifyListener(this.getMavenGoalsModifiedListener());
    }

    private void createJavaHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.javaHome");
        this.createSpacer(parent, 20, 2);
        this.fJavaHomeText = this.createLabeledText(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_JAVA_HOME_LABEL, BuildDefinitionEditorMessages.MavenConfigurationEditor_JAVA_HOME_DESCRIPTION, property.getValue());
        this.fJavaHomeText.addModifyListener(this.getJavaHomeModifiedListener());
    }

    private void createJavaArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.javaVMArgs");
        this.createSpacer(parent, 20, 2);
        this.fJavaArgsText = this.createLabeledText(parent, BuildDefinitionEditorMessages.MavenConfigurationEditor_VM_ARGS, BuildDefinitionEditorMessages.MavenConfigurationEditor_VM_ARGS_DESCRIPTION, property.getValue());
        this.fJavaArgsText.addModifyListener(this.getJavaArgsModifiedListener());
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.fToolkit.createLabel(parent, label);
        Text text = this.fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fProjectLocationText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fProjectLocationText, BuildDefinitionEditorMessages.MavenConfigurationEditor_ERROR_PROJECT_REQUIRED, (Control)this.fProjectLocationText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fProjectLocationText, (Control)this.fProjectLocationText);
        }
        if (this.fMavenGoalsText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fMavenGoalsText, BuildDefinitionEditorMessages.MavenConfigurationEditor_ERROR_GOAL_REQUIRED, (Control)this.fMavenGoalsText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fMavenGoalsText, (Control)this.fMavenGoalsText);
        }
        if (this.fMavenHomeText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fMavenHomeText, BuildDefinitionEditorMessages.MavenConfigurationEditor_ERROR_MAVEN_HOME_REQUIRED, (Control)this.fMavenHomeText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fMavenHomeText, (Control)this.fMavenHomeText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    private ModifyListener getPropertiesFileModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenConfigurationEditor.this.validate();
                IBuildConfigurationElement element = MavenConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.propertiesFile");
                property.setValue(MavenConfigurationEditor.this.fPropertiesFileText.getText().trim());
                MavenConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getProjectLocationModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenConfigurationEditor.this.validate();
                IBuildConfigurationElement element = MavenConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.maven.projectLocation");
                buildFileProperty.setValue(MavenConfigurationEditor.this.fProjectLocationText.getText().trim());
                MavenConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getMavenHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenConfigurationEditor.this.validate();
                IBuildConfigurationElement element = MavenConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.maven.mavenHome");
                buildFileProperty.setValue(MavenConfigurationEditor.this.fMavenHomeText.getText().trim());
                MavenConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getMavenGoalsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenConfigurationEditor.this.validate();
                IBuildConfigurationElement element = MavenConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.maven.mavenGoals");
                buildFileProperty.setValue(MavenConfigurationEditor.this.fMavenGoalsText.getText().trim());
                MavenConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = MavenConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.maven.javaHome");
                buildFileProperty.setValue(MavenConfigurationEditor.this.fJavaHomeText.getText().trim());
                MavenConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaArgsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = MavenConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.maven");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.maven.javaVMArgs");
                buildFileProperty.setValue(MavenConfigurationEditor.this.fJavaArgsText.getText().trim());
                MavenConfigurationEditor.this.setDirty(true);
            }
        };
    }

    public Control getFocusControl() {
        return this.fProjectLocationText;
    }
}

