/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class JdtPublishingConfigurationEditor
extends AbstractConfigurationElementEditor {
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private FormToolkit fToolkit;
    protected Text fLogOrDirectoryText;

    public JdtPublishingConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.createLogSection(parent);
    }

    private void createLogSection(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 450);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JdtPublishingConfigurationEditor_SECTION_TITLE);
        section.setDescription(BuildDefinitionEditorMessages.JdtPublishingConfigurationEditor_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.createLogWidgets(composite);
    }

    private void createLogWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.jdt.publishing");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.jdt.publishing.log");
        this.createSpacer(parent, 5, 2);
        this.fLogOrDirectoryText = this.createLabeledText(parent, BuildDefinitionEditorMessages.JdtPublishingConfigurationEditor_LOG_LABEL, BuildDefinitionEditorMessages.JdtPublishingConfigurationEditor_LOG_DESCRIPTION, property.getValue());
        this.fLogOrDirectoryText.addModifyListener(this.getTextModifiedListener());
    }

    private ModifyListener getTextModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JdtPublishingConfigurationEditor.this.validate();
                IBuildConfigurationElement element = JdtPublishingConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.jdt.publishing");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.jdt.publishing.log");
                buildFileProperty.setValue(JdtPublishingConfigurationEditor.this.fLogOrDirectoryText.getText().trim());
                JdtPublishingConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.fToolkit.createLabel(parent, label);
        Text text = this.fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    public boolean validate() {
        return true;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public Control getFocusControl() {
        return this.fLogOrDirectoryText;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionjdt";
    }
}

