/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class AntConfigurationEditor
extends AbstractConfigurationElementEditor {
    private static final int FIELD_SPACING = 20;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Section fBuildFileSection;
    protected Text fBuildFileText;
    protected Text fBuildTargetsText;
    protected Text fAntHomeText;
    protected Text fAntArgsText;
    protected Text fJavaHomeText;
    protected Text fJavaArgsText;
    protected Text fWorkingDirText;
    protected Text fPropertiesFileText;
    private FormToolkit fToolkit;
    protected Button fIncludeToolkitButton;
    private Section fConfigurationSection;

    public AntConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.fBuildFileSection = this.fToolkit.createSection(parent, 384);
        this.fBuildFileSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fBuildFileSection.setLayout((Layout)new TableWrapLayout());
        this.fBuildFileSection.setText(BuildDefinitionEditorMessages.AntConfigurationEditor_SECTION_TITLE);
        this.fBuildFileSection.setDescription(BuildDefinitionEditorMessages.AntConfigurationEditor_SECTION_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fBuildFileSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createBuildFileWidgets(composite);
        this.createBuildTargetWidgets(composite);
        this.fBuildFileSection.setClient((Control)composite);
        this.createSpacer(parent, 15, 1);
        this.fConfigurationSection = this.fToolkit.createSection(parent, 450);
        this.fConfigurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fConfigurationSection.setLayout((Layout)new TableWrapLayout());
        this.fConfigurationSection.setText(BuildDefinitionEditorMessages.AntConfigurationEditor_CONFIG_SECTION_TEXT);
        this.fConfigurationSection.setDescription(BuildDefinitionEditorMessages.AntConfigurationEditor_CONFIG_SECTION_DESCRIPTION);
        composite = this.fToolkit.createComposite((Composite)this.fConfigurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createIncludeToolkitWidgets(composite);
        this.createAntHomeWidgets(composite);
        this.createAntArgsWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        this.fConfigurationSection.setClient((Control)composite);
    }

    private void createBuildFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.buildFile");
        this.createSpacer(parent, 5, 2);
        this.fBuildFileText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_DESC, property.getValue());
        this.fBuildFileText.addModifyListener(this.getBuildFileModifiedListener());
    }

    private void createBuildTargetWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.targets");
        String targets = "";
        if (property != null) {
            targets = property.getValue();
        }
        this.createSpacer(parent, 5, 2);
        this.fBuildTargetsText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_TARGETS_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_TARGETS_DESCRIPTION, targets);
        this.fBuildTargetsText.addModifyListener(this.getBuildTargetsModifiedListener());
    }

    private void createIncludeToolkitWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.includeToolkit");
        this.createSpacer(parent, 5, 2);
        this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_TOOLKIT_LABEL);
        this.fIncludeToolkitButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_INCLUDE_TOOLKIT_BUTTON, 32);
        this.fIncludeToolkitButton.setLayoutData((Object)new TableWrapData());
        this.fIncludeToolkitButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fIncludeToolkitButton.addSelectionListener(this.getIncludeToolkitSelectionListener());
        this.createSpacer(parent, -1, 1);
        Label label = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_TOOLKIT_DESCRIPTION, 64);
        label.setLayoutData((Object)new TableWrapData(256));
        label.setForeground(Display.getDefault().getSystemColor(16));
    }

    private void createWorkingDirWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.workingDir");
        this.createSpacer(parent, 20, 2);
        this.fWorkingDirText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_WORKING_DIR_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_WORKING_DIR_DESC, property.getValue());
        this.fWorkingDirText.addModifyListener(this.getWorkingDirModifiedListener());
    }

    private void createPropertiesFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.propertiesFile");
        this.createSpacer(parent, 20, 2);
        this.fPropertiesFileText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_PROPERTIES_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_PROPERTIES_DESC, property.getValue());
        this.fPropertiesFileText.addModifyListener(this.getPropertiesFileModifiedListener());
    }

    private void createAntHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.antHome");
        this.createSpacer(parent, 20, 2);
        this.fAntHomeText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_HOME_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_HOME_DESC, property.getValue());
        this.fAntHomeText.addModifyListener(this.getAntHomeModifiedListener());
    }

    private void createAntArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.antArgs");
        this.createSpacer(parent, 20, 2);
        this.fAntArgsText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_ARGS_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_ARGS_DESC, property.getValue());
        this.fAntArgsText.addModifyListener(this.getAntArgsModifiedListener());
    }

    private void createJavaHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.javaHome");
        this.createSpacer(parent, 20, 2);
        this.fJavaHomeText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_JAVA_HOME_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_JAVA_HOME_DESC, property.getValue());
        this.fJavaHomeText.addModifyListener(this.getJavaHomeModifiedListener());
    }

    private void createJavaArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.javaVMArgs");
        this.createSpacer(parent, 20, 2);
        this.fJavaArgsText = this.createLabeledText(parent, BuildDefinitionEditorMessages.AntConfigurationEditor_VM_ARGS_LABEL, BuildDefinitionEditorMessages.AntConfigurationEditor_VM_ARGS_DESC, property.getValue());
        this.fJavaArgsText.addModifyListener(this.getJavaArgsModifiedListener());
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.fToolkit.createLabel(parent, label);
        Text text = this.fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fBuildFileText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fBuildFileText, BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.fBuildFileText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fBuildFileText, (Control)this.fBuildFileText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    private ModifyListener getBuildFileModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.buildFile");
                buildFileProperty.setValue(AntConfigurationEditor.this.fBuildFileText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getBuildTargetsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.targets");
                if (property == null) {
                    property = BuildItemFactory.createConfigurationProperty();
                    property.setName("com.ibm.team.build.ant.targets");
                    element.getConfigurationProperties().add(property);
                }
                property.setValue(AntConfigurationEditor.this.fBuildTargetsText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getAntHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.antHome");
                buildFileProperty.setValue(AntConfigurationEditor.this.fAntHomeText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getAntArgsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.antArgs");
                buildFileProperty.setValue(AntConfigurationEditor.this.fAntArgsText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.javaHome");
                buildFileProperty.setValue(AntConfigurationEditor.this.fJavaHomeText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaArgsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.javaVMArgs");
                buildFileProperty.setValue(AntConfigurationEditor.this.fJavaArgsText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getWorkingDirModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.workingDir");
                property.setValue(AntConfigurationEditor.this.fWorkingDirText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getPropertiesFileModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.propertiesFile");
                property.setValue(AntConfigurationEditor.this.fPropertiesFileText.getText().trim());
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getIncludeToolkitSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = AntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.team.build.ant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.includeToolkit");
                property.setValue(Boolean.toString(AntConfigurationEditor.this.fIncludeToolkitButton.getSelection()));
                AntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    public Control getFocusControl() {
        return this.fBuildFileText;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionant";
    }
}

