/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.repository.common.IItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class BuildItemEditorTitleDragSupport
extends DragSourceAdapter {
    private final BuildItemEditor fEditor;

    public BuildItemEditorTitleDragSupport(BuildItemEditor editor) {
        ValidationHelper.validateNotNull((String)"editor", (Object)((Object)editor));
        this.fEditor = editor;
    }

    protected BuildItemEditor getEditor() {
        return this.fEditor;
    }

    protected Transfer[] getTransferTypes() {
        return new Transfer[]{this.getLocalSelectionTransfer(), this.getURIReferenceTransfer()};
    }

    protected LocalSelectionTransfer getLocalSelectionTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        IItem buildItem = this.getEditor().getBuildItem();
        if (buildItem == null) {
            event.doit = false;
        } else {
            this.getLocalSelectionTransfer().setSelection((ISelection)new StructuredSelection((Object)buildItem));
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.getLocalSelectionTransfer().isSupportedType(event.dataType)) {
            event.data = this.getLocalSelectionTransfer().getSelection();
        } else if (this.getURIReferenceTransfer().isSupportedType(event.dataType)) {
            event.data = this.createURIReferences();
        }
    }

    protected URIReferenceTransfer getURIReferenceTransfer() {
        return URIReferenceTransfer.getInstance();
    }

    private URIReference[] createURIReferences() {
        URIReference reference;
        IItem buildItem = this.getEditor().getBuildItem();
        if (buildItem != null && (reference = Hyperlinks.create((Object)buildItem, null)) != null) {
            return new URIReference[]{reference};
        }
        return new URIReference[0];
    }

    public void dragFinished(DragSourceEvent event) {
        this.getLocalSelectionTransfer().setSelection(null);
    }
}

