/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors;

import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobContext;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.repository.common.ItemNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public abstract class BuildItemEditorJob
extends TeamBuildJob {
    private final BuildItemEditor fEditor;
    private boolean fShouldMakeEditorBusy = true;
    private boolean fEditorSetBusyTrueWasCalled = false;

    public BuildItemEditorJob(String jobName, boolean isUserInitiated, BuildItemEditor editor) {
        super(jobName, isUserInitiated, editor.getTeamRepository());
        this.fEditor = editor;
    }

    public BuildItemEditorJob(String jobName, boolean isUserInitiated, BuildItemEditor editor, TeamBuildJobContext context) {
        super(jobName, isUserInitiated, editor.getTeamRepository(), context);
        this.fEditor = editor;
    }

    public void shouldMakeEditorBusy(boolean flag) {
        this.fShouldMakeEditorBusy = flag;
    }

    protected void setEditorBusy(boolean busy) {
        this.getEditor().setBusy(busy);
    }

    protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
        if (this.fShouldMakeEditorBusy) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (!BuildItemEditorJob.this.getEditor().isDisposed()) {
                        BuildItemEditorJob.this.setEditorBusy(true);
                        BuildItemEditorJob.this.fEditorSetBusyTrueWasCalled = true;
                    }
                }
            });
        }
        this.internalRunProtected(monitor);
        return Status.OK_STATUS;
    }

    protected abstract void internalRunProtected(IProgressMonitor var1) throws Exception;

    public BuildItemEditor getEditor() {
        return this.fEditor;
    }

    protected void internalJobFinished(IStatus status) {
    }

    protected String getHeaderMessageTitle(IStatus status) {
        return NLS.bind((String)Messages.BuildItemEditorJob_JOB_FAILED, (Object)this.getShortName());
    }

    protected void setHeaderMessage(IStatus status) {
        String title = this.getHeaderMessageTitle(status);
        this.getEditor().addLifecycleErrorMessage((Object)title, title, status);
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected final void jobFinished(final IStatus status) {
        this.asyncExec(new Runnable(){

            public void run() {
                if (!BuildItemEditorJob.this.getEditor().isDisposed()) {
                    try {
                        if (BuildItemEditorJob.this.isUserInitiated() && (status.getSeverity() == 4 || status.getSeverity() == 2)) {
                            IStatus headerStatus = status;
                            if (BuildItemEditorJob.this.isExpectedStatus(status) && !(status.getException() instanceof ItemNotFoundException)) {
                                headerStatus = TeamBuildJobHelper.convertToWarningStatus(status);
                            }
                            headerStatus = TeamBuildJobHelper.createDisplayableStatus(headerStatus);
                            BuildItemEditorJob.this.setHeaderMessage(headerStatus);
                        }
                        BuildItemEditorJob.this.internalJobFinished(status);
                    }
                    finally {
                        if (BuildItemEditorJob.this.fEditorSetBusyTrueWasCalled) {
                            BuildItemEditorJob.this.setEditorBusy(false);
                        }
                    }
                }
            }
        });
    }
}

