/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDomainProjectAreaQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByEngine;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.process.common.IProjectAreaHandle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class BuildEngineQueryNode
extends BuildDomainProjectAreaQueryNode {
    private IBuildEngineStatusRecord fEngineStatusRecord;
    private final String fBuildQueryLock = "lock";
    private BuildQuery fBuildQuery;

    public BuildEngineQueryNode(IProjectAreaHandle projectAreaHandle, IBuildEngineStatusRecord engineStatusRecord) {
        super(projectAreaHandle, engineStatusRecord.getBuildEngine().getId(), 0);
        this.fEngineStatusRecord = engineStatusRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildQuery getQuery() {
        String string = "lock";
        synchronized ("lock") {
            if (this.fBuildQuery == null) {
                this.fBuildQuery = new BuildQueryByEngine(NLS.bind((String)Messages.BuildDomainContentProvider_BUILDS_RUNNING_ON_ENGINE, (Object)this.fEngineStatusRecord.getBuildEngine().getId()), null, AdaptableBuildQueryRow.Factory, (IBuildEngineHandle)this.fEngineStatusRecord.getBuildEngine(), this.getProjectAreaHandle(), this.getTeamRepository());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fBuildQuery;
        }
    }

    public Image getImage() {
        Image image = BuildUIPlugin.getImage("icons/obj16/build_engine_obj.gif");
        if (this.fEngineStatusRecord.isEngineInWarningState()) {
            image = BuildCompositeImageRegistry.getImage(image, BuildStatus.WARNING);
        }
        return image;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.BuildDomainContentProvider_BUILD_ENGINE_NODE_LABEL, (Object)this.fEngineStatusRecord.getBuildEngine().getId(), (Object)this.getActivityIndicator());
    }

    public IBuildEngineStatusRecord getBuildEngineStatusRecord() {
        return this.fEngineStatusRecord;
    }

    public void setBuildEngineStatusRecord(IBuildEngineStatusRecord record) {
        this.fEngineStatusRecord = record;
    }

    private String getActivityIndicator() {
        if (this.fEngineStatusRecord.isEngineInWarningState()) {
            return Messages.BuildEngineQueryNode_WARNING;
        }
        if (!this.fEngineStatusRecord.getBuildEngine().isActive()) {
            return Messages.BuildEngineQueryNode_INACTIVE;
        }
        if (this.fEngineStatusRecord.getInProgressBuilds().length > 0) {
            return Messages.BuildDomainContentProvider_BUILD_ENGINE_BUSY;
        }
        return Messages.BuildDomainContentProvider_BUILD_ENGINE_IDLE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildEngineQueryNode) {
            return ((BuildEngineQueryNode)obj).getBuildEngineStatusRecord().getBuildEngine().getItemId().equals((Object)this.getBuildEngineStatusRecord().getBuildEngine().getItemId());
        }
        return false;
    }

    public int hashCode() {
        return this.getBuildEngineStatusRecord().getBuildEngine().getItemId().hashCode();
    }
}

