/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.ui.actions.DeleteBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class BuildEngineMenuOperationTarget
implements IMenuOperationTarget {
    public boolean canDoOperation(String actionId, IStructuredSelection selection) {
        if (this.isSelectionOfBuildEngines(selection)) {
            if (actionId.equals(IMenuOperationTarget.DELETE)) {
                return true;
            }
            if (actionId.equals("jazz.open") && selection.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
        if (this.isSelectionOfBuildEngines(selection)) {
            if (actionId.equals(IMenuOperationTarget.DELETE)) {
                this.deleteBuildEngines(selection);
            } else if (actionId.equals("jazz.open")) {
                this.showBuildResults(selection, site);
            }
        }
    }

    public String getLabel(String actionId) {
        if ("jazz.open".equals(actionId)) {
            return Messages.BuildDomainActionHelper_ACTION_LABEL_SHOW_BUILD_ACTIVITY;
        }
        return null;
    }

    private boolean isSelectionOfBuildEngines(IStructuredSelection selection) {
        if (selection.size() > 0) {
            for (Object object : selection) {
                if (object instanceof BuildEngineQueryNode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void deleteBuildEngines(IStructuredSelection selection) {
        ArrayList<IBuildEngine> enginesToDelete = new ArrayList<IBuildEngine>();
        for (BuildEngineQueryNode node : selection) {
            enginesToDelete.add(node.getBuildEngineStatusRecord().getBuildEngine());
        }
        DeleteBuildEngineActionDelegate delegate = this.getDeleteEngineAction();
        delegate.selectionChanged(null, (ISelection)new StructuredSelection(enginesToDelete));
        delegate.run(null);
    }

    protected DeleteBuildEngineActionDelegate getDeleteEngineAction() {
        return new DeleteBuildEngineActionDelegate();
    }

    private void showBuildResults(IStructuredSelection selection, IWorkbenchSite site) {
        ((BuildEngineQueryNode)selection.getFirstElement()).open(site);
    }
}

