/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.domain;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.DtoFactory;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.common.model.dto.impl.BuildEngineStatusRecordImpl;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainContentProvider;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDomainItemChangeListener
extends AbstractBuildDefinitionChangeListener {
    protected Object fTreeParent;
    protected IProjectAreaHandle fProjectAreaHandle;
    protected BuildDomainContentProvider fContentProvider;

    public BuildDomainItemChangeListener(BuildDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot parent, List<BuildDefinitionQueryNode> children) {
        ValidationHelper.validateNotNull((String)"contentProvider", (Object)contentProvider);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fContentProvider = contentProvider;
        this.fProjectAreaHandle = projectAreaHandle;
        this.fTreeParent = parent;
        for (BuildDefinitionQueryNode node : children) {
            this.getItemIdToNodesMap().put(node.getBuildDefinition().getItemId().getUuidValue(), node);
        }
    }

    public BuildDomainItemChangeListener(BuildDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, BuildEnginesNode parent, List<BuildEngineQueryNode> children) {
        ValidationHelper.validateNotNull((String)"contentProvider", (Object)contentProvider);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fContentProvider = contentProvider;
        this.fProjectAreaHandle = projectAreaHandle;
        this.fTreeParent = parent;
        for (BuildEngineQueryNode node : children) {
            this.getItemIdToNodesMap().put(node.getBuildEngineStatusRecord().getBuildEngine().getItemId().getUuidValue(), node);
        }
    }

    protected void handleException(TeamRepositoryException exception) {
        BuildUIPlugin.log(exception);
    }

    protected void updateBuildEngines(HashSet<IItem> itemsToUpdate) {
        List<IBuildEngine> buildEngines = this.getBuildEngines(itemsToUpdate);
        if (!buildEngines.isEmpty()) {
            ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
            for (IBuildEngine engine : buildEngines) {
                BuildEngineQueryNode node = (BuildEngineQueryNode)this.getItemIdToNodesMap().get(engine.getItemId().getUuidValue());
                if (node == null) continue;
                nodes.add(node);
                this.fContentProvider.fetchAndUpdate(node);
            }
            if (!nodes.isEmpty()) {
                this.getViewer().update(nodes.toArray(), null);
            }
        }
    }

    protected void addBuildEngines(HashSet<IItem> itemsToAdd) {
        List<IBuildEngine> buildEngines = this.getBuildEngines(itemsToAdd);
        if (!buildEngines.isEmpty()) {
            ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
            for (IBuildEngine buildEngine : buildEngines) {
                if (this.getItemIdToNodesMap().get(buildEngine.getItemId().getUuidValue()) != null) continue;
                IBuildEngineStatusRecord engineStatusRecord = this.getBuildEngineStatusRecord(buildEngine);
                BuildEngineQueryNode node = new BuildEngineQueryNode(this.fProjectAreaHandle, engineStatusRecord);
                nodes.add(node);
                this.getItemIdToNodesMap().put(buildEngine.getItemId().getUuidValue(), node);
            }
            if (!nodes.isEmpty()) {
                this.addNodesToViewer(this.fTreeParent, nodes.toArray());
            }
        }
    }

    private IBuildEngineStatusRecord getBuildEngineStatusRecord(IBuildEngine buildEngine) {
        BuildEngineStatusRecordImpl record = (BuildEngineStatusRecordImpl)DtoFactory.eINSTANCE.createBuildEngineStatusRecord();
        record.setLastContactTime(new Timestamp(System.currentTimeMillis()));
        record.setBuildEngine(buildEngine);
        return record;
    }

    protected List getSelectedTeamAreas() {
        return this.fContentProvider.getBuildDomain().getConnectedProjectAreaRegistry().getSelectedTeamAreas(this.fProjectAreaHandle);
    }

    protected void removeBuildEngines(HashSet<IItem> itemsToRemove) {
        List<IBuildEngine> buildEngines = this.getBuildEngines(itemsToRemove);
        if (!buildEngines.isEmpty()) {
            ArrayList<BuildEngineQueryNode> nodes = new ArrayList<BuildEngineQueryNode>();
            for (IBuildEngine engine : buildEngines) {
                Object node = this.getItemIdToNodesMap().get(engine.getItemId().getUuidValue());
                if (node == null) continue;
                nodes.add((BuildEngineQueryNode)node);
            }
            if (!nodes.isEmpty()) {
                this.removeNodesFromViewer(this.fTreeParent, nodes.toArray());
            }
        }
    }

    private List<IBuildEngine> getBuildEngines(HashSet<IItem> items) {
        ArrayList<IBuildEngine> buildEngines = new ArrayList<IBuildEngine>();
        for (IItem object : items) {
            if (!(object instanceof IBuildEngine)) continue;
            buildEngines.add((IBuildEngine)object);
        }
        return buildEngines;
    }

    @Override
    protected void updateControl(HashSet<IItem> itemsToAdd, HashSet<IItem> itemsToRemove, HashSet<IItem> itemsToUpdate) {
        super.updateControl(itemsToAdd, itemsToRemove, itemsToUpdate);
        this.addBuildEngines(itemsToAdd);
        this.removeBuildEngines(itemsToRemove);
        this.updateBuildEngines(itemsToUpdate);
    }

    @Override
    protected boolean shouldShowDefinition(IBuildDefinition definition, IProgressMonitor monitor) {
        boolean showDefinition = false;
        if (definition.isPropertySet(IBuildDefinition.PROPERTY_TEAM_AREA)) {
            List selectedTeamAreas = this.getSelectedTeamAreas();
            for (ITeamAreaHandle handle : selectedTeamAreas) {
                if (!definition.getTeamArea().getItemId().getUuidValue().equals(handle.getItemId().getUuidValue())) continue;
                showDefinition = true;
                break;
            }
        }
        return showDefinition;
    }

    protected boolean shouldShowEngine(IBuildEngine engine, IProgressMonitor monitor) {
        boolean showEngine = false;
        if (engine.isPropertySet(IBuildEngine.PROPERTY_TEAM_AREA)) {
            ITeamRepository teamRepository = (ITeamRepository)engine.getOrigin();
            try {
                ITeamArea teamArea = (ITeamArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)engine.getTeamArea(), 0, monitor);
                if (teamArea.getProjectArea().getItemId().equals((Object)this.fProjectAreaHandle.getItemId())) {
                    showEngine = true;
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        return showEngine;
    }

    @Override
    protected void filterItemsToAdd(HashSet<IItem> itemsToAdd, IProgressMonitor monitor) {
        super.filterItemsToAdd(itemsToAdd, monitor);
        List<IBuildEngine> buildEngines = this.getBuildEngines(itemsToAdd);
        if (!buildEngines.isEmpty()) {
            for (IBuildEngine engine : buildEngines) {
                if (this.shouldShowEngine(engine, monitor)) continue;
                itemsToAdd.remove(engine);
            }
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.fContentProvider.getTreeViewer();
    }

    @Override
    public void addNodesToViewer(Object parent, Object[] nodes) {
        ((TreeViewer)this.getViewer()).add(parent, nodes);
    }

    @Override
    public void removeNodesFromViewer(Object parent, Object[] nodes) {
        ((TreeViewer)this.getViewer()).remove(parent, nodes);
    }

    @Override
    protected Object getParent() {
        return this.fTreeParent;
    }

    @Override
    protected IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }
}

