/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.dialogs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIPreferencesHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.views.query.ShowBuildQueueAction;
import com.ibm.team.build.internal.ui.views.query.ShowHistoryAction;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.FileSelectionDialog;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestBuildDialog
extends TrayDialog {
    public static final String PREFERENCE_DEFINITION = "mostRecentDefinition";
    public static final String PREFERENCE_SHOW_BUILDS_VIEW = "showBuildsViewAfterRequest";
    public static final String PREFERENCE_WORKSPACE_PREFIX = "personalBuildWorkspace";
    public static final int SHOW_BUILDS_OF_REQUEST_TYPE = 0;
    public static final int SHOW_BUILD_QUEUE = 1;
    public static final int DO_NOTHING = 2;
    protected BuildPropertyControl fBuildPropertyControl;
    protected Section fPropertiesSection;
    private Composite fPropertiesComposite;
    protected List<IBuildProperty> fOriginalBuildProperties;
    protected IBuildDefinitionHandle fBuildDefinitionHandle;
    protected IBuildDefinition fBuildDefinition;
    protected IBuildResult fBuildResult;
    protected IBuildResultHandle fBuildResultHandle;
    protected boolean fIsRebuild;
    protected IBuildRequest fBuildRequest;
    private Job fRequestBuildJob;
    private Job fInitializationJob;
    protected Text fBuildDefinitionText;
    protected Combo fShowBuildsViewCombo;
    protected Button fBrowseButton;
    protected Section fBuildOptionsSection;
    protected Composite fBuildOptionsComposite;
    protected Button fPersonalBuildButton;
    protected IWorkspace fPersonalBuildWorkspace;
    protected Button fBrowseWorkspaceButton;
    protected Text fPersonalBuildWorkspaceText;
    protected ComponentLoadRules fComponentLoadRules;
    protected Button fBrowseComponentLoadRulesButton;
    protected Text fComponentLoadRulesText;
    protected boolean fIsPersonalBuild;
    protected Label fNoOptionsLabel;

    public RequestBuildDialog(Shell parentShell, IBuildDefinitionHandle buildDefinitionHandle) {
        super(parentShell);
        this.fBuildDefinitionHandle = buildDefinitionHandle;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_BUILDS_VIEW, true);
    }

    public RequestBuildDialog(Shell parentShell, IBuildResultHandle buildResultHandle, boolean isRebuild) {
        super(parentShell);
        this.fBuildResultHandle = buildResultHandle;
        this.fIsRebuild = isRebuild;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_BUILDS_VIEW, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        dialogAreaComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        dialogAreaComposite.setLayoutData((Object)gridData);
        this.createLabel(dialogAreaComposite, BuildUIDialogMessages.REQUEST_BUILD_HEADER, null);
        Label label = new Label(dialogAreaComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        label = new Label(dialogAreaComposite, 0);
        label.setText(BuildUIDialogMessages.BUILD_DEFINITION_LABEL);
        label.setLayoutData((Object)new GridData());
        this.fBuildDefinitionText = new Text(dialogAreaComposite, 2048);
        this.fBuildDefinitionText.setText(BuildUIDialogMessages.PENDING_LABEL);
        this.fBuildDefinitionText.setLayoutData((Object)new GridData(768));
        this.fBuildDefinitionText.setEditable(false);
        this.fBrowseButton = new Button(dialogAreaComposite, 0);
        this.fBrowseButton.setText(BuildUIDialogMessages.RequestBuildDialog_BROWSE);
        this.fBrowseButton.addSelectionListener(this.getBrowseButtonListener());
        this.fBrowseButton.setEnabled(!this.fIsRebuild);
        label = new Label(dialogAreaComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        this.createBuildOptionsSection(dialogAreaComposite);
        this.fPropertiesSection = new Section(dialogAreaComposite, 34);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.fPropertiesSection);
        this.fPropertiesSection.setEnabled(false);
        this.fPropertiesSection.setLayout((Layout)new GridLayout(1, false));
        this.fPropertiesSection.setText(BuildUIDialogMessages.BUILD_PROPERTIES_LABEL);
        this.fPropertiesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                RequestBuildDialog.this.handleExpansionStateChanged();
            }
        });
        label = new Label(dialogAreaComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        Composite composite = new Composite(dialogAreaComposite, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, -1).applyTo((Control)composite);
        label = new Label(composite, 0);
        label.setText(BuildUIDialogMessages.RequestBuildDialog_AFTER_REQUEST_LABEL);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        this.fShowBuildsViewCombo = new Combo(composite, 8);
        this.fShowBuildsViewCombo.setItems(new String[]{BuildUIDialogMessages.RequestBuildDialog_SHOW_BUILDS_OF_REQUESTED_TYPE, BuildUIDialogMessages.RequestBuildDialog_SHOW_BUILD_QUEUE, BuildUIDialogMessages.RequestBuildDialog_DO_NOTHING});
        this.fShowBuildsViewCombo.setEnabled(false);
        this.fShowBuildsViewCombo.select(BuildUIPlugin.getDefault().getPreferenceStore().getInt(PREFERENCE_SHOW_BUILDS_VIEW));
        this.fShowBuildsViewCombo.addSelectionListener(this.getShowBuildsViewButtonListener());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fShowBuildsViewCombo);
        this.initializeInBackground();
        RequestBuildDialog.applyDialogFont((Control)dialogAreaComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_requestbuild");
        return dialogAreaComposite;
    }

    private void createBuildOptionsSection(Composite dialogAreaComposite) {
        this.fBuildOptionsSection = new Section(dialogAreaComposite, 34);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fBuildOptionsSection);
        this.fBuildOptionsSection.setEnabled(false);
        this.fBuildOptionsSection.setLayout((Layout)new GridLayout(1, false));
        this.fBuildOptionsSection.setText(BuildUIDialogMessages.RequestBuildDialog_BUILD_OPTIONS_SECTION);
        this.fBuildOptionsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                RequestBuildDialog.this.handleExpansionStateChanged();
            }
        });
    }

    private void createPropertiesSectionContent(ITeamRepository teamRepository) {
        if (this.fPropertiesComposite != null && !this.fPropertiesComposite.isDisposed()) {
            this.fPropertiesComposite.dispose();
        }
        this.fPropertiesComposite = new Composite((Composite)this.fPropertiesSection, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fPropertiesComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 0).applyTo(this.fPropertiesComposite);
        this.fPropertiesSection.setClient((Control)this.fPropertiesComposite);
        this.fBuildPropertyControl = new BuildPropertyControl(this.fPropertiesComposite, null, new ArrayList(), teamRepository, true, BuildPropertyControl.LayoutSize.COMPACT);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        this.fBuildPropertyControl.getComposite().setLayoutData((Object)gridData);
    }

    private void createBuildOptionsSectionContent() {
        if (this.fBuildOptionsComposite != null && !this.fBuildOptionsComposite.isDisposed()) {
            this.fBuildOptionsComposite.dispose();
        }
        this.fBuildOptionsComposite = new Composite((Composite)this.fBuildOptionsSection, 0);
        this.fBuildOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 10;
        this.fBuildOptionsComposite.setLayout((Layout)layout);
        this.fBuildOptionsSection.setClient((Control)this.fBuildOptionsComposite);
        IBuildConfigurationElement element = this.fBuildDefinition.getConfigurationElement("com.ibm.team.build.jazzscm");
        if (element != null) {
            this.fPersonalBuildButton = new Button(this.fBuildOptionsComposite, 32);
            this.fPersonalBuildButton.setText(BuildUIDialogMessages.RequestBuildDialog_PERSONAL_BUILD_BUTTON);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.fPersonalBuildButton.setLayoutData((Object)gridData);
            this.fPersonalBuildButton.addSelectionListener(this.getPersonalBuildButtonListener());
            this.fPersonalBuildButton.setSelection(this.fIsPersonalBuild);
            Label label = new Label(this.fBuildOptionsComposite, 64);
            label.setText(BuildUIDialogMessages.RequestBuildDialog_PERSONAL_BUILD_DESCRIPTION);
            gridData = new GridData(768);
            gridData.horizontalIndent = 10;
            gridData.widthHint = 300;
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            label = new Label(this.fBuildOptionsComposite, 0);
            label.setText(BuildUIDialogMessages.RequestBuildDialog_REPOSITORY_WORKSPACE);
            GridDataFactory.swtDefaults().applyTo((Control)label);
            this.fPersonalBuildWorkspaceText = new Text(this.fBuildOptionsComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fPersonalBuildWorkspaceText);
            this.fPersonalBuildWorkspaceText.setEnabled(this.fPersonalBuildButton.getSelection());
            if (this.fPersonalBuildWorkspace != null) {
                this.fPersonalBuildWorkspaceText.setText(this.fPersonalBuildWorkspace.getName());
                Button okButton = this.getButton(0);
                okButton.setEnabled(true);
            }
            this.fBrowseWorkspaceButton = new Button(this.fBuildOptionsComposite, 8);
            this.fBrowseWorkspaceButton.setText(BuildUIDialogMessages.RequestBuildDialog_BROWSE_WORKSPACE);
            this.fBrowseWorkspaceButton.addSelectionListener(this.getBrowseWorkspaceButtonListener());
            this.fBrowseWorkspaceButton.setEnabled(this.fPersonalBuildButton.getSelection());
            label = new Label(this.fBuildOptionsComposite, 0);
            label.setText(BuildUIDialogMessages.RequestBuildDialog_COMPONENT_LOAD_RULES);
            GridDataFactory.swtDefaults().applyTo((Control)label);
            this.fComponentLoadRulesText = new Text(this.fBuildOptionsComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fComponentLoadRulesText);
            this.fComponentLoadRulesText.setEnabled(this.fPersonalBuildButton.getSelection());
            if (this.fComponentLoadRules != null) {
                this.updateComponentLoadRules(this.fComponentLoadRules);
            }
            this.fBrowseComponentLoadRulesButton = new Button(this.fBuildOptionsComposite, 8);
            this.fBrowseComponentLoadRulesButton.setText(BuildUIDialogMessages.RequestBuildDialog_BROWSE_COMPONENT_LOAD_RULES);
            this.fBrowseComponentLoadRulesButton.addSelectionListener(this.getBrowseComponentLoadRulesButtonListener());
            this.fBrowseComponentLoadRulesButton.setEnabled(this.fPersonalBuildButton.getSelection() && this.fPersonalBuildWorkspace != null);
        } else {
            this.fNoOptionsLabel = new Label(this.fBuildOptionsComposite, 64);
            this.fNoOptionsLabel.setText(BuildUIDialogMessages.RequestBuildDialog_NO_OPTIONS);
        }
    }

    protected SelectionListener getBrowseButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildDefinitionSelectionDialog selectionDialog = RequestBuildDialog.this.getSelectionDialog();
                if (selectionDialog.open() == 0) {
                    IBuildDefinition definition = selectionDialog.getFirstSelectedBuildDefinition();
                    RequestBuildDialog.this.fBuildDefinitionHandle = definition;
                    RequestBuildDialog.this.fBuildDefinition = definition;
                    RequestBuildDialog.this.fPersonalBuildWorkspace = null;
                    RequestBuildDialog.this.fIsPersonalBuild = false;
                    RequestBuildDialog.this.handleInitializationComplete();
                }
            }
        };
    }

    protected SelectionListener getBrowseWorkspaceButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository teamRepository = (ITeamRepository)RequestBuildDialog.this.fBuildDefinition.getOrigin();
                IWorkspace workspace = RequestBuildDialog.this.openWorkspaceChooserDialog(RequestBuildDialog.this.fBrowseWorkspaceButton.getShell(), teamRepository);
                if (workspace != null) {
                    RequestBuildDialog.this.fPersonalBuildWorkspace = workspace;
                    RequestBuildDialog.this.fPersonalBuildWorkspaceText.setText(workspace.getName());
                    RequestBuildDialog.this.fBrowseComponentLoadRulesButton.setEnabled(true);
                    Button okButton = RequestBuildDialog.this.getButton(0);
                    okButton.setEnabled(true);
                    BuildUIPlugin.getDefault().getPreferenceStore().setValue(RequestBuildDialog.PREFERENCE_WORKSPACE_PREFIX + RequestBuildDialog.this.fBuildDefinition.getId(), workspace.getItemId().getUuidValue());
                    BuildUIPlugin.getDefault().savePluginPreferences();
                }
            }
        };
    }

    protected SelectionListener getBrowseComponentLoadRulesButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository teamRepository = (ITeamRepository)RequestBuildDialog.this.fBuildDefinition.getOrigin();
                Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles = RequestBuildDialog.this.openComponentLoadRulesChooserDialog(RequestBuildDialog.this.fBrowseComponentLoadRulesButton.getShell(), teamRepository, RequestBuildDialog.this.fPersonalBuildWorkspace);
                if (componentLoadRuleFiles != null) {
                    RequestBuildDialog.this.fComponentLoadRules = new ComponentLoadRules(componentLoadRuleFiles);
                    RequestBuildDialog.this.updateComponentLoadRules(RequestBuildDialog.this.fComponentLoadRules);
                }
            }
        };
    }

    protected void updateComponentLoadRules(ComponentLoadRules rules) {
        int numLoadRules = this.fComponentLoadRules.getLoadRuleFiles().values().size();
        if (numLoadRules == 0) {
            this.fComponentLoadRulesText.setText("");
        } else {
            this.fComponentLoadRulesText.setEnabled(true);
            String messageId = numLoadRules > 1 ? BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT_MULTI : BuildDefinitionEditorMessages.JazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT;
            this.fComponentLoadRulesText.setText(NLS.bind((String)messageId, (Object)numLoadRules));
        }
    }

    protected SelectionListener getPersonalBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequestBuildDialog.this.fIsPersonalBuild = RequestBuildDialog.this.fPersonalBuildButton.getSelection();
                Button okButton = RequestBuildDialog.this.getButton(0);
                okButton.setEnabled(RequestBuildDialog.this.fPersonalBuildWorkspace != null || !RequestBuildDialog.this.fIsPersonalBuild);
                RequestBuildDialog.this.fPersonalBuildWorkspaceText.setEnabled(RequestBuildDialog.this.fPersonalBuildButton.getSelection());
                RequestBuildDialog.this.fBrowseWorkspaceButton.setEnabled(RequestBuildDialog.this.fPersonalBuildButton.getSelection());
                RequestBuildDialog.this.fComponentLoadRulesText.setEnabled(RequestBuildDialog.this.fPersonalBuildButton.getSelection() && RequestBuildDialog.this.fPersonalBuildWorkspace != null);
                RequestBuildDialog.this.fBrowseComponentLoadRulesButton.setEnabled(RequestBuildDialog.this.fPersonalBuildButton.getSelection() && RequestBuildDialog.this.fPersonalBuildWorkspace != null);
            }
        };
    }

    protected SelectionListener getShowBuildsViewButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue(RequestBuildDialog.PREFERENCE_SHOW_BUILDS_VIEW, RequestBuildDialog.this.fShowBuildsViewCombo.getSelectionIndex());
                BuildUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    protected BuildDefinitionSelectionDialog getSelectionDialog() {
        return new BuildDefinitionSelectionDialog(this.getShell(), BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_TITLE, BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_MESSAGE, false, false);
    }

    private void handleExpansionStateChanged() {
        this.getShell().pack(true);
    }

    protected void handleInitializationComplete() {
        if (!this.fBuildDefinitionText.isDisposed()) {
            this.fShowBuildsViewCombo.setEnabled(true);
            this.fBuildOptionsSection.setEnabled(true);
            this.fPropertiesSection.setEnabled(true);
            this.fBuildOptionsSection.setExpanded(false);
            this.fPropertiesSection.setExpanded(false);
            this.getContents().getParent().pack();
            this.fBuildDefinitionText.setText(this.fBuildDefinition.getId());
            this.createBuildOptionsSectionContent();
            this.createPropertiesSectionContent((ITeamRepository)this.fBuildDefinition.getOrigin());
            if (this.fIsRebuild) {
                this.fPropertiesSection.setText(NLS.bind((String)BuildUIDialogMessages.REBUILD_PROPERTIES_LABEL, (Object)this.fBuildResult.getLabel()));
                this.fPropertiesSection.pack(true);
            }
            Button okButton = this.getButton(0);
            okButton.setEnabled(true);
            this.fOriginalBuildProperties = this.fBuildDefinition.getProperties();
            this.fBuildDefinition = (IBuildDefinition)this.fBuildDefinition.getWorkingCopy();
            if (this.fIsRebuild) {
                List requestProperties = this.fBuildRequest.getBuildDefinitionInstance().getProperties();
                this.fBuildDefinition.getProperties().clear();
                for (IBuildProperty requestProperty : requestProperties) {
                    if (requestProperty.getName().equals("scheduledBuild")) continue;
                    IBuildProperty newProperty = requestProperty.copyProperty();
                    this.fBuildDefinition.getProperties().add(newProperty);
                }
            }
            this.fBuildPropertyControl.setBuildProperties(this.fBuildDefinition.getProperties());
        }
    }

    protected IBuildDefinition getBuildDefinition(IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinitionHandle.getOrigin();
        return (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 1, monitor);
    }

    private void initializeInBackground() {
        ITeamRepository jobTeamRepository = null;
        if (this.fBuildResultHandle != null) {
            jobTeamRepository = (ITeamRepository)this.fBuildResultHandle.getOrigin();
        } else if (this.fBuildDefinitionHandle != null) {
            jobTeamRepository = (ITeamRepository)this.fBuildDefinitionHandle.getOrigin();
        } else if (this.getPersistedDefinition() != null) {
            jobTeamRepository = (ITeamRepository)this.getPersistedDefinition().getOrigin();
        }
        String jobName = BuildUIDialogMessages.RequestBuildDialog_JOB_LABEL_INITIALIZING;
        this.fInitializationJob = new TeamBuildJob(jobName, true, jobTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                if (RequestBuildDialog.this.fBuildResultHandle != null) {
                    ITeamRepository teamRepository = (ITeamRepository)RequestBuildDialog.this.fBuildResultHandle.getOrigin();
                    RequestBuildDialog.this.fBuildResult = (IBuildResult)teamRepository.itemManager().fetchCompleteItem((IItemHandle)RequestBuildDialog.this.fBuildResultHandle, 1, monitor);
                    RequestBuildDialog.this.fBuildDefinitionHandle = RequestBuildDialog.this.fBuildResult.getBuildDefinition();
                }
                boolean isPersistedDefinition = false;
                if (RequestBuildDialog.this.fBuildDefinitionHandle == null) {
                    RequestBuildDialog.this.fBuildDefinitionHandle = RequestBuildDialog.this.getPersistedDefinition();
                    isPersistedDefinition = true;
                }
                if (RequestBuildDialog.this.fBuildDefinitionHandle != null) {
                    try {
                        RequestBuildDialog.this.fBuildDefinition = RequestBuildDialog.this.getBuildDefinition(RequestBuildDialog.this.fBuildDefinitionHandle, monitor);
                    }
                    catch (ItemNotFoundException exception) {
                        if (isPersistedDefinition) {
                            RequestBuildDialog.this.fBuildDefinitionHandle = null;
                            BuildUIPreferencesHelper.storeBuildDefinitionPreferences(new IBuildDefinition[0], RequestBuildDialog.PREFERENCE_DEFINITION);
                        }
                        throw exception;
                    }
                }
                if (RequestBuildDialog.this.fBuildDefinitionHandle == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            (this).RequestBuildDialog.this.fBuildDefinitionText.setText(BuildUIDialogMessages.RequestBuildDialog_NO_DEFINITION_SELECTED);
                        }
                    });
                    return Status.OK_STATUS;
                }
                if (RequestBuildDialog.this.fIsRebuild) {
                    RequestBuildDialog.this.fBuildRequest = RequestBuildDialog.this.getBuildRequest(RequestBuildDialog.this.fBuildResult, monitor);
                    RequestBuildDialog.this.fPersonalBuildWorkspace = RequestBuildDialog.this.getWorkspace(RequestBuildDialog.this.fBuildRequest, monitor);
                    RequestBuildDialog.this.fIsPersonalBuild = RequestBuildDialog.this.fBuildResult.isPersonalBuild();
                    RequestBuildDialog.this.fComponentLoadRules = RequestBuildDialog.this.getComponentLoadRules(RequestBuildDialog.this.fBuildRequest, monitor);
                } else {
                    RequestBuildDialog.this.fPersonalBuildWorkspace = RequestBuildDialog.this.getPersistedWorkspace(RequestBuildDialog.this.fBuildDefinition, monitor);
                    RequestBuildDialog.this.fComponentLoadRules = RequestBuildDialog.this.getComponentLoadRules(RequestBuildDialog.this.fBuildDefinition, monitor);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        RequestBuildDialog.this.handleInitializationComplete();
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() != 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            RequestBuildDialog.this.close();
                        }
                    });
                }
                RequestBuildDialog.this.handleInitializationJobDone(this, status);
            }
        };
        this.fInitializationJob.schedule();
    }

    protected IWorkspace getPersistedWorkspace(IBuildDefinition buildDefinition, IProgressMonitor monitor) {
        String workspaceUuid = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_WORKSPACE_PREFIX + buildDefinition.getId());
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        return this.getWorkspace(workspaceUuid, teamRepository, monitor);
    }

    protected IWorkspace getWorkspace(IBuildRequest buildRequest, IProgressMonitor monitor) {
        IWorkspace workspace = null;
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty property = instance.getProperty("team.scm.workspaceUUID");
        if (property != null) {
            ITeamRepository teamRepository = (ITeamRepository)buildRequest.getOrigin();
            String workspaceUuid = property.getValue();
            workspace = this.getWorkspace(workspaceUuid, teamRepository, monitor);
        }
        return workspace;
    }

    protected IWorkspace getWorkspace(String workspaceUuid, ITeamRepository teamRepository, IProgressMonitor monitor) {
        IWorkspace workspace = null;
        try {
            if (workspaceUuid != null && workspaceUuid.length() > 0) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
                workspace = this.fetchWorkspace(workspaceHandle, teamRepository, monitor);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        return workspace;
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)teamRepository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    private ComponentLoadRules getComponentLoadRules(IBuildRequest buildRequest, IProgressMonitor monitor) {
        ComponentLoadRules componentLoadRules = null;
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty property = instance.getProperty("team.scm.componentLoadRules");
        if (property != null) {
            componentLoadRules = new ComponentLoadRules(property.getValue());
        }
        return componentLoadRules;
    }

    private ComponentLoadRules getComponentLoadRules(IBuildDefinition buildDefinition, IProgressMonitor progress) {
        IBuildProperty property;
        ComponentLoadRules componentLoadRules = null;
        IBuildConfigurationElement element = buildDefinition.getConfigurationElement("com.ibm.team.build.jazzscm");
        if (element != null && (property = buildDefinition.getProperty("team.scm.componentLoadRules")) != null) {
            componentLoadRules = new ComponentLoadRules(property.getValue());
        }
        return componentLoadRules;
    }

    protected Map<IComponentHandle, IFileItemHandle> openComponentLoadRulesChooserDialog(Shell shell, ITeamRepository teamRepository, IWorkspace workspace) {
        Map initialSelection = this.fComponentLoadRules != null ? this.fComponentLoadRules.getLoadRuleFiles() : Collections.EMPTY_MAP;
        Map pickedFiles = FileSelectionDialog.pickFilePerComponent((Shell)shell, (ITeamRepository)teamRepository, (IWorkspace)workspace, (String)BuildUIDialogMessages.RequestBuildDialog_LOAD_RULES_DIALOG_MESSAGE, (Map)initialSelection);
        return pickedFiles;
    }

    private IBuildDefinitionHandle getPersistedDefinition() {
        BuildDefinitionHandleHelper handleHelper;
        IBuildDefinitionHandle definitionHandle;
        ITeamRepository teamRepository;
        IBuildDefinitionHandle handle = null;
        List<BuildDefinitionHandleHelper> handleHelpers = BuildUIPreferencesHelper.getBuildDefinitionPreferences(PREFERENCE_DEFINITION);
        if (!handleHelpers.isEmpty() && (teamRepository = (ITeamRepository)(definitionHandle = (handleHelper = handleHelpers.get(0)).getBuildDefinitionHandle()).getOrigin()) != null && teamRepository.loggedIn()) {
            handle = definitionHandle;
        }
        return handle;
    }

    protected boolean isDefinitionSupported(IBuildDefinition buildDefinition, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        IBaseBuildEngineQueryModel.IBuildEngineQueryModel buildEngineQueryModel = IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)buildEngineQueryModel);
        query.filter(buildEngineQueryModel.active()._isTrue()._and(buildEngineQueryModel.supportedBuildDefinitions()._contains(query.newItemHandleArg())));
        query.select(query.count());
        IDataQueryPage page = client.queryData(query, new Object[]{buildDefinition}, 1, monitor);
        IDataRow row = page.getRow(0);
        return row.getInt(0) > 0;
    }

    protected void handleInitializationJobDone(TeamBuildJob job, IStatus status) {
    }

    protected void handleUnsupportedDefinition(IBuildDefinition buildDefinition) {
        MessageDialog dialog = this.getErrorDialog(BuildUIDialogMessages.RequestBuildDialog_ERROR_DIALOG_TITLE, NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_NO_SUPPORTING_ENGINES, (Object)buildDefinition.getId()));
        dialog.open();
    }

    protected void handleNoEnginesSupportingRequests(IBuildDefinition buildDefinition) {
        MessageDialog dialog = this.getErrorDialog(BuildUIDialogMessages.RequestBuildDialog_ERROR_DIALOG_TITLE, NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_NO_ENGINES_SUPPORT_REQUESTS, (Object)buildDefinition.getId()));
        dialog.open();
    }

    protected MessageDialog getErrorDialog(String title, String message) {
        return new MessageDialog(this.getParentShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    protected IBuildRequest getBuildRequest(IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        List buildRequestHandles = this.fBuildResult.getBuildRequests();
        ITeamRepository teamRepository = (ITeamRepository)this.fBuildResult.getOrigin();
        List buildRequests = teamRepository.itemManager().fetchCompleteItems(buildRequestHandles, 0, monitor);
        IBuildRequest buildRequest = null;
        for (IBuildRequest request : buildRequests) {
            if (request == null || !request.getBuildAction().getAction().equals("com.ibm.team.build.action.requestBuild")) continue;
            buildRequest = request;
        }
        return buildRequest;
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected void okPressed() {
        this.requestBuild(this.fBuildDefinition);
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.fInitializationJob != null) {
            this.fInitializationJob.cancel();
        }
        if (this.fRequestBuildJob != null) {
            this.fRequestBuildJob.cancel();
        }
        super.cancelPressed();
    }

    private String getConfirmationMessage(IBuildDefinition buildDefinition, boolean inProgress, boolean pendingRequest) {
        String message = null;
        if (inProgress) {
            message = NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_BUILD_ALREADY_IN_PROGRESS, (Object)buildDefinition.getId());
        } else if (pendingRequest) {
            message = NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_REQUEST_ALREADY_IN_QUEUE, (Object)buildDefinition.getId());
        }
        return message;
    }

    protected boolean isBuildInState(BuildState buildState, IBuildDefinition buildDefinition, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient buildClient = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        IBaseBuildResultQueryModel.IBuildResultQueryModel buildResultQueryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        query.filter(buildResultQueryModel.buildState()._eq((IString)query.newStringArg())._and(buildResultQueryModel.buildDefinition()._eq(query.newItemHandleArg())));
        query.select(query.count());
        IDataQueryPage page = buildClient.queryData(query, new Object[]{buildState.name(), buildDefinition}, 1, progressMonitor);
        IDataRow row = page.getRow(0);
        return row.getInt(0) > 0;
    }

    protected boolean displayConfirmationPreExistingBuilds(final IBuildDefinition buildDefinition, final boolean inProgress, final boolean pendingRequest) {
        final boolean[] shouldMakeNewRequest = new boolean[]{true};
        if (inProgress || pendingRequest) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dialog = RequestBuildDialog.this.getMessageDialog(RequestBuildDialog.this.getParentShell(), BuildUIDialogMessages.RequestBuildDialog_REQUEST_BUILD_TITLE, null, RequestBuildDialog.this.getConfirmationMessage(buildDefinition, inProgress, pendingRequest), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                    if (dialog.open() != 0) {
                        shouldMakeNewRequest[0] = false;
                    }
                }
            });
        }
        return shouldMakeNewRequest[0];
    }

    protected boolean displayConfirmationUnresponsiveEngine(final IBuildDefinition buildDefinition) {
        final boolean[] shouldMakeNewRequest = new boolean[]{true};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String message = NLS.bind((String)BuildUIDialogMessages.RequestBuildDialog_ENGINES_NOT_PROCESSING, (Object)buildDefinition.getId());
                MessageDialog dialog = RequestBuildDialog.this.getMessageDialog(RequestBuildDialog.this.getParentShell(), BuildUIDialogMessages.RequestBuildDialog_REQUEST_BUILD_TITLE, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                if (dialog.open() != 0) {
                    shouldMakeNewRequest[0] = false;
                }
            }
        });
        return shouldMakeNewRequest[0];
    }

    protected MessageDialog getMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        return new MessageDialog(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    private void requestBuild(final IBuildDefinition buildDefinition) {
        final ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        BuildUIPreferencesHelper.storeBuildDefinitionPreferences(new IBuildDefinition[]{buildDefinition}, PREFERENCE_DEFINITION);
        this.fRequestBuildJob = new TeamBuildJob(BuildUIDialogMessages.REQUEST_BUILD_JOB_TITLE, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                return RequestBuildDialog.this.requestBuildJobImpl(buildDefinition, teamRepository, monitor);
            }
        };
        this.fRequestBuildJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                RequestBuildDialog.this.handleRequestJobCompleted(event);
            }
        });
        this.fRequestBuildJob.schedule();
    }

    protected IStatus requestBuildJobImpl(final IBuildDefinition buildDefinition, ITeamRepository teamRepository, IProgressMonitor monitor) throws Exception {
        if (!this.isDefinitionSupported(buildDefinition, monitor)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RequestBuildDialog.this.handleUnsupportedDefinition(buildDefinition);
                }
            });
            return Status.OK_STATUS;
        }
        if (!this.anyEnginesSupportingRequests(buildDefinition, monitor)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RequestBuildDialog.this.handleNoEnginesSupportingRequests(buildDefinition);
                }
            });
            return Status.OK_STATUS;
        }
        if (!this.anyResponsiveEngines((IBuildDefinitionHandle)buildDefinition, monitor) && !this.displayConfirmationUnresponsiveEngine(buildDefinition)) {
            return Status.OK_STATUS;
        }
        if (this.fIsPersonalBuild) {
            this.setPersonalBuildProperties(buildDefinition);
        } else {
            boolean inProgress = this.isBuildInState(BuildState.IN_PROGRESS, buildDefinition, monitor);
            boolean pendingRequest = false;
            if (!inProgress) {
                pendingRequest = this.isBuildInState(BuildState.NOT_STARTED, buildDefinition, monitor);
            }
            if ((inProgress || pendingRequest) && !this.displayConfirmationPreExistingBuilds(buildDefinition, inProgress, pendingRequest)) {
                return Status.OK_STATUS;
            }
        }
        List newBuildProperties = buildDefinition.getProperties();
        Vector<IBuildProperty> deletedBuildProperties = new Vector<IBuildProperty>();
        if (this.fOriginalBuildProperties != null) {
            for (IBuildProperty originalProperty : this.fOriginalBuildProperties) {
                boolean deleted = true;
                for (IBuildProperty newProperty : newBuildProperties) {
                    if (!newProperty.getName().equals(originalProperty.getName())) continue;
                    deleted = false;
                    break;
                }
                if (!deleted) continue;
                deletedBuildProperties.add(originalProperty);
            }
        }
        IBuildProperty[] newPropertiesArray = newBuildProperties.toArray(new IBuildProperty[newBuildProperties.size()]);
        IBuildProperty[] deletedPropertiesArray = deletedBuildProperties.toArray(new IBuildProperty[deletedBuildProperties.size()]);
        this.requestBuild(teamRepository, (IBuildDefinitionHandle)buildDefinition, newPropertiesArray, deletedPropertiesArray, true, monitor);
        final ITeamArea teamArea = (ITeamArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinition.getTeamArea(), 0, monitor);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                RequestBuildDialog.this.handleAsyncShowBuildsView(teamArea.getProjectArea(), buildDefinition);
            }
        });
        return Status.OK_STATUS;
    }

    private void setPersonalBuildProperties(IBuildDefinition buildDefinition) {
        IBuildProperty property = buildDefinition.getProperty("team.scm.workspaceUUID");
        property.setValue(this.fPersonalBuildWorkspace.getItemId().getUuidValue());
        if (this.fComponentLoadRules != null) {
            property = this.fBuildDefinition.getProperty("team.scm.componentLoadRules");
            if (property == null) {
                property = BuildItemFactory.createBuildProperty();
                property.setName("team.scm.componentLoadRules");
                property.setGenericEditAllowed(false);
                this.fBuildDefinition.getProperties().add(property);
            }
            property.setValue(this.fComponentLoadRules.getBuildPropertySetting());
        }
    }

    private boolean anyEnginesSupportingRequests(IBuildDefinition buildDefinition, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        return client.anyBuildEnginesWithRequestProcessingEnabled((IBuildDefinitionHandle)buildDefinition, monitor);
    }

    protected boolean anyResponsiveEngines(IBuildDefinitionHandle buildDefinition, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        return client.anyResponsiveBuildEngines(buildDefinition, monitor);
    }

    protected void handleAsyncShowBuildsView(IProjectAreaHandle projectAreaHandle, IBuildDefinition buildDefinition) {
        int buildsViewPreference = BuildUIPlugin.getDefault().getPreferenceStore().getInt(PREFERENCE_SHOW_BUILDS_VIEW);
        if (buildsViewPreference != 2) {
            this.showBuildsView(projectAreaHandle, buildDefinition, buildsViewPreference);
        }
    }

    protected void showBuildsView(IProjectAreaHandle projectAreaHandle, IBuildDefinition buildDefinition, int buildsViewOption) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            Action action = buildsViewOption == 1 ? new ShowBuildQueueAction(projectAreaHandle) : new ShowHistoryAction(buildDefinition);
            action.run();
        }
    }

    protected void handleRequestJobCompleted(IJobChangeEvent event) {
    }

    protected IBuildRequest requestBuild(ITeamRepository teamRepository, IBuildDefinitionHandle buildDefinitionHandle, IBuildProperty[] newAndModifiedBuildProperties, IBuildProperty[] deletedBuildProperties, boolean allowDuplicateRequests, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        ITeamBuildRequestClient requestClient = ClientFactory.getTeamBuildRequestClient((ITeamRepository)teamRepository);
        return requestClient.requestBuild(buildDefinitionHandle, newAndModifiedBuildProperties, deletedBuildProperties, true, this.fIsPersonalBuild, monitor);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fIsRebuild) {
            newShell.setText(BuildUIDialogMessages.RequestBuildDialog_DIALOG_TITLE_REQUEST_REBUILD);
        } else {
            newShell.setText(BuildUIDialogMessages.RequestBuildDialog_DIALOG_TITLE_REQUEST_BUILD);
        }
    }

    public void create() {
        super.create();
        Button okButton = this.getButton(0);
        okButton.setText(BuildUIDialogMessages.REQUEST_BUILD_SUBMIT);
        okButton.setEnabled(false);
        Button cancelButton = this.getButton(1);
        this.getShell().setDefaultButton(cancelButton);
        cancelButton.setFocus();
    }
}

