/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.feed.BuildFeedConfigurer;
import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.foundation.common.util.Adapters;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class SubscribeToFeedAction
extends Action
implements INewsManagerListener {
    public static final String ACTION_ID = "build.subscribe.to.feed";
    public static final String TEAM_ARTIFACTS_ID = "com.ibm.team.process.rcp.ui.teamArtifactsNavigator";
    private String fBuildDefinitionId;
    private IBuildDefinitionHandle fBuildDefinitionHandle;
    private Channel fChannel;

    public SubscribeToFeedAction(String buildDefinitionId, IBuildDefinitionHandle buildDefinitionHandle) {
        super(BuildUIActionMessages.SubscribeToFeedAction_SUBSCRIBE_TO_FEED);
        this.fBuildDefinitionId = buildDefinitionId;
        this.fBuildDefinitionHandle = buildDefinitionHandle;
    }

    public void run() {
        FeedManager feedManager = FeedManager.getDefault();
        feedManager.addNewsManagerListener((INewsManagerListener)this);
        BuildFeedConfigurer configurer = new BuildFeedConfigurer();
        this.fChannel = configurer.addDefinitionChannel(this.fBuildDefinitionId, this.fBuildDefinitionHandle, feedManager);
        this.handleChannelAdded(this.fChannel);
    }

    public String getId() {
        return ACTION_ID;
    }

    public void channelAdded(final ChannelEvent event) {
        if (event.getChannel().equals((Object)this.fChannel)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SubscribeToFeedAction.this.handleChannelAdded(event.getChannel());
                }
            });
        }
    }

    protected void handleChannelAdded(Channel channel) {
        try {
            IShowInTarget showInTarget;
            IViewPart view = this.showTeamArtifactsView();
            if (view != null && (showInTarget = (IShowInTarget)Adapters.getAdapter((Object)view, IShowInTarget.class)) != null) {
                showInTarget.show(new ShowInContext(null, (ISelection)new TreeSelection(new TreePath(new Object[]{FeedManager.getDefault(), this.fChannel}))));
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog dialog = this.getErrorDialog(BuildUIActionMessages.SubscribeToFeedAction_ERROR_ACTIVATING_VIEW, BuildUIActionMessages.SubscribeToFeedAction_ERROR_ACTIVATING_VIEW_MESSAGE);
            dialog.open();
        }
        FeedManager feedManager = FeedManager.getDefault();
        feedManager.removeNewsManagerListener((INewsManagerListener)this);
    }

    protected MessageDialog getErrorDialog(String title, String message) {
        return new MessageDialog(this.getShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            shell = window.getShell();
        }
        return shell;
    }

    public void channelRemoved(ChannelEvent event) {
    }

    protected IViewPart showTeamArtifactsView() throws PartInitException {
        IViewPart view = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            page.showView(TEAM_ARTIFACTS_ID);
            view = page.findView(TEAM_ARTIFACTS_ID);
        }
        return view;
    }
}

