/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.ui.editors.result.compile.CompileSourceNode;
import com.ibm.team.build.internal.ui.helper.WorkspaceHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class OpenCompileSourceActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof CompileSourceNode) {
            ICompileSource compileSource = ((CompileSourceNode)this.fSelection.getFirstElement()).getCompileSource();
            this.openCompileSource(compileSource, 1, this.fTargetPart.getSite().getPage());
        }
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected IWorkbenchPart getActivePart() {
        return this.fTargetPart;
    }

    protected void openCompileSource(ICompileSource compileSource, int lineNumber, IWorkbenchPage workbenchPage) {
        String javaFileName = compileSource.getSourceName();
        String javaTypeName = javaFileName.substring(0, javaFileName.length() - 5);
        String fullTypeName = String.valueOf(compileSource.getCompilePackage().getPackageName()) + "." + javaTypeName;
        this.openJavaSourceFile(fullTypeName, lineNumber, workbenchPage);
    }

    protected void openJavaSourceFile(String fullTypeName, int lineNumber, IWorkbenchPage workbenchPage) {
        WorkspaceHelper.openJavaSourceFile(fullTypeName, lineNumber, workbenchPage.getActiveEditor().getEditorSite());
    }
}

