/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBuildEngineActionDelegate
extends AbstractRepositoryActionDelegate
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    @Override
    protected String getConfirmationMessage() {
        return BuildUIActionMessages.DeleteBuildEngineActionDelegate_0;
    }

    @Override
    protected String getJobLabel() {
        return BuildUIActionMessages.DeleteBuildEngineActionDelegate_1;
    }

    @Override
    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ArrayList<IBuildEngine> selectedEngines = new ArrayList<IBuildEngine>();
        IStructuredSelection selection = (IStructuredSelection)this.fSelection;
        for (Object element : selection) {
            if (!(element instanceof IBuildEngine)) continue;
            selectedEngines.add((IBuildEngine)element);
        }
        this.removeEngines(selectedEngines, progressMonitor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    private void removeEngines(List<IBuildEngine> engines, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        progressMonitor.beginTask(BuildUIActionMessages.DeleteBuildEngineActionDelegate_1, engines.size());
        try {
            for (IBuildEngine engine : engines) {
                ITeamRepository teamRepository = (ITeamRepository)engine.getOrigin();
                ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
                try {
                    teamBuildClient.delete((IBuildEngineHandle)engine, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                catch (ItemNotFoundException itemNotFoundException) {}
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

