/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.helper.ClipboardHelper;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public class CopyBuildPropertyAsPropertiesFormatActionDelegate
extends ActionDelegate
implements IActionDelegate {
    private static final String NAME_VALUE_LINE = "{0} = {1}";
    private static final String DESCRIPTION_LINE = "# {0}";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private List fSelectedElements;

    public void run(IAction action) {
        if (this.fSelectedElements != null && !this.fSelectedElements.isEmpty()) {
            StringBuffer fBuffer = new StringBuffer();
            Iterator iter = this.fSelectedElements.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof IBuildProperty)) continue;
                IBuildProperty currentProperty = (IBuildProperty)next;
                String description = currentProperty.getDescription();
                if (description != null && !description.equals("")) {
                    fBuffer.append(MessageFormat.format(DESCRIPTION_LINE, description));
                    fBuffer.append(LINE_SEPARATOR);
                }
                fBuffer.append(MessageFormat.format(NAME_VALUE_LINE, currentProperty.getName(), currentProperty.getValue()));
                if (!iter.hasNext()) continue;
                fBuffer.append(System.getProperty("line.separator"));
                fBuffer.append(System.getProperty("line.separator"));
            }
            ClipboardHelper.getDefault().copyTextToClipboard(fBuffer.toString(), Display.getCurrent());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedElements = ((IStructuredSelection)selection).toList();
        }
    }
}

