/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.actions;

import com.ibm.team.build.common.TeamBuildStateException;
import com.ibm.team.build.internal.ui.actions.BuildUIActionMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractRepositoryActionDelegate
extends ActionDelegate {
    private Shell fDialogParentShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();

    protected AbstractRepositoryActionDelegate() {
    }

    protected abstract String getConfirmationMessage();

    protected abstract void performAction(IProgressMonitor var1) throws TeamRepositoryException;

    protected ITeamRepository getRepositoryToValidate() {
        return null;
    }

    protected void showWarningDialog(String title, String message) {
        BuildUIHelper.showWarningDialog(this.getShell(), title, message);
    }

    protected abstract String getJobLabel();

    public void run(IAction action) {
        boolean proceed;
        String confirmationMessage = this.getConfirmationMessage();
        if (confirmationMessage != null && !(proceed = BuildUIHelper.showQueryDialog(BuildUIActionMessages.AbstractRepositoryActionDelegate_0, confirmationMessage))) {
            return;
        }
        TeamBuildJob job = this.createJob();
        job.setUser(true);
        job.schedule();
    }

    protected Shell getShell() {
        return this.fDialogParentShell;
    }

    protected TeamBuildJob createJob() {
        TeamBuildJobContext context = new TeamBuildJobContext(){

            public boolean isExpectedStatus(Job job, IStatus status) {
                if (status.getException() instanceof TeamBuildStateException) {
                    return true;
                }
                return super.isExpectedStatus(job, status);
            }
        };
        return new TeamBuildJob(this.getJobLabel(), true, context){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                AbstractRepositoryActionDelegate.this.performAction(monitor);
                return Status.OK_STATUS;
            }
        };
    }
}

