/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.jface.JazzResources;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BuildUIPlugin
extends AbstractUIPlugin {
    private static BuildUIPlugin fgBuildPlugin;
    private ResourceManager fResourceManager;
    private static final String PLUGIN_ID = "com.ibm.team.build.ui";
    public static final int INTERNAL_ERROR = 120;

    public BuildUIPlugin() {
        fgBuildPlugin = this;
    }

    public static BuildUIPlugin getDefault() {
        return fgBuildPlugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        BuildUIPlugin.log((IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), 4, message, exception));
    }

    public static void log(String message) {
        if (message == null) {
            message = "";
        }
        BuildUIPlugin.log((IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public static Image getImage(String path) {
        ImageRegistry imageRegistry = BuildUIPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(path);
        if (image == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)BuildUIPlugin.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
            image = imageRegistry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageRegistry imageRegistry = BuildUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor descriptor = imageRegistry.getDescriptor(path);
        if (descriptor == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)BuildUIPlugin.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
        }
        return descriptor;
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public static Image getImage(ImageDescriptor imageDesc) {
        return JazzResources.getImageWithDefault((ResourceManager)BuildUIPlugin.getDefault().getResourceManager(), (ImageDescriptor)imageDesc);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            Job.getJobManager().cancel((Object)fgBuildPlugin);
        }
        finally {
            super.stop(context);
        }
    }
}

