/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ui.AbstractBuildCompositeImageDescriptor;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class BuildStatusCompositeImageDescriptor
extends AbstractBuildCompositeImageDescriptor {
    public BuildStatusCompositeImageDescriptor(Image baseImage, BuildStatus status) {
        super(baseImage, status);
    }

    protected ImageData getOverlay() {
        ImageData data = null;
        BuildStatus status = (BuildStatus)this.getAdornmentObject();
        switch (status) {
            case ERROR: {
                data = BuildUIPlugin.getImageDescriptor("icons/ovr16/failed_ovr.gif").getImageData();
                break;
            }
            case OK: {
                data = BuildUIPlugin.getImageDescriptor("icons/ovr16/success_ovr.gif").getImageData();
                break;
            }
            case WARNING: {
                data = BuildUIPlugin.getImageDescriptor("icons/ovr16/warn_ovr.gif").getImageData();
            }
        }
        return data;
    }

    private static ImageDescriptor getBuildResultCompositeImageDescriptor(IBuildResult result) {
        Object desc = null;
        if (result == null) {
            desc = BuildUIPlugin.getImageDescriptor("icons/obj16/abanblds_obj.gif");
        } else if (result.getState() == BuildState.INCOMPLETE) {
            desc = BuildUIPlugin.getImageDescriptor("icons/obj16/abanblds_obj.gif");
        } else {
            Image newImage = BuildUIPlugin.getImage("icons/obj16/bld_rslt.gif");
            desc = new BuildStatusCompositeImageDescriptor(newImage, result.getStatus());
        }
        return desc;
    }

    public static Image getBuildResultComposite(IBuildResult result, ResourceManager resourceManager) {
        return resourceManager.createImage(BuildStatusCompositeImageDescriptor.getBuildResultCompositeImageDescriptor(result));
    }
}

