/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.IBuildPropertyControlListener;
import com.ibm.team.build.internal.ui.dialogs.BuildPropertyDialog;
import com.ibm.team.build.internal.ui.dialogs.BuildPropertyKindSelectionDialog;
import com.ibm.team.build.internal.ui.editors.builddefinition.PropertyTableComparator;
import com.ibm.team.build.internal.ui.editors.builddefinition.PropertyTableContentProvider;
import com.ibm.team.build.internal.ui.editors.builddefinition.PropertyTableLabelProvider;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtension;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtensionManager;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildPropertyControl {
    protected ITeamRepository fTeamRepository;
    protected Shell fParentShell;
    protected List fBuildProperties;
    protected Button fAddPropertyButton;
    protected Button fEditPropertyButton;
    protected Button fRemovePropertyButton;
    protected TableViewer fTableViewer;
    protected Label fDescriptionLabel;
    private PropertyTableComparator fPropertyTableSorter;
    private ListenerList fListenerList = new ListenerList();
    private Composite fDescriptionComposite;
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_VALUE = "value";
    private static final String COLUMN_DESCRIPTION = "description";
    private static final String[] FULL_LAYOUT_COLUMN_PROPERTIES = new String[]{"name", "value", "description"};
    private static final String[] COMPACT_LAYOUT_COLUMN_PROPERTIES = new String[]{"name", "value"};
    private static final String[] FULL_LAYOUT_COLUMN_HEADERS = new String[]{BuildUIMessages.BuildPropertyControl_NAME, BuildUIMessages.BuildPropertyControl_VALUE, BuildUIMessages.BuildPropertyControl_DESCRIPTION};
    private static final String[] COMPACT_LAYOUT_COLUMN_HEADERS = new String[]{BuildUIMessages.BuildPropertyControl_NAME, BuildUIMessages.BuildPropertyControl_VALUE};
    private static final int[] COMPACT_LAYOUT_COLUMN_WEIGHTS = new int[]{50, 50};
    private static final int[] FULL_LAYOUT_COLUMN_WEIGHTS = new int[]{30, 40, 30};
    private FormToolkit fToolkit;
    private Composite fComposite;

    public BuildPropertyControl(Composite parent, FormToolkit toolkit, List buildProperties, ITeamRepository teamRepository, boolean isEditable, LayoutSize layoutSize) {
        this.fBuildProperties = buildProperties;
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        this.fTeamRepository = teamRepository;
        this.fComposite = this.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fComposite);
        boolean isCompact = layoutSize == LayoutSize.COMPACT;
        Composite tableComposite = this.createComposite(this.fComposite);
        GridDataFactory.fillDefaults().grab(true, true).span(isEditable ? 1 : 2, 1).applyTo((Control)tableComposite);
        Table table = this.createTable(tableComposite, 68354);
        TableColumnLayout layout = new TableColumnLayout();
        String[] columnProperties = isCompact ? COMPACT_LAYOUT_COLUMN_PROPERTIES : FULL_LAYOUT_COLUMN_PROPERTIES;
        String[] columnHeaders = isCompact ? COMPACT_LAYOUT_COLUMN_HEADERS : FULL_LAYOUT_COLUMN_HEADERS;
        int[] columnWeights = isCompact ? COMPACT_LAYOUT_COLUMN_WEIGHTS : FULL_LAYOUT_COLUMN_WEIGHTS;
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            this.setSelectionListenerOnColumn(column, columnProperties[i]);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        this.fTableViewer = this.getTableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        PropertyTableLabelProvider labelProvider = new PropertyTableLabelProvider(this.fTableViewer, teamRepository);
        this.fPropertyTableSorter = new PropertyTableComparator(labelProvider);
        this.fTableViewer.setComparator((ViewerComparator)this.fPropertyTableSorter);
        this.fTableViewer.setContentProvider((IContentProvider)new PropertyTableContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTableViewer.setInput((Object)this.fBuildProperties);
        this.fTableViewer.setFilters(new ViewerFilter[]{this.getViewerFilter()});
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        if (isEditable) {
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    BuildPropertyControl.this.handleDoubleClick(event);
                }
            });
            Composite buttonBar = this.createComposite(this.fComposite);
            buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
            buttonBar.setLayout((Layout)new GridLayout(1, false));
            this.fAddPropertyButton = this.createButton(buttonBar, BuildUIMessages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fAddPropertyButton.addSelectionListener(this.getAddPropertyListener());
            this.fRemovePropertyButton = this.createButton(buttonBar, BuildUIMessages.REMOVE_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fRemovePropertyButton.addSelectionListener(this.getRemovePropertyListener());
            this.fEditPropertyButton = this.createButton(buttonBar, BuildUIMessages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fEditPropertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IBuildProperty buildProperty = BuildPropertyControl.this.getSelectedProperty();
                    if (buildProperty != null) {
                        BuildPropertyControl.this.editProperty(buildProperty);
                    }
                }
            });
            this.updatePropertyButtonEnablement();
            this.setButtonLayoutData();
        }
        if (isCompact) {
            this.fDescriptionComposite = this.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).span(isEditable ? 2 : 1, 1).applyTo((Control)this.fDescriptionComposite);
            GridLayoutFactory.fillDefaults().applyTo(this.fDescriptionComposite);
            Label descriptionTitle = new Label(this.fDescriptionComposite, 0);
            descriptionTitle.setText(BuildUIMessages.BuildPropertyControl_DESCRIPTION_LABEL);
            descriptionTitle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.fDescriptionLabel = new Label(this.fDescriptionComposite, 64);
            this.fDescriptionLabel.setText(BuildUIMessages.BuildPropertyControl_NO_PROPERTY_SELECTED_DESCRIPTION);
            GridDataFactory.fillDefaults().indent(10, 0).grab(true, false).applyTo((Control)this.fDescriptionLabel);
        }
    }

    protected SelectionListener getRemovePropertyListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPropertyControl.this.removeSelectedProperties();
            }
        };
    }

    protected ViewerFilter getViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IBuildProperty property = (IBuildProperty)element;
                return property.isGenericEditAllowed();
            }
        };
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildPropertyControl.this.updatePropertyButtonEnablement();
                BuildPropertyControl.this.updateDescriptionLabel();
            }
        };
    }

    protected SelectionListener getAddPropertyListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPropertyControl.this.addProperty();
            }
        };
    }

    public List getBuildProperties() {
        return this.fBuildProperties;
    }

    public void setBuildProperties(List buildProperties) {
        this.fBuildProperties = buildProperties;
        this.fTableViewer.setInput((Object)this.fBuildProperties);
        this.updatePropertyButtonEnablement();
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    private void addProperty() {
        String propertyKindId = this.getPropertyKindId(this.fParentShell);
        if (propertyKindId != null) {
            IBuildProperty buildProperty = BuildItemFactory.createBuildProperty();
            buildProperty.setKind(propertyKindId);
            BuildPropertyDialog dialog = this.getBuildPropertyDialog(buildProperty);
            if (dialog.open() == 0) {
                this.fBuildProperties.add(buildProperty);
                this.fTableViewer.refresh();
                this.updatePropertyButtonEnablement();
                this.notifyPropertyAdded(buildProperty);
            }
        }
    }

    protected BuildPropertyDialog getBuildPropertyDialog(IBuildProperty buildProperty) {
        return new BuildPropertyDialog(this.fParentShell, BuildUIMessages.BuildPropertyControl_ADD_TITLE, buildProperty, this.fBuildProperties, true, this.fTeamRepository);
    }

    private void editProperty(IBuildProperty buildProperty) {
        BuildPropertyDialog dialog = new BuildPropertyDialog(this.fParentShell, BuildUIMessages.BuildPropertyControl_EDIT_TITLE, buildProperty, this.fBuildProperties, false, this.fTeamRepository);
        if (dialog.open() == 0) {
            this.fTableViewer.refresh();
            this.notifyPropertyEdited(buildProperty);
        }
    }

    protected String getPropertyKindId(Shell shell) {
        String id = null;
        BuildPropertyEditorExtension[] extensions = BuildPropertyEditorExtensionManager.getInstance().getBuildPropertyEditors();
        if (extensions.length > 0) {
            String[] kinds = new String[extensions.length + 1];
            kinds[0] = BuildUIMessages.BuildPropertyControl_STRING_PROPERTY_KIND_LABEL;
            int i = 0;
            while (i < extensions.length) {
                kinds[i + 1] = extensions[i].getNameAttribute();
                ++i;
            }
            BuildPropertyKindSelectionDialog dialog = this.getPropertyKindSelectionDialog(shell, kinds);
            if (dialog.open() == 0) {
                int selectedKind = dialog.getSelectedKind();
                if (selectedKind == 0) {
                    id = "com.ibm.team.build.property.string";
                } else if (selectedKind > 0) {
                    id = extensions[selectedKind - 1].getIdAttribute();
                }
            }
        }
        return id;
    }

    protected BuildPropertyKindSelectionDialog getPropertyKindSelectionDialog(Shell shell, String[] kinds) {
        return new BuildPropertyKindSelectionDialog(shell, BuildUIMessages.BuildPropertyControl_ADD_TITLE, kinds);
    }

    private void removeSelectedProperties() {
        ISelection selection;
        boolean deleteConfirmed = this.confirmPropertyRemoval();
        if (deleteConfirmed && (selection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IBuildProperty> propertiesRequired = new ArrayList<IBuildProperty>();
            ArrayList<IBuildProperty> propertiesRemoved = new ArrayList<IBuildProperty>();
            ArrayList<IBuildProperty> propertiesReadOnly = new ArrayList<IBuildProperty>();
            for (IBuildProperty buildProperty : structuredSelection) {
                if (buildProperty.isRequired()) {
                    propertiesRequired.add(buildProperty);
                    continue;
                }
                if (buildProperty.getKind().equals("com.ibm.team.build.property.readonly.string")) {
                    propertiesReadOnly.add(buildProperty);
                    continue;
                }
                this.fTableViewer.remove((Object)buildProperty);
                this.fBuildProperties.remove(buildProperty);
                propertiesRemoved.add(buildProperty);
            }
            if (!propertiesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.updatePropertyButtonEnablement();
                this.notifyPropertiesRemoved(propertiesRemoved.toArray(new IBuildProperty[propertiesRemoved.size()]));
            }
            if (!propertiesRequired.isEmpty()) {
                this.showRequiredPropertiesError();
            }
            if (!propertiesReadOnly.isEmpty()) {
                this.showReadOnlyPropertiesError();
            }
        }
    }

    protected boolean confirmPropertyRemoval() {
        return MessageDialog.openQuestion((Shell)this.fParentShell, (String)BuildUIMessages.BuildPropertyControl_CONFIRM_TITLE, (String)BuildUIMessages.BuildPropertyControl_CONFIRM);
    }

    protected void showReadOnlyPropertiesError() {
        MessageDialog.openError((Shell)this.fParentShell, (String)BuildUIMessages.BuildPropertyControl_READ_ONLY_TITLE, (String)BuildUIMessages.BuildPropertyControl_READ_ONLY_MESSAGE);
    }

    protected void showRequiredPropertiesError() {
        MessageDialog.openError((Shell)this.fParentShell, (String)BuildUIMessages.BuildPropertyControl_REQUIRED_PROPERTIES_TITLE, (String)BuildUIMessages.BuildPropertyControl_REQUIRED_PROPERTIES_MESSAGE);
    }

    protected IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private IBuildProperty getSelectedProperty() {
        IStructuredSelection selection = this.getCurrentPropertySelection();
        Object element = selection.getFirstElement();
        if (element instanceof IBuildProperty) {
            return (IBuildProperty)element;
        }
        return null;
    }

    private void updateDescriptionLabel() {
        if (this.fDescriptionLabel != null) {
            IStructuredSelection selection = this.getCurrentPropertySelection();
            if (selection.size() > 1) {
                this.fDescriptionLabel.setText(BuildUIMessages.BuildPropertyControl_MULTIPLE_PROPERTIES_SELECTED_DESCRIPTION);
            } else if (selection.size() == 1) {
                IBuildProperty buildProperty = (IBuildProperty)selection.getFirstElement();
                String description = buildProperty.getDescription();
                this.fDescriptionLabel.setText(description.length() == 0 ? BuildUIMessages.BuildPropertyControl_DESCRIPTION_LABEL_NO_DESCRIPTION : description);
            }
            this.fDescriptionComposite.getParent().layout(true);
        }
    }

    private void updatePropertyButtonEnablement() {
        IBuildProperty property;
        if (this.fEditPropertyButton == null) {
            return;
        }
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fEditPropertyButton.setEnabled(false);
        if (selection.size() == 1 && !(property = (IBuildProperty)selection.getFirstElement()).getKind().equals("com.ibm.team.build.property.readonly.string")) {
            this.fEditPropertyButton.setEnabled(true);
        }
        this.fRemovePropertyButton.setEnabled(!selection.isEmpty());
    }

    public void addListener(IBuildPropertyControlListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeListener(IBuildPropertyControlListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected void notifyPropertyAdded(IBuildProperty buildProperty) {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IBuildPropertyControlListener) {
                IBuildPropertyControlListener listener = (IBuildPropertyControlListener)listeners[i];
                listener.propertyAdded(buildProperty);
            }
            ++i;
        }
    }

    protected void notifyPropertyEdited(IBuildProperty buildProperty) {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IBuildPropertyControlListener) {
                IBuildPropertyControlListener listener = (IBuildPropertyControlListener)listeners[i];
                listener.propertyEdited(buildProperty);
            }
            ++i;
        }
    }

    protected void notifyPropertiesRemoved(IBuildProperty[] buildProperties) {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IBuildPropertyControlListener) {
                IBuildPropertyControlListener listener = (IBuildPropertyControlListener)listeners[i];
                listener.propertiesRemoved(buildProperties);
            }
            ++i;
        }
    }

    private Composite createComposite(Composite parent) {
        if (this.fToolkit != null) {
            return this.fToolkit.createComposite(parent);
        }
        return new Composite(parent, 0);
    }

    private Button createButton(Composite parent, String label, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createButton(parent, label, style);
        }
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    private Table createTable(Composite parent, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createTable(parent, style);
        }
        return new Table(parent, style);
    }

    private void setSelectionListenerOnColumn(TableColumn column, final String property) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private boolean fReverse = false;

            public void widgetSelected(SelectionEvent e) {
                int sortColumn = 0;
                if (property.equals(BuildPropertyControl.COLUMN_NAME)) {
                    sortColumn = 0;
                } else if (property.equals(BuildPropertyControl.COLUMN_VALUE)) {
                    sortColumn = 1;
                } else if (property.equals(BuildPropertyControl.COLUMN_DESCRIPTION)) {
                    sortColumn = 2;
                }
                BuildPropertyControl.this.fPropertyTableSorter.setSortColumn(sortColumn);
                Table table = BuildPropertyControl.this.fTableViewer.getTable();
                table.setSortColumn(table.getColumn(sortColumn));
                if (this.fReverse) {
                    table.setSortDirection(1024);
                    BuildPropertyControl.this.fPropertyTableSorter.setReverse(this.fReverse);
                } else {
                    table.setSortDirection(128);
                    BuildPropertyControl.this.fPropertyTableSorter.setReverse(this.fReverse);
                }
                this.fReverse = !this.fReverse;
                BuildPropertyControl.this.fTableViewer.refresh();
            }
        });
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IBuildProperty) {
            IBuildProperty buildProperty = (IBuildProperty)element;
            this.editProperty(buildProperty);
        }
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fAddPropertyButton);
        gc.setFont(this.fAddPropertyButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddPropertyButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fEditPropertyButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemovePropertyButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fAddPropertyButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fEditPropertyButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRemovePropertyButton.setLayoutData((Object)gridData);
    }

    public void setEnabled(boolean enabled) {
        this.fAddPropertyButton.setEnabled(enabled);
        this.fEditPropertyButton.setEnabled(enabled);
        this.fRemovePropertyButton.setEnabled(enabled);
        this.fTableViewer.getTable().setEnabled(enabled);
        if (enabled) {
            this.updatePropertyButtonEnablement();
        }
    }

    public Viewer getViewer() {
        return this.fTableViewer;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    protected TableViewer getTableViewer(Table table) {
        return new TableViewer(table);
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LayoutSize {
        COMPACT,
        FULL;

    }
}

