/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractBuildCompositeImageDescriptor
extends CompositeImageDescriptor {
    private Image fBaseImage;
    private Object fAdornmentObject;
    private Point fSize;

    public AbstractBuildCompositeImageDescriptor(Image baseImage, Object adornmentObject) {
        this.fBaseImage = baseImage;
        this.fAdornmentObject = adornmentObject;
    }

    protected Object getAdornmentObject() {
        return this.fAdornmentObject;
    }

    protected Point getOverlayLocation(ImageData overlay) {
        return new Point(0, this.getSize().y - overlay.height);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.fBaseImage.getImageData();
            this.fSize = new Point(data.width, data.height);
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractBuildCompositeImageDescriptor)) {
            return false;
        }
        AbstractBuildCompositeImageDescriptor other = (AbstractBuildCompositeImageDescriptor)((Object)object);
        return this.fBaseImage.equals((Object)other.fBaseImage) && this.fAdornmentObject.equals(other.fAdornmentObject);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fAdornmentObject.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.fBaseImage.getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        ImageData data = this.getOverlay();
        if (data != null) {
            Point location = this.getOverlayLocation(data);
            this.drawImage(data, location.x, location.y);
        }
    }

    protected abstract ImageData getOverlay();

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

