/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.builddefinition;

import com.ibm.team.build.internal.common.builddefinition.BuildDefinitionTemplateExtension;
import com.ibm.team.build.internal.common.builddefinition.Messages;
import com.ibm.team.repository.common.LogFactory;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class BuildDefinitionTemplateExtensionManager {
    public static final String EXTENSION_POINT_ID_BUILD_DEFINITION_TEMPLATES = "com.ibm.team.build.common.buildDefinitionTemplates";
    protected static BuildDefinitionTemplateExtensionManager fManager = null;

    protected BuildDefinitionTemplateExtensionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildDefinitionTemplateExtensionManager getInstance() {
        Class<BuildDefinitionTemplateExtensionManager> clazz = BuildDefinitionTemplateExtensionManager.class;
        synchronized (BuildDefinitionTemplateExtensionManager.class) {
            if (fManager == null) {
                fManager = new BuildDefinitionTemplateExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public BuildDefinitionTemplateExtension[] getBuildDefinitionTemplates() {
        return this.loadBuildDefinitionTemplateExtensions();
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    public BuildDefinitionTemplateExtension getBuildDefinitionTemplate(String templateId) {
        BuildDefinitionTemplateExtension[] extensions;
        BuildDefinitionTemplateExtension[] buildDefinitionTemplateExtensionArray = extensions = this.loadBuildDefinitionTemplateExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            BuildDefinitionTemplateExtension extension = buildDefinitionTemplateExtensionArray[n2];
            if (extension.getIdAttribute().equals(templateId)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    private BuildDefinitionTemplateExtension[] loadBuildDefinitionTemplateExtensions() {
        LinkedList<BuildDefinitionTemplateExtension> extensions = new LinkedList<BuildDefinitionTemplateExtension>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_BUILD_DEFINITION_TEMPLATES);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    BuildDefinitionTemplateExtension extension = new BuildDefinitionTemplateExtension(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions.toArray(new BuildDefinitionTemplateExtension[extensions.size()]);
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("id"), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.BuildConfigurationElementExtensionManager_DUPLICATE_EXTENSION, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.build.common").error((Object)message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.BuildConfigurationElementExtensionManager_ILLEGAL_OR_MISSING_ATTRIBUTE, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.build.common").error((Object)(String.valueOf(message) + " " + exception.getMessage()));
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

