/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.builddefinition;

import com.ibm.team.build.internal.common.builddefinition.BuildConfigurationElementExtension;
import com.ibm.team.build.internal.common.builddefinition.Messages;
import com.ibm.team.repository.common.LogFactory;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class BuildConfigurationElementExtensionManager {
    public static final String EXTENSION_POINT_ID_BUILD_CONFIGURATION_ELEMENTS = "com.ibm.team.build.common.buildConfigurationElements";
    protected static BuildConfigurationElementExtensionManager fManager = null;

    protected BuildConfigurationElementExtensionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildConfigurationElementExtensionManager getInstance() {
        Class<BuildConfigurationElementExtensionManager> clazz = BuildConfigurationElementExtensionManager.class;
        synchronized (BuildConfigurationElementExtensionManager.class) {
            if (fManager == null) {
                fManager = new BuildConfigurationElementExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public BuildConfigurationElementExtension[] getBuildConfigurationElements() {
        return this.loadBuildConfigurationElementExtensions();
    }

    public BuildConfigurationElementExtension getBuildConfigurationElement(String elementId) {
        BuildConfigurationElementExtension[] extensions;
        BuildConfigurationElementExtension[] buildConfigurationElementExtensionArray = extensions = this.loadBuildConfigurationElementExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            BuildConfigurationElementExtension extension = buildConfigurationElementExtensionArray[n2];
            if (extension.getElementIdAttribute().equals(elementId)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private BuildConfigurationElementExtension[] loadBuildConfigurationElementExtensions() {
        LinkedList<BuildConfigurationElementExtension> extensions = new LinkedList<BuildConfigurationElementExtension>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_BUILD_CONFIGURATION_ELEMENTS);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    BuildConfigurationElementExtension extension = new BuildConfigurationElementExtension(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions.toArray(new BuildConfigurationElementExtension[extensions.size()]);
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("id"), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.BuildConfigurationElementExtensionManager_DUPLICATE_EXTENSION, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.build.common").error((Object)message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.BuildConfigurationElementExtensionManager_ILLEGAL_OR_MISSING_ATTRIBUTE, (Object[])params);
        LogFactory.getLog((String)"com.ibm.team.build.common").error((Object)(String.valueOf(message) + " " + exception.getMessage()));
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

