/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildPhase;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public class BuildConfigurationElementExtension {
    public static final String ID_ATTRIBUTE = "id";
    public static final String BUILD_PHASE_ATTRIBUTE = "buildPhase";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String DEFAULT_VALUE_ATTRIBUTE = "defaultValue";
    public static final String KIND_ATTRIBUTE = "kind";
    public static final String GENERIC_EDIT_ALLOWED_ATTRIBUTE = "genericEditAllowed";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String GENERIC_PROPERTY_ELEMENT = "genericProperty";
    public static final String CONFIGURATION_PROPERTY_ELEMENT = "configurationProperty";
    private String fIdAttribute;
    private String fNameAttribute;
    private String fDescriptionAttribute;
    private BuildPhase fBuildPhaseAttribute = BuildPhase.UNSPECIFIED;
    private List<IBuildProperty> fGenericProperties = new ArrayList<IBuildProperty>();
    private List<IConfigurationProperty> fConfigurationProperties = new ArrayList<IConfigurationProperty>();

    public BuildConfigurationElementExtension(IConfigurationElement pluginConfigurationElement) {
        ValidationHelper.validateNotNull("pluginConfigurationElement", pluginConfigurationElement);
        this.fIdAttribute = pluginConfigurationElement.getAttribute(ID_ATTRIBUTE);
        ValidationHelper.validateNotNull(ID_ATTRIBUTE, this.fIdAttribute);
        ValidationHelper.validateNotEmpty(ID_ATTRIBUTE, this.fIdAttribute.trim());
        this.fNameAttribute = pluginConfigurationElement.getAttribute(NAME_ATTRIBUTE);
        ValidationHelper.validateNotNull(NAME_ATTRIBUTE, this.fNameAttribute);
        ValidationHelper.validateNotEmpty(NAME_ATTRIBUTE, this.fNameAttribute.trim());
        this.fDescriptionAttribute = pluginConfigurationElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        String buildPhase = pluginConfigurationElement.getAttribute(BUILD_PHASE_ATTRIBUTE);
        if (buildPhase != null) {
            this.fBuildPhaseAttribute = BuildPhase.valueOf(buildPhase);
        }
        this.processGenericProperties(pluginConfigurationElement);
        this.processConfigurationProperties(pluginConfigurationElement);
    }

    private void processGenericProperties(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren(GENERIC_PROPERTY_ELEMENT);
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String name = pluginElement.getAttribute(NAME_ATTRIBUTE);
            ValidationHelper.validateNotNull(NAME_ATTRIBUTE, name);
            ValidationHelper.validateNotEmpty(NAME_ATTRIBUTE, name.trim());
            String genericEditAllowed = pluginElement.getAttribute(GENERIC_EDIT_ALLOWED_ATTRIBUTE);
            ValidationHelper.validateNotNull(GENERIC_EDIT_ALLOWED_ATTRIBUTE, genericEditAllowed);
            ValidationHelper.validateNotEmpty(GENERIC_EDIT_ALLOWED_ATTRIBUTE, genericEditAllowed.trim());
            String description = pluginElement.getAttribute(DESCRIPTION_ATTRIBUTE);
            String defaultValue = pluginElement.getAttribute(DEFAULT_VALUE_ATTRIBUTE);
            String kind = pluginElement.getAttribute(KIND_ATTRIBUTE);
            String required = pluginElement.getAttribute(REQUIRED_ATTRIBUTE);
            IBuildProperty property = BuildItemFactory.createBuildProperty();
            property.setName(name);
            property.setGenericEditAllowed(Boolean.valueOf(genericEditAllowed));
            if (description != null && description.trim().length() > 0) {
                property.setDescription(description);
            }
            if (defaultValue != null && defaultValue.trim().length() > 0) {
                property.setValue(defaultValue);
            }
            if (kind != null && kind.trim().length() > 0) {
                property.setKind(kind);
            }
            if (required != null) {
                property.setRequired(Boolean.valueOf(required));
            }
            this.fGenericProperties.add(property);
            ++n2;
        }
    }

    private void processConfigurationProperties(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren(CONFIGURATION_PROPERTY_ELEMENT);
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String name = pluginElement.getAttribute(NAME_ATTRIBUTE);
            ValidationHelper.validateNotNull(NAME_ATTRIBUTE, name);
            ValidationHelper.validateNotEmpty(NAME_ATTRIBUTE, name.trim());
            String defaultValue = pluginElement.getAttribute(DEFAULT_VALUE_ATTRIBUTE);
            IConfigurationProperty property = BuildItemFactory.createConfigurationProperty();
            property.setName(name);
            if (defaultValue != null && defaultValue.trim().length() > 0) {
                property.setValue(defaultValue);
            }
            this.fConfigurationProperties.add(property);
            ++n2;
        }
    }

    public String getNameAttribute() {
        return this.fNameAttribute;
    }

    public String getDescriptionAttribute() {
        return this.fDescriptionAttribute;
    }

    public String getElementIdAttribute() {
        return this.fIdAttribute;
    }

    public BuildPhase getBuildPhaseAttribute() {
        return this.fBuildPhaseAttribute;
    }

    public IBuildProperty[] getGenericProperties() {
        return this.fGenericProperties.toArray(new IBuildProperty[this.fGenericProperties.size()]);
    }

    public IConfigurationProperty[] getConfigurationProperties() {
        return this.fConfigurationProperties.toArray(new IConfigurationProperty[this.fConfigurationProperties.size()]);
    }

    public int hashCode() {
        return this.fIdAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildConfigurationElementExtension other = (BuildConfigurationElementExtension)obj;
        return !(this.fIdAttribute == null ? other.fIdAttribute != null : !this.fIdAttribute.equals(other.fIdAttribute));
    }
}

