/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildActivity;
import com.ibm.team.build.common.model.IBuildActivityId;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.client.AbstractTeamBuildClient;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.Messages;
import com.ibm.team.build.internal.common.ITeamBuildService;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.service.IQueryService;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamBuildClient
extends AbstractTeamBuildClient
implements ITeamBuildClient {
    public TeamBuildClient(IClientLibraryContext context) {
        super(context);
    }

    private ITeamBuildService getService() {
        return (ITeamBuildService)this.getContext().getServiceInterface(ITeamBuildService.class);
    }

    @Override
    public IBuildDefinition getBuildDefinition(final String buildDefinitionId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IBuildDefinition)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildClient.this.addToItemManager((IItem)TeamBuildClient.this.getService().getBuildDefinition(buildDefinitionId));
            }
        });
    }

    @Override
    public Timestamp getLastContactTime(final IBuildEngineHandle buildEngineHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (Timestamp)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildClient.this.getService().getLastContactTime(buildEngineHandle);
            }
        });
    }

    @Override
    public IBuildEngine setLastContactTime(final IBuildEngineHandle buildEngineHandle, final Timestamp lastContactTime, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IBuildEngine)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class LastContactRunnable
                extends ProcessRunnable {
                    public IBuildEngine fBuildEngine;
                    private final /* synthetic */ IBuildEngineHandle val$buildEngineHandle;
                    private final /* synthetic */ Timestamp val$lastContactTime;

                    LastContactRunnable(IBuildEngineHandle iBuildEngineHandle, Timestamp timestamp) {
                        this.val$buildEngineHandle = iBuildEngineHandle;
                        this.val$lastContactTime = timestamp;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildClient.this.getService().setLastContactTime(this.val$buildEngineHandle, this.val$lastContactTime);
                        this.fBuildEngine = (IBuildEngine)response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                LastContactRunnable runnable = new LastContactRunnable(buildEngineHandle, lastContactTime);
                IProcessClientService processService = (IProcessClientService)TeamBuildClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildClient_SET_LAST_CONTACT_TIME_OPERATION_NAME, progressMonitor);
                return (IBuildEngine)TeamBuildClient.this.addToItemManager((IItem)runnable.fBuildEngine);
            }
        });
    }

    @Override
    public IBuildEngine getBuildEngine(final String id, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IBuildEngine)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildClient.this.addToItemManager((IItem)TeamBuildClient.this.getService().getBuildEngine(id));
            }
        });
    }

    @Override
    public IBuildResultContribution[] getBuildResultContributions(IBuildResultHandle buildResultHandle, String extendedContributionTypeId, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return this.getBuildResultContributions(buildResultHandle, new String[]{extendedContributionTypeId}, progressMonitor);
    }

    @Override
    public IBuildResultContribution[] getBuildResultContributions(final IBuildResultHandle buildResultHandle, final String[] extendedContributionTypeIds, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IBuildResultContribution[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildClient.this.getService().getBuildResultContributions(buildResultHandle, extendedContributionTypeIds);
            }
        });
    }

    @Override
    public void deleteBuildResultContributions(final IBuildResultHandle buildResultHandle, final IBuildResultContribution[] buildResultContributions, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor cancelableMonitor) throws TeamRepositoryException {
                IProcessClientService processService = (IProcessClientService)TeamBuildClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute(new ProcessRunnable(){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return TeamBuildClient.this.getService().deleteBuildResultContributions(buildResultHandle, buildResultContributions);
                    }
                }, Messages.AbstractTeamBuildClient_SAVE_BUILD_RESULT_OPERATION_NAME, progressMonitor);
                return null;
            }
        });
    }

    @Override
    public IBuildResult addBuildResultContributions(final IBuildResultHandle buildResultHandle, final IBuildResultContribution[] buildResultContributions, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IBuildResult)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class AddContributionsRunnable
                extends ProcessRunnable {
                    public IItem fBuildResult;
                    private final /* synthetic */ IBuildResultHandle val$buildResultHandle;
                    private final /* synthetic */ IBuildResultContribution[] val$buildResultContributions;
                    private final /* synthetic */ String[] val$properties;

                    AddContributionsRunnable(IBuildResultHandle iBuildResultHandle, IBuildResultContribution[] iBuildResultContributionArray, String[] stringArray) {
                        this.val$buildResultHandle = iBuildResultHandle;
                        this.val$buildResultContributions = iBuildResultContributionArray;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildClient.this.getService().addBuildResultContributions(this.val$buildResultHandle, this.val$buildResultContributions, this.val$properties);
                        this.fBuildResult = response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                AddContributionsRunnable runnable = new AddContributionsRunnable(buildResultHandle, buildResultContributions, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.AbstractTeamBuildClient_SAVE_BUILD_RESULT_OPERATION_NAME, progressMonitor);
                return TeamBuildClient.this.addToItemManager(runnable.fBuildResult);
            }
        });
    }

    @Override
    public IBuildResult addBuildResultContribution(IBuildResultHandle buildResultHandle, IBuildResultContribution buildResultContribution, String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return this.addBuildResultContributions(buildResultHandle, new IBuildResultContribution[]{buildResultContribution}, properties, progressMonitor);
    }

    @Override
    public void addBuildResultContributions(IBuildResultHandle buildResultHandle, IBuildResultContribution[] buildResultContributions, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.addBuildResultContributions(buildResultHandle, buildResultContributions, IBuildResult.PROPERTIES_REQUIRED, progressMonitor);
    }

    @Override
    public void addBuildResultContribution(IBuildResultHandle buildResultHandle, IBuildResultContribution buildResultContribution, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.addBuildResultContributions(buildResultHandle, new IBuildResultContribution[]{buildResultContribution}, IBuildResult.PROPERTIES_REQUIRED, progressMonitor);
    }

    @Override
    public String startBuildActivity(final IBuildResultHandle buildResultHandle, final String label, final String parentId, final boolean autoComplete, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotEmpty((String)"label", (String)label);
        return (String)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class StartBuildActivityRunnable
                extends ProcessRunnable {
                    public String fActivityId;
                    private final /* synthetic */ IBuildResultHandle val$buildResultHandle;
                    private final /* synthetic */ String val$label;
                    private final /* synthetic */ String val$parentId;
                    private final /* synthetic */ boolean val$autoComplete;

                    StartBuildActivityRunnable(IBuildResultHandle iBuildResultHandle, String string, String string2, boolean bl) {
                        this.val$buildResultHandle = iBuildResultHandle;
                        this.val$label = string;
                        this.val$parentId = string2;
                        this.val$autoComplete = bl;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IObjectsResponse response = TeamBuildClient.this.getService().startBuildActivity(this.val$buildResultHandle, this.val$label, this.val$parentId, this.val$autoComplete);
                        IBuildActivityId activityId = (IBuildActivityId)response.getClientObjects()[0];
                        this.fActivityId = activityId.getId();
                        return response.getOperationReport();
                    }
                }
                StartBuildActivityRunnable runnable = new StartBuildActivityRunnable(buildResultHandle, label, parentId, autoComplete);
                IProcessClientService processService = (IProcessClientService)TeamBuildClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.AbstractTeamBuildClient_START_BUILD_ACTIVITY_OPERATION_NAME, monitor);
                return runnable.fActivityId;
            }
        });
    }

    @Override
    public void completeBuildActivity(final IBuildResultHandle buildResultHandle, final String activityId, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotEmpty((String)"activityId", (String)activityId);
        this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class EndBuildActivityRunnable
                extends ProcessRunnable {
                    private final /* synthetic */ IBuildResultHandle val$buildResultHandle;
                    private final /* synthetic */ String val$activityId;

                    EndBuildActivityRunnable(IBuildResultHandle iBuildResultHandle, String string) {
                        this.val$buildResultHandle = iBuildResultHandle;
                        this.val$activityId = string;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return TeamBuildClient.this.getService().completeBuildActivity(this.val$buildResultHandle, this.val$activityId);
                    }
                }
                EndBuildActivityRunnable runnable = new EndBuildActivityRunnable(buildResultHandle, activityId);
                IProcessClientService processService = (IProcessClientService)TeamBuildClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.AbstractTeamBuildClient_END_BUILD_ACTIVITY_OPERATION_NAME, monitor);
                return null;
            }
        });
    }

    @Override
    public IBuildActivity[] getBuildActivities(final IBuildResultHandle buildResultHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IBuildActivity[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildActivity[] allActivities = TeamBuildClient.this.getService().getBuildActivities(buildResultHandle);
                Hashtable<String, IBuildActivity> activityMap = new Hashtable<String, IBuildActivity>();
                IBuildActivity[] iBuildActivityArray = allActivities;
                int n = allActivities.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildActivity activity = iBuildActivityArray[n2];
                    activityMap.put(activity.getUniqueId(), activity);
                    ++n2;
                }
                LinkedList<String> childActivityIds = new LinkedList<String>();
                IBuildActivity[] iBuildActivityArray2 = allActivities;
                int n3 = allActivities.length;
                n = 0;
                while (n < n3) {
                    IBuildActivity activity = iBuildActivityArray2[n];
                    for (IBuildActivityId childId : activity.getChildActivityIds()) {
                        childActivityIds.add(childId.getId());
                    }
                    ++n;
                }
                LinkedList<IBuildActivity> rootActivityList = new LinkedList<IBuildActivity>();
                IBuildActivity[] iBuildActivityArray3 = allActivities;
                int n4 = allActivities.length;
                n3 = 0;
                while (n3 < n4) {
                    IBuildActivity activity = iBuildActivityArray3[n3];
                    if (!childActivityIds.contains(activity.getUniqueId())) {
                        rootActivityList.add(activity);
                    }
                    ++n3;
                }
                for (IBuildActivity activity : rootActivityList) {
                    TeamBuildClient.this.populateChildActivities(activity, activityMap);
                }
                return rootActivityList.toArray(new IBuildActivity[rootActivityList.size()]);
            }
        });
    }

    private void populateChildActivities(IBuildActivity parentActivity, Map<String, IBuildActivity> allActivities) {
        for (IBuildActivityId childActivityId : parentActivity.getChildActivityIds()) {
            IBuildActivity childActivity = allActivities.get(childActivityId.getId());
            parentActivity.addChildActivity(childActivity);
            this.populateChildActivities(childActivity, allActivities);
        }
    }

    @Override
    public String[] getTags(final IProjectAreaHandle[] projectAreaHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (String[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildClient.this.getService().getTags(projectAreaHandles);
            }
        });
    }

    @Override
    public String[] getTags(final IBuildDefinitionHandle[] definitionHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (String[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildClient.this.getService().getTagsForBuildDefinitions(definitionHandles);
            }
        });
    }

    @Override
    public String getInProgressActivityLabel(IBuildResultHandle buildResultHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ITeamBuildRecordClient recordClient = (ITeamBuildRecordClient)this.getRepository().getClientLibrary(ITeamBuildRecordClient.class);
        return recordClient.getBuildResultRecord(buildResultHandle, IBuildResult.PROPERTIES_COMPLETE, progressMonitor).getCurrentActivityLabel();
    }

    @Override
    public int getPercentComplete(IBuildResultHandle buildResultHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ITeamBuildRecordClient recordClient = (ITeamBuildRecordClient)this.getRepository().getClientLibrary(ITeamBuildRecordClient.class);
        return recordClient.getBuildResultRecord(buildResultHandle, IBuildResult.PROPERTIES_COMPLETE, progressMonitor).getPercentComplete();
    }

    @Override
    public IBuildResult getLastBuildResult(IBuildDefinitionHandle buildDefinitionHandle, BuildState[] buildStates, String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildDefinitionHandle", (Object)buildDefinitionHandle);
        ValidationHelper.validateNotNull((String)"buildStates", (Object[])buildStates);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        IBaseBuildResultQueryModel.IBuildResultQueryModel buildResultQueryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        final IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        query.select((ISelectionElement)buildResultQueryModel.itemId());
        IPredicate left = buildResultQueryModel.buildDefinition()._eq((IItemHandle)buildDefinitionHandle);
        IPredicate right = buildResultQueryModel.buildState()._in(this.getStateNames(buildStates));
        query.filter(left._and(right));
        query.orderByDsc((IField)buildResultQueryModel.buildStartTime());
        query.setResultLimit(1);
        IDataQueryPage dataQueryPage = (IDataQueryPage)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildClient.this.queryData(query, IQueryService.EMPTY_PARAMETERS, 1, progressMonitor);
            }
        });
        IBuildResult buildResult = null;
        if (dataQueryPage.getResultSize() != 0) {
            UUID uuid = dataQueryPage.getRow(0).getUUID(0);
            IItemHandle buildResultHandle = IBuildResult.ITEM_TYPE.createItemHandle(uuid, null);
            buildResult = properties == IBuildResult.PROPERTIES_COMPLETE ? (IBuildResult)this.getRepository().itemManager().fetchCompleteItem(buildResultHandle, 0, progressMonitor) : (IBuildResult)this.getRepository().itemManager().fetchPartialItem(buildResultHandle, 0, this.toCollection(properties), progressMonitor);
        }
        return buildResult;
    }

    @Override
    public boolean anyResponsiveBuildEngines(final IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (Boolean)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return new Boolean(TeamBuildClient.this.getService().anyResponsiveBuildEngines(buildDefinitionHandle));
            }
        });
    }

    private String[] getStateNames(BuildState[] buildStates) {
        String[] buildStateNames = new String[buildStates.length];
        int i = 0;
        while (i < buildStates.length) {
            buildStateNames[i] = buildStates[i].name();
            ++i;
        }
        return buildStateNames;
    }

    @Override
    public boolean anyBuildEnginesWithRequestProcessingEnabled(final IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (Boolean)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return new Boolean(TeamBuildClient.this.getService().anyBuildEnginesWithRequestProcessingEnabled(buildDefinitionHandle));
            }
        });
    }
}

