/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

import com.ibm.team.build.client.ITeamBuildBaseClient;
import com.ibm.team.build.common.TeamBuildStateException;
import com.ibm.team.build.common.model.IBuildCategoryHandle;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildItem;
import com.ibm.team.build.common.model.IBuildItemHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompileContributionHandle;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompilePackageHandle;
import com.ibm.team.build.common.model.IJUnitTestClass;
import com.ibm.team.build.common.model.IJUnitTestClassHandle;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.common.model.IJUnitTestSuiteContributionHandle;
import com.ibm.team.build.internal.client.Messages;
import com.ibm.team.build.internal.common.ITeamBuildService;
import com.ibm.team.build.internal.common.helper.PropertyHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.IQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTeamBuildClient
extends EventSource
implements ITeamBuildBaseClient {
    private IClientLibraryContext fContext;
    private static final Collection fCollectionOfNull = Collections.singletonList(null);

    public AbstractTeamBuildClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    protected Collection toCollection(String[] properties) {
        if (properties == null) {
            properties = new String[]{};
        }
        return Arrays.asList(properties);
    }

    protected IItem addToItemManager(IItem item) throws TeamRepositoryException {
        IItem sharedItem = null;
        if (item != null) {
            try {
                this.acquire();
                IItemManager itemManager = this.getRepository().itemManager();
                sharedItem = (IItem)itemManager.applyItemUpdates(Collections.singletonList(item)).get(0);
                if (sharedItem == null) {
                    sharedItem = itemManager.fetchPartialItem((IItemHandle)item, 1, this.toCollection(PropertyHelper.getSetProperties((IItem)item)), null);
                }
            }
            finally {
                this.release();
            }
        }
        return sharedItem;
    }

    protected List addToItemManager(IItem[] items, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        try {
            this.acquire();
            IItemManager itemManager = this.getRepository().itemManager();
            List sharedItems = itemManager.applyItemUpdatesOrRefresh(Arrays.asList(items), progressMonitor);
            List list = this.removeNullElements(sharedItems);
            return list;
        }
        finally {
            this.release();
        }
    }

    protected List removeNullElements(List list) {
        ValidationHelper.validateNotNull((String)"list", (Object)list);
        if (!list.contains(null)) {
            return list;
        }
        ArrayList prunedList = new ArrayList(list);
        prunedList.removeAll(fCollectionOfNull);
        return prunedList;
    }

    protected void deleteFromItemManager(IItemHandle itemHandle) {
        try {
            this.acquire();
            this.getRepository().itemManager().applyItemDeletes(Collections.singletonList(itemHandle));
        }
        finally {
            this.release();
        }
    }

    protected void deleteFromItemManager(IItemHandle[] itemHandles) {
        try {
            this.acquire();
            this.getRepository().itemManager().applyItemDeletes(Arrays.asList(itemHandles));
        }
        finally {
            this.release();
        }
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public IBuildDefinition save(IBuildDefinition buildDefinition, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IBuildDefinition)this.internalSave((IBuildItem)buildDefinition, Messages.AbstractTeamBuildClient_SAVE_BUILD_DEFINITION_OPERATION_NAME, progressMonitor);
    }

    @Override
    public IJUnitTestSuiteContribution save(IJUnitTestSuiteContribution junitTestSuiteContribution, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IJUnitTestSuiteContribution)this.internalSave((IBuildItem)junitTestSuiteContribution, Messages.AbstractTeamBuildClient_SAVE_JUNIT_TEST_SUITE_OPERATION_NAME, progressMonitor);
    }

    @Override
    public IJUnitTestClass save(IJUnitTestClass testClass, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IJUnitTestClass)this.internalSave((IBuildItem)testClass, Messages.AbstractTeamBuildClient_SAVE_JUNIT_TEST_CLASS_OPERATION_NAME, progressMonitor);
    }

    @Override
    public ICompileContribution save(ICompileContribution compileContribution, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (ICompileContribution)this.internalSave((IBuildItem)compileContribution, Messages.AbstractTeamBuildClient_SAVE_COMPILE_CONTRIBUTION_OPERATION_NAME, progressMonitor);
    }

    @Override
    public ICompilePackage save(ICompilePackage compilePackage, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (ICompilePackage)this.internalSave((IBuildItem)compilePackage, Messages.AbstractTeamBuildClient_SAVE_COMPILE_PACKAGE_OPERATION_NAME, progressMonitor);
    }

    @Override
    public IBuildEngine save(IBuildEngine buildEngine, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IBuildEngine)this.internalSave((IBuildItem)buildEngine, Messages.AbstractTeamBuildClient_SAVE_BUILD_ENGINE_OPERATION_NAME, progressMonitor);
    }

    @Override
    public IBuildResult save(IBuildResult buildResult, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return (IBuildResult)this.internalSave((IBuildItem)buildResult, Messages.AbstractTeamBuildClient_SAVE_BUILD_RESULT_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.internalDelete((IBuildItemHandle)buildDefinitionHandle, Messages.AbstractTeamBuildClient_DELETE_BUILD_DEFINITION_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(IJUnitTestSuiteContributionHandle junitTestSuiteContributionHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.internalDelete((IBuildItemHandle)junitTestSuiteContributionHandle, Messages.AbstractTeamBuildClient_DELETE_JUNIT_TEST_SUITE_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(IJUnitTestClassHandle testClassHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.internalDelete((IBuildItemHandle)testClassHandle, Messages.AbstractTeamBuildClient_DELETE_JUNIT_TEST_CLASS_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(ICompileContributionHandle compileContributionHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.internalDelete((IBuildItemHandle)compileContributionHandle, Messages.AbstractTeamBuildClient_DELETE_COMPILE_CONTRIBUTION_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(ICompilePackageHandle compilePackageHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.internalDelete((IBuildItemHandle)compilePackageHandle, Messages.AbstractTeamBuildClient_DELETE_COMPILE_PACKAGE_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(IBuildEngineHandle buildEngineHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.internalDelete((IBuildItemHandle)buildEngineHandle, Messages.AbstractTeamBuildClient_DELETE_BUILD_ENGINE_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(IBuildResultHandle buildResultHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, TeamBuildStateException, IllegalArgumentException {
        this.internalDelete((IBuildItemHandle)buildResultHandle, Messages.AbstractTeamBuildClient_DELETE_BUILD_RESULT_OPERATION_NAME, progressMonitor);
    }

    @Override
    public void delete(IBuildCategoryHandle buildCategoryHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        this.internalDeleteWithoutProcess((IBuildItemHandle)buildCategoryHandle, progressMonitor);
    }

    private IBuildItem internalSave(final IBuildItem buildItem, final String operationId, final IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IBuildItem)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class SaveBuildItemRunnable
                extends ProcessRunnable {
                    public IItem fSavedItem;
                    private final /* synthetic */ IBuildItem val$buildItem;

                    SaveBuildItemRunnable(IBuildItem iBuildItem) {
                        this.val$buildItem = iBuildItem;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = AbstractTeamBuildClient.this.getService(ITeamBuildService.class).save(this.val$buildItem);
                        this.fSavedItem = response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                SaveBuildItemRunnable runnable = new SaveBuildItemRunnable(buildItem);
                IProcessClientService processService = (IProcessClientService)AbstractTeamBuildClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, operationId, progressMonitor);
                return AbstractTeamBuildClient.this.addToItemManager(runnable.fSavedItem);
            }
        });
    }

    @Override
    public IQueryPage fetchPage(final UUID token, final int startIndex, final int pageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IQueryPage)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return AbstractTeamBuildClient.this.getService(IQueryService.class).fetchPage(token, startIndex, pageSize);
            }
        });
    }

    @Override
    public IDataQueryPage queryData(final IDataQuery dataQuery, final Object[] parameters, final int pageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IDataQueryPage)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return AbstractTeamBuildClient.this.getService(IQueryService.class).queryData(dataQuery, parameters, pageSize);
            }
        });
    }

    @Override
    public IItemQueryPage queryItems(final IItemQuery itemQuery, final Object[] parameters, final int pageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IItemQueryPage)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return AbstractTeamBuildClient.this.getService(IQueryService.class).queryItems(itemQuery, parameters, pageSize);
            }
        });
    }

    @Override
    public IDataQueryPage uncommittedQueryData(final IDataQuery dataQuery, final Object[] parameters, final int pageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IDataQueryPage)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return AbstractTeamBuildClient.this.getService(IQueryService.class).uncommittedQueryData(dataQuery, parameters, pageSize);
            }
        });
    }

    @Override
    public IItemQueryPage uncommittedQueryItems(final IItemQuery itemQuery, final Object[] parameters, final int pageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IItemQueryPage)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return AbstractTeamBuildClient.this.getService(IQueryService.class).queryItems(itemQuery, parameters, pageSize);
            }
        });
    }

    private void internalDelete(final IBuildItemHandle buildItemHandle, final String operationId, IProgressMonitor progressMonitor) throws TeamRepositoryException, TeamBuildStateException {
        this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class DeleteBuildItemRunnable
                extends ProcessRunnable {
                    private final /* synthetic */ IBuildItemHandle val$buildItemHandle;

                    DeleteBuildItemRunnable(IBuildItemHandle iBuildItemHandle) {
                        this.val$buildItemHandle = iBuildItemHandle;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return AbstractTeamBuildClient.this.getService(ITeamBuildService.class).delete(this.val$buildItemHandle);
                    }
                }
                DeleteBuildItemRunnable runnable = new DeleteBuildItemRunnable(buildItemHandle);
                IProcessClientService processService = (IProcessClientService)AbstractTeamBuildClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, operationId, monitor);
                AbstractTeamBuildClient.this.deleteFromItemManager((IItemHandle)buildItemHandle);
                return null;
            }
        });
    }

    private void internalDeleteWithoutProcess(final IBuildItemHandle buildItemHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                AbstractTeamBuildClient.this.getService(ITeamBuildService.class).delete(buildItemHandle);
                AbstractTeamBuildClient.this.deleteFromItemManager((IItemHandle)buildItemHandle);
                return null;
            }
        });
    }
}

