/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.junit.internal;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningClient;
import com.ibm.team.apt.internal.common.resource.model.ContributorAbsence;
import com.ibm.team.apt.setup.client.builder.IterationPlanBuilder;
import com.ibm.team.apt.setup.junit.internal.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.setup.client.IProjectSetupContribution;
import com.ibm.team.foundation.setup.client.ProcessDescription;
import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.setup.junit.constants.JUnitIteration;
import com.ibm.team.process.setup.junit.constants.JUnitProjectArea;
import com.ibm.team.process.setup.junit.constants.JUnitTeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.setup.junit.constants.JUnitUser;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.setup.client.builder.WorkItemBuilder;
import com.ibm.team.workitem.setup.junit.constants.JUnitCategory;
import com.ibm.team.workitem.setup.junit.constants.JUnitWorkItems;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AgilePlanningContribution
implements IProjectSetupContribution {
    private static final String STORY_SPECIFICATION_XML = "resources/configuration/story_spec.xml";
    private IWorkItem fStoryWorkItem;

    public void contributeToProcessSpec(ISetupContext setup, ProcessDescription processSpec, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.done();
    }

    public void contributeArtifacts(ISetupContext setup, ProcessDescription processDescription, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AgilePlanningContribution_MONITOR_SETUP_PLANS_RESOURCE_PLANNING, (int)100);
        try {
            this.setContributorResourceData(setup, progress.newChild(20));
            this.contributeStories(setup, progress.newChild(40));
            this.createPlans(setup, progress.newChild(40));
        }
        finally {
            monitor.done();
        }
    }

    private void setContributorResourceData(ISetupContext setupContext, SubMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.AgilePlanningContribution_MONITOR_CREATE_ABSENCES, 2);
        try {
            IResourcePlanningClient resourcePlanningClient = PlanningClientPlugin.getResourcePlanningClient((ITeamRepository)setupContext.getTeamRepository());
            ContributorAbsence billAbsence = this.createAbsence("Conference in Europe", this.toTimestamp(this.add(this.getThisWeek(), 3, -1)), 14, (IContributor)setupContext.getArtifact((IPredefinedArtifact)JUnitUser.Bill));
            resourcePlanningClient.saveAbsences((IContributorAbsence[])new ContributorAbsence[]{billAbsence}, (IProgressMonitor)monitor.newChild(1));
            ContributorAbsence markusAbsence = this.createAbsence("Vacation", this.toTimestamp(this.add(this.getThisWeek(), 3, 1)), 3, (IContributor)setupContext.getArtifact((IPredefinedArtifact)JUnitUser.Markus));
            resourcePlanningClient.saveAbsences((IContributorAbsence[])new ContributorAbsence[]{markusAbsence}, (IProgressMonitor)monitor.newChild(1));
        }
        finally {
            monitor.done();
        }
    }

    private void contributeStories(ISetupContext setup, SubMonitor progress) throws TeamRepositoryException {
        progress.beginTask(Messages.AgilePlanningContribution_MONITOR_CREATE_STORIES, 6);
        try {
            this.newWI(55, setup).type("com.ibm.team.apt.workItemType.story").category((IPredefinedArtifact)JUnitCategory.JUnit).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM2).summary("Improve documentation for 4.4").owner((IPredefinedArtifact)JUnitUser.Bill).creator((IPredefinedArtifact)JUnitUser.Bill).creationDate(this.time(55921976L)).description("We should do an documentation effort for 4.4.").child((IPredefinedArtifact)JUnitWorkItems.CookbookTypo).child((IPredefinedArtifact)JUnitWorkItems.JavaDocIgnoreUpdate).child((IPredefinedArtifact)JUnitWorkItems.TestRunnerDoc).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi59 = (IWorkItem)this.newWI(59, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("Specify new assertThat syntax").duration(28800000L).owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Markus).resolved(true).creationDate(this.time(2296308L)).duration(50400000L).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi60 = (IWorkItem)this.newWI(60, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("Write test cases for assertThat").duration(86400000L).owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Markus).resolved(true).creationDate(this.time(2187149L)).duration(14400000L).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi57 = (IWorkItem)this.newWI(57, setup).category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("Implement new assertThat ").owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Bill).resolved(true).creationDate(this.time(3307906L)).description("Based on Joe Walnes new assertion mechanism we should provide a new assertThat syntax directly on JUnit.").child(wi59).child(wi60).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi58 = (IWorkItem)this.newWI(58, setup).category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM2).summary("Based on the assertThat syntax we should provide assumptions and theories support").owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Bill).creationDate(this.time(3172406L)).duration(57600000L).build((IProgressMonitor)progress.newChild(1));
            this.fStoryWorkItem = (IWorkItem)this.newWI(56, setup).type("com.ibm.team.apt.workItemType.story").category((IPredefinedArtifact)JUnitCategory.JUnit).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFour).summary("Provide improved Assertion syntax").owner((IPredefinedArtifact)JUnitUser.Bill).creator((IPredefinedArtifact)JUnitUser.Bill).creationDate(this.time(55411617L)).description("The assertion syntax should be enriched with assertThat, assumptions and theories.").child(wi57).child(wi58).build((IProgressMonitor)progress.newChild(1));
        }
        finally {
            progress.done();
        }
    }

    private void createPlans(ISetupContext setup, SubMonitor progress) throws TeamRepositoryException {
        progress.beginTask(Messages.AgilePlanningContribution_MONITOR_CREATE_PLANS, 3);
        try {
            IterationPlanBuilder.create((ISetupContext)setup).name("JUnit Plan").iteration((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).teamArea((IPredefinedArtifact)JUnitTeamArea.JUnit).overviewPage(XMLString.createFromXMLText((String)"== JUnit 4.4 M1 Plan\n\nNo additional information is captured for milestone 1.")).build((IProgressMonitor)progress.newChild(1));
            IterationPlanBuilder.create((ISetupContext)setup).name("JUnit Plan").iteration((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM2).teamArea((IPredefinedArtifact)JUnitTeamArea.JUnit).overviewPage(XMLString.createFromXMLText((String)"== JUnit 4.4 M2 Plan\n\nNo additional information is captured for milestone 2")).build((IProgressMonitor)progress.newChild(1));
            StringWriter c = new StringWriter(){

                public StringWriter append(CharSequence csq) {
                    return super.append(csq).append('\n');
                }
            };
            c.append("== JUnit 4.4 Plan");
            c.append("=== Staffing");
            c.append('\n');
            c.append("The following contributors will actively work on JUnit 4.4.");
            c.append("* Bill Cassavelli");
            c.append("* Markus Kent");
            c.append("* Jason Mitchell");
            c.append("== New Features");
            c.append('\n');
            c.append("We will investigate in a new assertion syntax to support assertThat, assumptions and theories (see ");
            c.append(String.format("[[ %s %d | %s (%d) ]]", this.fStoryWorkItem.getWorkItemType(), this.fStoryWorkItem.getId(), this.fStoryWorkItem.getHTMLSummary().getPlainText(), this.fStoryWorkItem.getId()));
            c.append("=== Architectural Topics");
            c.append('\n');
            c.append("No architectural changes are planned for 4.4");
            c.append("=== Documentation");
            c.append("We should do a documentation pass and check/update existing Javadoc and examples");
            XMLString overviewPageText = XMLString.createFromXMLText((String)c.toString());
            IterationPlanBuilder.create((ISetupContext)setup).name("JUnit Release Plan").iteration((IPredefinedArtifact)JUnitIteration.dev_FourOhFour).teamArea((IPredefinedArtifact)JUnitTeamArea.JUnit).overviewPage(overviewPageText).attachedPage("retrospective").name("Retrospective").done().build((IProgressMonitor)progress.newChild(1));
        }
        finally {
            progress.done();
        }
    }

    private ContributorAbsence createAbsence(String summary, Timestamp start, int days, IContributor owner) {
        ContributorAbsence result = (ContributorAbsence)IContributorAbsence.ITEM_TYPE.createItem();
        result.setSummary(summary);
        result.setStartDate(start);
        result.setEndDate(new Timestamp(start.getTime() + (long)days * 86400000L));
        result.setContributor((IContributorHandle)owner);
        return result;
    }

    private Calendar getNow() {
        return Calendar.getInstance();
    }

    private Calendar getToday() {
        Calendar calendar = this.getNow();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private Calendar getThisWeek() {
        Calendar calendar = this.getToday();
        calendar.set(7, 2);
        return calendar;
    }

    private Calendar add(Calendar calendar, int field, int delta) {
        calendar.add(field, delta);
        return calendar;
    }

    private Timestamp toTimestamp(Calendar calendar) {
        return new Timestamp(calendar.getTimeInMillis());
    }

    private WorkItemBuilder newWI(int workItemId, ISetupContext setupContext) {
        return WorkItemBuilder.create((ISetupContext)setupContext, (IProjectAreaHandle)((IProjectAreaHandle)setupContext.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit)));
    }

    private Timestamp time(long relative) {
        return new Timestamp(System.currentTimeMillis() - relative);
    }
}

