/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.ProjectAreaConnectionPage;
import com.ibm.team.process.ide.ui.WizardContext;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractIterationPlanWizard
extends Wizard {
    protected RepositorySelectionPage fRepositorySelectionPage;
    protected RepositoryCreationPage fRepositoryCreationPage;
    protected ProjectAreaConnectionPage fProjectAreaSelectionPage;
    private WizardContext fProjectAreaSelectionPageContext;
    protected IterationPlanWizardContext fWizardContext;
    private boolean fHasProjectArea = true;
    private boolean fHasMultipleProjectAreas = false;
    private boolean fHasTeamRepository = true;
    private boolean fHasMultipleTeamRepositories = false;

    public AbstractIterationPlanWizard(IterationPlanWizardContext context) {
        this.fWizardContext = context;
        this.fProjectAreaSelectionPageContext = new WizardContext();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        this.fHasTeamRepository = repositories.length > 0;
        this.fHasMultipleTeamRepositories = repositories.length > 1;
        this.fHasProjectArea = !this.fWizardContext.getProjectAreas().isEmpty();
        boolean bl = this.fHasMultipleProjectAreas = this.fWizardContext.getProjectAreas().size() > 1;
        if (this.fHasTeamRepository && !this.fHasMultipleTeamRepositories) {
            this.setTeamRepository(repositories[0]);
        }
        if (!this.fHasTeamRepository) {
            this.addRepositorySelectionPage();
            this.addRepositoryCreationPage();
            this.addProjectAreaConnectionPage();
        } else if (!this.fHasProjectArea) {
            if (this.fHasMultipleTeamRepositories) {
                this.addRepositorySelectionPage();
                this.addRepositoryCreationPage();
            }
            this.addProjectAreaConnectionPage();
        }
    }

    public boolean needsProgressMonitor() {
        return this.fRepositoryCreationPage != null;
    }

    public boolean performFinish() {
        return false;
    }

    protected void setImageForAllPages(ImageDescriptor image) {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            page.setImageDescriptor(image);
            ++n2;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fRepositorySelectionPage) {
            ITeamRepository repos = this.fRepositorySelectionPage.getTeamRepository();
            if (repos == null) {
                return this.fRepositoryCreationPage;
            }
            this.setTeamRepository(repos);
            return this.fProjectAreaSelectionPage;
        }
        if (page == this.fRepositoryCreationPage) {
            ITeamRepository repo = this.fRepositoryCreationPage.createRepository(true);
            if (repo != null && repo.loggedIn()) {
                this.setTeamRepository(repo);
                return this.fProjectAreaSelectionPage;
            }
            return null;
        }
        if (page == this.fProjectAreaSelectionPage) {
            List projectAreas = this.fProjectAreaSelectionPage.getSelectedProjectAreas();
            if (projectAreas == null || projectAreas.isEmpty()) {
                return null;
            }
            this.fWizardContext.setProjectAreas(projectAreas);
            this.fWizardContext.setSelectedProjectArea((IProjectAreaHandle)projectAreas.get(0));
        }
        return super.getNextPage(page);
    }

    private void setTeamRepository(ITeamRepository repos) {
        this.fWizardContext.setTeamRepository(repos);
        this.fProjectAreaSelectionPageContext.setTeamRepository(repos);
        this.fProjectAreaSelectionPageContext.fTeamRepository = repos;
    }

    protected boolean hasProjectArea() {
        return this.fHasProjectArea;
    }

    protected boolean hasMultipleProjectAreas() {
        return this.fHasMultipleProjectAreas;
    }

    protected boolean hasTeamRepository() {
        return this.fHasTeamRepository;
    }

    protected boolean hasMultipleTeamRepositories() {
        return this.fHasMultipleTeamRepositories;
    }

    protected void addProjectAreaConnectionPage() {
        this.fProjectAreaSelectionPage = new ProjectAreaConnectionPage(this.fProjectAreaSelectionPageContext);
        this.addPage((IWizardPage)this.fProjectAreaSelectionPage);
    }

    protected void addRepositoryCreationPage() {
        this.fRepositoryCreationPage = new RepositoryCreationPage(Messages.AbstractIterationPlanWizard_DSC_CREATE_REPOSITORY_CONNECTION);
        this.addPage((IWizardPage)this.fRepositoryCreationPage);
    }

    protected void addRepositorySelectionPage() {
        this.fRepositorySelectionPage = new RepositorySelectionPage(Messages.AbstractIterationPlanWizard_DSC_CREATE_SELECT_REPOSITORY_CONNECTION);
        this.addPage((IWizardPage)this.fRepositorySelectionPage);
    }
}

