/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarPainters;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ProgressBarPainter {
    private BarResources fResources;

    public ProgressBarPainter(BarResources resources) {
        this.fResources = resources;
    }

    public int computeMinimalHeight() {
        FontMetrics metrics = this.fResources.getMessageFontMetrics();
        return this.computeTrimHeight(metrics.getHeight() - metrics.getLeading());
    }

    public int computeTrimHeight(int height) {
        return height <= 12 ? height + 8 : (int)(1.8f * (float)height);
    }

    public int computeTopSpacing(int height) {
        return (height <= 20 ? 4 : height / 5) - 2;
    }

    public void paint(GC gc, Rectangle bounds, ProgressItem input) {
        GCState state = GCState.save(gc, 65930);
        try {
            gc.setFont(this.fResources.getMessageFont());
            int indent = bounds.height <= 20 ? 4 : bounds.height / 5;
            Rectangle innerBar = Rectangles.create(bounds);
            int delta = Math.max(0, indent - 2);
            Rectangles.move(innerBar, 0, delta);
            Rectangles.resize(innerBar, -indent - 2, -1 - 2 * delta);
            gc.setBackground(this.fResources.getWhite());
            gc.setForeground(this.fResources.getOutline());
            gc.fillRectangle(innerBar);
            gc.drawRectangle(innerBar);
            Rectangle textBox = Rectangles.create(innerBar);
            Rectangles.resize(textBox, -2, -2);
            Rectangles.move(textBox, 1, 1);
            Rectangles.resize(innerBar, -3, -3);
            Rectangles.move(innerBar, 2, 2);
            switch (input.getKind()) {
                case MESSAGE: 
                case LOADING: {
                    String msg = input.getMessage().getMessage();
                    if (msg != null) {
                        Point point = gc.stringExtent(msg);
                        Point align = BarPainters.align(textBox, point.x, point.y, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                        gc.setForeground(this.fResources.getOutline());
                        BarPainters.drawString(gc, textBox, msg, align);
                    }
                    break;
                }
                case BAR_WITH_PROJECTION: 
                case BAR: 
                case DONE: {
                    boolean showProjection = input.getKind() == ProgressItem.Kind.BAR_WITH_PROJECTION;
                    boolean done = input.getKind() == ProgressItem.Kind.DONE;
                    int fillLevel = done ? innerBar.height : (int)((float)innerBar.height * (input.getQualityOfPlanning() / 100.0f));
                    float ratio = showProjection ? input.getRealTimeRatio() : input.getWorkHoursRatio();
                    int now = done ? innerBar.width : (int)((float)innerBar.width * ratio);
                    int projection = showProjection ? (int)((float)innerBar.width * input.getProjection()) : 0;
                    gc.setForeground(this.fResources.getGradientStart());
                    gc.setBackground(this.fResources.getGradientEnd());
                    gc.fillGradientRectangle(innerBar.x, innerBar.y, now + Math.max(0, projection), innerBar.height, true);
                    Rectangle pastBar = Rectangles.create(innerBar);
                    pastBar.width = now - Math.max(0, -projection);
                    pastBar.height = fillLevel;
                    pastBar.y += innerBar.height - pastBar.height;
                    int alpha = gc.getAlpha();
                    gc.setAlpha(this.fResources.getAlpha(alpha));
                    gc.setBackground(this.fResources.getGreen());
                    gc.fillRectangle(pastBar);
                    gc.setAlpha(alpha);
                    if (showProjection) {
                        gc.setForeground(this.fResources.getWhite());
                        gc.drawLine(pastBar.x + pastBar.width - 1, innerBar.y, pastBar.x + pastBar.width - 1, innerBar.y + innerBar.height);
                        Rectangle behindBar = Rectangles.create(pastBar);
                        behindBar.width = Math.abs(projection);
                        behindBar.x = pastBar.x + pastBar.width;
                        gc.setAlpha(this.fResources.getAlpha(alpha));
                        gc.setBackground(input.isAhead() ? this.fResources.getBrightGreen() : this.fResources.getRed());
                        gc.fillRectangle(behindBar);
                        gc.setAlpha(alpha);
                    }
                    if (done) break;
                    gc.setBackground(this.fResources.getTwistie());
                    BarPainters.paintTwistie(gc, BarPainters.Direction.Left, innerBar.x + innerBar.width + 3, pastBar.y, indent);
                }
                default: {
                    break;
                }
            }
        }
        finally {
            state.restore();
        }
    }
}

