/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditorActivationListener;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineColumn;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineDropTargetEffect;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.RedrawContext;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.RootItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Transformation;
import com.ibm.team.jface.DoubleBufferPainter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Outline
extends Canvas {
    private Listener fDefaultSelectionListener = new Listener(){

        public void handleEvent(Event event) {
            Event e = new Event();
            e.time = event.time;
            e.stateMask = event.stateMask;
            switch (event.type) {
                case 1: {
                    if (event.character != '\r') break;
                    Outline.this.notifyListeners(14, e);
                    break;
                }
                case 8: {
                    Outline.this.notifyListeners(14, e);
                }
            }
        }
    };
    private OutlineResources fResources;
    private OutlineItem fRoot;
    private int fMinimalWidth = -1;
    private int fRelayoutCount;
    private int fCheckVerticalScrollBarOnPaint = -1;
    private int fCheckHorizontalScrollBarOnPaint = -1;
    private Transformation fTransformation = new Transformation(0, 0);
    private IEventHandler fCurrentHandler;
    private boolean fMouseDown;
    protected Point fLastMouseUpPosition;
    protected LinkedList<OutlineItem> fSelectedItems = new LinkedList();
    protected OutlineItem fLastSelectedItem;
    protected OutlineItem fRangeSelectionStart;
    protected OutlineItem fInsertMarkItem = null;
    protected boolean fInsertMarkBefore = true;
    private AbstractTextEditor fCurrentTextEditor;
    private ListenerList fGadgetEditorActivationListeners;
    private boolean fSelectionUpdatedOnMouseDown;
    static final boolean DEBUG = true;
    private static final int MINIMUM_WIDTH = 150;
    LinkedList<OutlineColumn> fColumns = new LinkedList();

    public Outline(Composite parent, int style) {
        super(parent, style | 0x40000);
        ScrollBar horizontalScrollBar;
        this.setForeground(this.getDisplay().getSystemColor(24));
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.fRoot = this.createRootItem();
        final ScrollBar verticalScrollBar = this.getVerticalBar();
        if (verticalScrollBar != null) {
            verticalScrollBar.setVisible(true);
            verticalScrollBar.setEnabled(false);
            verticalScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Outline.this.scroll(0, verticalScrollBar.getSelection() - Outline.this.fTransformation.getY());
                }
            });
        }
        if ((horizontalScrollBar = this.getHorizontalBar()) != null) {
            horizontalScrollBar.setVisible(true);
            horizontalScrollBar.setEnabled(false);
            horizontalScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Outline.this.scroll(horizontalScrollBar.getSelection() - Outline.this.fTransformation.getX(), 0);
                }
            });
        }
        this.fGadgetEditorActivationListeners = new ListenerList(1);
        Font font = JFaceResources.getFont((String)"com.ibm.team.apt.ide.ui.iterationPlanEditor.font");
        this.setFont(font);
        this.fResources = this.createOutlineResource();
        this.addListener(1, this.fDefaultSelectionListener);
        this.addListener(8, this.fDefaultSelectionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Outline.this.handleDisposed(e);
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Outline.this.doControlResized(e);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                Outline.this.doKeyPressed(e);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Outline.this.doMouseUp(e);
            }

            public void mouseDown(MouseEvent e) {
                Outline.this.doMouseDown(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                Outline.this.doMouseDoubleClick(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Outline.this.doMouseMove(e);
            }
        });
        new DoubleBufferPainter(this){

            public void doPaint(PaintEvent event) {
                Outline.this.doPaint(event);
            }
        };
        this.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                IEventHandler handler;
                OutlineItem collapsed = (OutlineItem)e.item;
                if (Outline.this.fCurrentHandler != null && !Outline.this.fCurrentHandler.isDisposed()) {
                    handler = Outline.this.fCurrentHandler.getParentHandler();
                    while (handler != null) {
                        if (handler == collapsed) {
                            Outline.this.fCurrentHandler.stop();
                            Outline.this.fCurrentHandler = null;
                            break;
                        }
                        handler = handler.getParentHandler();
                    }
                }
                if (Outline.this.fCurrentTextEditor != null) {
                    handler = Outline.this.fCurrentTextEditor.getGadget().getParentHandler();
                    while (handler != null) {
                        if (handler == collapsed) {
                            Outline.this.fCurrentTextEditor.stopEditSession();
                            Outline.this.fCurrentTextEditor = null;
                            break;
                        }
                        handler = handler.getParentHandler();
                    }
                }
                if (!Outline.this.fSelectedItems.isEmpty()) {
                    OutlineItem[] items;
                    OutlineItem deepest = Outline.this.getDeepestChild(collapsed);
                    OutlineItem[] outlineItemArray = items = Outline.this.getVisibleItemRange(collapsed, deepest);
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OutlineItem item = outlineItemArray[n2];
                        if (item != collapsed && Outline.this.fSelectedItems.contains(item)) {
                            Outline.this.removeSelection(item);
                        }
                        ++n2;
                    }
                }
            }
        });
        this.setData("DEFAULT_DROP_TARGET_EFFECT", (Object)new OutlineDropTargetEffect(this));
    }

    protected OutlineItem createRootItem() {
        return new RootItem(this, 0);
    }

    public void setInsertMark(OutlineItem insertMarkItem, boolean before) {
        this.checkWidget();
        if (insertMarkItem == null && this.fInsertMarkItem == null) {
            return;
        }
        int i = 0;
        while (i < 2) {
            Rectangle bounds;
            if (this.fInsertMarkItem != null && !this.fInsertMarkItem.isDisposed() && (bounds = this.fInsertMarkItem.getBounds()) != null) {
                OutlineItem otherItem;
                OutlineItem outlineItem = otherItem = this.fInsertMarkBefore ? this.getPreviousVisibleItem(this.fInsertMarkItem) : this.getNextVisibleItem(this.fInsertMarkItem);
                if (otherItem != null) {
                    Rectangle boundsOther = otherItem.getBounds();
                    Rectangle union = this.fTransformation.toViewPort(boundsOther.union(bounds));
                    this.redraw(union.x, union.y, union.width, union.height, false);
                } else {
                    bounds = this.fTransformation.toViewPort(bounds);
                    this.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
            }
            this.fInsertMarkItem = insertMarkItem;
            this.fInsertMarkBefore = before;
            ++i;
        }
    }

    public boolean setFocus() {
        if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && this.fCurrentTextEditor.getControl().isVisible()) {
            return super.setFocus();
        }
        return this.forceFocus();
    }

    protected OutlineResources createOutlineResource() {
        return new OutlineResources((Control)this);
    }

    public Transformation getTransformation() {
        return this.fTransformation;
    }

    public OutlineResources getOutlineResources() {
        return this.fResources;
    }

    public IEventHandler getActiveEventHandler() {
        return this.fCurrentHandler;
    }

    public OutlineColumn getColumn(int n) {
        if (n < 0 || n >= this.fColumns.size()) {
            throw new IllegalArgumentException();
        }
        return this.fColumns.get(n);
    }

    public int getColumnCount() {
        return this.fColumns.size();
    }

    public List<OutlineColumn> getColumns() {
        return Collections.unmodifiableList(this.fColumns);
    }

    public void clearSelection() {
        for (OutlineItem item : this.fSelectedItems) {
            if (item.isDisposed()) continue;
            item.setSelectionMode(0);
        }
        this.fSelectedItems.clear();
        this.fLastSelectedItem = null;
    }

    public void removeSelection(OutlineItem item) {
        if (!item.isDisposed()) {
            item.setSelectionMode(0);
        }
        this.fSelectedItems.remove(item);
    }

    public void setSelection(OutlineItem ... newSelection) {
        this.clearSelection();
        this.fRangeSelectionStart = null;
        OutlineItem[] outlineItemArray = newSelection;
        int n = newSelection.length;
        int n2 = 0;
        while (n2 < n) {
            OutlineItem item = outlineItemArray[n2];
            this.updateSelection(item, null, false);
            ++n2;
        }
    }

    public void setSelection(OutlineItem newSelection, boolean notify) {
        this.clearSelection();
        this.fRangeSelectionStart = null;
        this.updateSelection(newSelection, null, notify);
    }

    void setSelectionByUserInteraction(OutlineItem newSelection, SelectionMode mode, Point point) {
        if (mode != SelectionMode.RANGE) {
            this.fRangeSelectionStart = newSelection;
        } else if (this.fRangeSelectionStart == null) {
            this.fRangeSelectionStart = newSelection;
        }
        OutlineItem parent = this.fRangeSelectionStart.getParentIncludingRoot();
        if (parent != null && !parent.getExpanded()) {
            this.fRangeSelectionStart = newSelection;
        }
        if (mode == SelectionMode.SINGLE) {
            if (newSelection.getSelectionMode() == 1 && this.fSelectedItems.size() == 1 && this.fSelectedItems.contains(newSelection)) {
                this.updateSelection(null, point, true);
                return;
            }
            this.clearSelection();
            this.updateSelection(newSelection, point, true);
        }
        if (mode == SelectionMode.MULTI) {
            if (this.fSelectedItems.contains(newSelection)) {
                this.removeSelection(newSelection);
            } else {
                this.updateSelection(newSelection, point, true);
            }
        }
        if (mode == SelectionMode.RANGE) {
            OutlineItem[] items = this.getVisibleItemRange(this.fRangeSelectionStart, newSelection);
            this.clearSelection();
            OutlineItem[] outlineItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                OutlineItem item = outlineItemArray[n2];
                this.updateSelection(item, point, true);
                ++n2;
            }
        }
    }

    protected void updateSelection(final OutlineItem selection, Point point, boolean notify) {
        if (selection == this.fRoot) {
            return;
        }
        if (selection != null) {
            if (selection.getSelectionMode() == 1 && this.fSelectedItems.contains(selection)) {
                return;
            }
            if (selection != null) {
                OutlineItem parent = selection.getParent();
                while (parent != null) {
                    parent.setExpanded(true);
                    parent = parent.getParent();
                }
            }
            RedrawContext redraw = new RedrawContext();
            if (selection != this.fRoot && selection != null && !selection.isDisposed()) {
                selection.setSelectionMode(1);
                this.fSelectedItems.addLast(selection);
                this.fLastSelectedItem = selection;
                selection.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        Outline.this.fSelectedItems.remove(selection);
                        if (Outline.this.fLastSelectedItem == selection) {
                            Outline.this.fLastSelectedItem = null;
                        }
                        if (Outline.this.fRangeSelectionStart == selection) {
                            Outline.this.fRangeSelectionStart = null;
                        }
                    }
                });
            }
            this.redraw(redraw);
        }
        if (notify) {
            Event newEvent = new Event();
            newEvent.item = selection;
            if (point != null) {
                newEvent.x = point.x;
                newEvent.y = point.y;
            }
            this.notifyListeners(13, newEvent);
        }
    }

    public OutlineItem[] getSelection() {
        return this.fSelectedItems.toArray(new OutlineItem[this.fSelectedItems.size()]);
    }

    public OutlineItem getLastSelectedItem() {
        return this.fLastSelectedItem;
    }

    public OutlineItem getItem(int index) {
        return this.fRoot.getItem(index);
    }

    public OutlineItem[] getItems() {
        return this.fRoot.getItems();
    }

    public int getItemCount() {
        return this.fRoot.getItemCount();
    }

    public OutlineItem getTopItem() {
        OutlineItem result = this.fRoot.findItemUnderY(this.fTransformation.getY());
        if (result == this.fRoot) {
            return null;
        }
        return result;
    }

    public void setTopItem(OutlineItem item) {
        if (!item.isLayouted() || item.isDisposed()) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        Rectangle itemBounds = this.fTransformation.toViewPort(this.getContentBounds(item));
        int topInset = Math.max(0, this.getRootItem().getInsets().top() - 1);
        int delta = 0;
        if (itemBounds.y < clientArea.y) {
            delta = clientArea.y - itemBounds.y + topInset;
        } else {
            delta = itemBounds.y - clientArea.y - topInset;
            int newY = itemBounds.y - delta;
            if (newY < clientArea.y) {
                delta = Math.max(0, delta - clientArea.y - newY);
            }
            delta = -delta;
        }
        if (delta == 0) {
            return;
        }
        this.scroll(0, -delta);
    }

    public void showItem(OutlineItem item) {
        if (!item.isLayouted() || item.isDisposed()) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        Rectangle itemBounds = this.fTransformation.toViewPort(this.getContentBounds(item));
        Rectangle visible = clientArea.intersection(itemBounds);
        if (visible.y == itemBounds.y && visible.height == itemBounds.height || itemBounds.y <= clientArea.y && itemBounds.y + itemBounds.height >= clientArea.y + clientArea.height) {
            return;
        }
        int delta = 0;
        if (itemBounds.height >= clientArea.height) {
            if (itemBounds.y > clientArea.y) {
                this.scroll(0, itemBounds.y - clientArea.y);
            } else {
                this.scroll(0, itemBounds.y + itemBounds.height - (clientArea.y + clientArea.height));
            }
        } else if (itemBounds.y < clientArea.y) {
            this.scroll(0, -(clientArea.y - itemBounds.y));
        } else {
            delta = Math.max(0, itemBounds.y + itemBounds.height - (clientArea.y + clientArea.height));
            int newY = itemBounds.y - delta;
            if (newY < clientArea.y) {
                delta = Math.max(0, delta - clientArea.y - newY);
            }
            this.scroll(0, delta);
        }
    }

    public Widget getItem(int x, int y) {
        Point pane = this.fTransformation.toPane(this.toControl(x, y));
        OutlineItem result = this.getRootItem().findItemUnder(pane);
        return result;
    }

    public IGObject getGObjectUnder(int x, int y) {
        Point pane = this.fTransformation.toPane(x, y);
        OutlineItem item = this.getRootItem().findItemUnder(pane);
        if (item == null) {
            return null;
        }
        return item.findGObjectUnder(pane);
    }

    private Rectangle getContentBounds(OutlineItem item) {
        return item.getContent() != null ? item.getContent().getSelectionBounds() : item.getBounds();
    }

    protected OutlineItem getRootItem() {
        return this.fRoot;
    }

    protected void setSortedChildren(OutlineItem[] sortedChildren) {
        this.fRoot.setSortedChildren(sortedChildren);
    }

    protected void handleDisposed(DisposeEvent e) {
        this.fRoot.dispose();
    }

    public AbstractTextEditor getCurrentTextEditor() {
        return this.fCurrentTextEditor;
    }

    public void removeAll() {
        try {
            this.setRedraw(false);
            this.setRelayout(false);
            this.fRoot.removeAll();
        }
        finally {
            this.setRelayout(true);
            this.setRedraw(true);
        }
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(17, (Listener)typedListener);
        this.addListener(18, (Listener)typedListener);
    }

    public void scroll(int deltaX, int deltaY) {
        StyledText control;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        this.scroll(-deltaX, -deltaY, 0, 0, clientArea.width, clientArea.height, false);
        if (deltaX != 0) {
            this.fTransformation.moveX(deltaX);
            this.fCheckHorizontalScrollBarOnPaint = this.fTransformation.getX();
        }
        if (deltaY != 0) {
            this.fTransformation.moveY(deltaY);
            this.fCheckVerticalScrollBarOnPaint = this.fTransformation.getY();
        }
        if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && !(control = this.fCurrentTextEditor.getControl()).isDisposed()) {
            GText owner = this.fCurrentTextEditor.getOwner();
            Rectangle viewPort = this.fTransformation.toViewPort(owner.getBounds());
            if (viewPort.intersects(this.getClientArea())) {
                control.setLocation(viewPort.x, viewPort.y);
                if (!control.getVisible()) {
                    control.setVisible(true);
                    control.setFocus();
                }
            } else if (control.isVisible()) {
                control.setVisible(false);
            }
        }
    }

    public void setRelayout(boolean relayout) {
        if (relayout) {
            --this.fRelayoutCount;
            if (this.fRelayoutCount == 0) {
                this.relayout();
            }
        } else {
            ++this.fRelayoutCount;
        }
    }

    public boolean isLayoutDeferred() {
        return this.fRelayoutCount > 0;
    }

    protected int getMinimumWidth() {
        return 150;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(wHint == -1 ? 1 : wHint, hHint == -1 ? 1 : hHint);
    }

    protected int getMaximalHeight() {
        return this.getRootItem().getHeight();
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        Rectangle area = this.getClientArea();
        if (this.fMinimalWidth == -1 || changed) {
            this.fMinimalWidth = Math.max(this.fRoot.computeMinimumWidth(), this.getMinimumWidth());
        }
        if (!this.fRoot.isLayouted() || changed) {
            this.fRoot.layout(0, 0, Math.max(area.width, this.fMinimalWidth), -1);
        } else if (this.fRoot.getWidth() < area.width || this.fMinimalWidth < area.width && area.width < this.fRoot.getWidth()) {
            this.fRoot.layout(0, 0, area.width, -1);
        }
        this.fTransformation.set(0, 0);
        if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && !this.fCurrentTextEditor.getOwner().isDisposed()) {
            this.fCurrentTextEditor.adjustBounds(this.fTransformation);
        }
        this.setCheckVerticalScrollBarOnPaint(this.fTransformation.getY());
        this.setCheckHorizontalScrollBarOnPaint(this.fTransformation.getX());
    }

    protected void resized(OutlineItem resizedChild, int deltaX, int deltaY, OutlineItem origin, RedrawContext redraw) {
        Rectangle originBounds = origin.getBounds();
        Rectangle clientArea = this.getClientArea();
        boolean transformationChanged = false;
        if (deltaY != 0) {
            int scrollDeltaY;
            int startY = originBounds.y;
            int endY = startY + originBounds.height;
            int ty = this.fTransformation.getY();
            if (endY < ty) {
                this.fTransformation.moveY(deltaY);
                transformationChanged = true;
            }
            if ((scrollDeltaY = this.getMaximalHeight() - (this.fTransformation.getY() + clientArea.height)) < 0) {
                this.fTransformation.moveY(scrollDeltaY);
                transformationChanged = true;
            }
            this.fCheckVerticalScrollBarOnPaint = this.fTransformation.getY();
        }
        if (deltaX != 0) {
            int scrollDeltaX;
            int startX = originBounds.x;
            int endX = startX + originBounds.width;
            int tx = this.fTransformation.getX();
            if (endX < tx) {
                this.fTransformation.moveX(deltaX);
                transformationChanged = true;
            }
            if ((scrollDeltaX = this.fRoot.getBounds().width - (this.fTransformation.getX() + clientArea.width)) < 0) {
                this.fTransformation.moveX(scrollDeltaX);
                transformationChanged = true;
            }
        }
        if (transformationChanged) {
            if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && !this.fCurrentTextEditor.getOwner().isDisposed()) {
                this.fCurrentTextEditor.adjustBounds(this.fTransformation);
            }
            this.redraw();
        } else {
            this.redraw(redraw);
        }
    }

    protected void relayout() {
        if (this.fRelayoutCount > 0) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        OutlineItem topItem = this.getTopItem();
        int newX = 0;
        int newY = 0;
        if (topItem != null) {
            int oldY = this.fTransformation.getY();
            this.layout(true, false);
            Rectangle newBounds = topItem.getBounds();
            newX = newBounds.x;
            newY = oldY;
            int restWidth = this.fRoot.getBounds().width - newX;
            int restHeight = this.getMaximalHeight() - newY;
            newX = Math.max(0, newX - Math.max(0, clientArea.width - restWidth));
            newY = Math.max(0, newY - Math.max(0, clientArea.height - restHeight));
        } else {
            this.layout(true, false);
        }
        this.getTransformation().set(newX, newY);
        this.setCheckHorizontalScrollBarOnPaint(newX);
        this.setCheckVerticalScrollBarOnPaint(newY);
        this.redraw();
        if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && !this.fCurrentTextEditor.getOwner().isDisposed()) {
            this.fCurrentTextEditor.adjustBounds(this.getTransformation());
            this.fCurrentTextEditor.getControl().setFocus();
        }
    }

    protected void checkVerticalScrollBar(int selection, int height) {
        ScrollBar verticalScrollBar = this.getVerticalBar();
        if (verticalScrollBar != null) {
            int currentY = this.getTransformation().getY();
            if (this.getMaximalHeight() > height) {
                int fontHeight = this.fResources.getFontMetrics().getHeight();
                verticalScrollBar.setValues(selection, 0, this.getMaximalHeight(), height, fontHeight, this.getClientArea().height);
                verticalScrollBar.setEnabled(true);
            } else if (currentY > 0) {
                int fontHeight = this.fResources.getFontMetrics().getHeight();
                int maxHeight = this.getMaximalHeight();
                verticalScrollBar.setValues(currentY, 0, maxHeight + currentY, maxHeight, fontHeight, this.getClientArea().height);
                verticalScrollBar.setEnabled(true);
            } else {
                verticalScrollBar.setValues(0, 0, 0, 1, 1, 1);
                verticalScrollBar.setEnabled(false);
            }
        }
    }

    protected void checkHorizontalScrollBar(int selection, int width) {
        ScrollBar horizontalScrollBar = this.getHorizontalBar();
        if (horizontalScrollBar != null) {
            if (this.fRoot.getWidth() > width) {
                int averageCharWidth = this.fResources.getFontMetrics().getAverageCharWidth();
                horizontalScrollBar.setValues(selection, 0, this.fRoot.getWidth(), width, averageCharWidth, averageCharWidth);
                horizontalScrollBar.setEnabled(true);
            } else {
                horizontalScrollBar.setValues(0, 0, 0, 1, 1, 1);
                horizontalScrollBar.setEnabled(false);
            }
        }
    }

    protected void setCheckHorizontalScrollBarOnPaint(int selection) {
        this.fCheckHorizontalScrollBarOnPaint = selection;
    }

    protected void setCheckVerticalScrollBarOnPaint(int selection) {
        this.fCheckVerticalScrollBarOnPaint = selection;
    }

    public void redraw(RedrawContext redraw) {
        redraw.invalidate(this.fTransformation, this, false);
    }

    public void redraw(IGObject object, boolean all) {
        Rectangle bounds = this.fTransformation.toViewPort(object.getBounds());
        this.redraw(bounds.x, bounds.y, bounds.width, bounds.height, all);
    }

    void doControlResized(ControlEvent e) {
        this.setRedraw(false);
        try {
            OutlineItem topItem = this.getTopItem();
            this.layout(true, true);
            if (topItem != null) {
                this.setTopItem(topItem);
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    void doPaint(PaintEvent e) {
        this.checkWidget();
        this.fResources.setPaintPaneBounds(this.getTransformation().toPane(e.x, e.y, e.width, e.height));
        GC gc = e.gc;
        Color oldBackgroundColor = gc.getBackground();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(e.x, e.y, e.width, e.height);
        gc.setBackground(oldBackgroundColor);
        gc.setAdvanced(true);
        this.fRoot.paint(e, this.fResources);
        if (this.fCheckVerticalScrollBarOnPaint != -1) {
            this.checkVerticalScrollBar(this.fCheckVerticalScrollBarOnPaint, this.getClientArea().height);
            this.fCheckVerticalScrollBarOnPaint = -1;
        }
        if (this.fCheckHorizontalScrollBarOnPaint != -1) {
            this.checkHorizontalScrollBar(this.fCheckHorizontalScrollBarOnPaint, this.getClientArea().width);
            this.fCheckHorizontalScrollBarOnPaint = -1;
        }
        if (this.fInsertMarkItem != null && !this.fInsertMarkItem.isDisposed()) {
            this.doPaintInsertMark(e);
        }
    }

    void doPaintInsertMark(PaintEvent event) {
        GC gc = event.gc;
        Color foreground = gc.getForeground();
        int antialias = gc.getAntialias();
        int lineWidth = gc.getLineWidth();
        try {
            int down;
            int up;
            int y;
            int insertionLW = this.getOutlineResources().getInsertionMarkLineWidth();
            int endingLW = this.getOutlineResources().getInsertionMarkEndingLength() / 2;
            gc.setForeground(this.fResources.getInsertionMarkColor());
            gc.setAntialias(1);
            Rectangle thisBounds = this.fTransformation.toViewPort(this.fInsertMarkItem.getBounds());
            int x = thisBounds.x;
            int width = thisBounds.width;
            if (this.fInsertMarkBefore) {
                OutlineItem previousItem = this.getPreviousVisibleItem(this.fInsertMarkItem);
                Rectangle previousBounds = previousItem != null ? this.fTransformation.toViewPort(previousItem.getBounds()) : null;
                y = thisBounds.y + (previousItem != null ? 0 : insertionLW / 2);
                up = Math.min(endingLW, previousBounds != null ? thisBounds.y - previousBounds.y : 0);
                down = Math.min(endingLW, thisBounds.height);
            } else {
                OutlineItem nextItem = this.getNextVisibleItem(this.fInsertMarkItem);
                Rectangle nextBounds = nextItem != null ? this.fTransformation.toViewPort(nextItem.getBounds()) : null;
                y = thisBounds.y + thisBounds.height + (nextItem != null ? 0 : -insertionLW / 2);
                up = Math.min(endingLW, thisBounds.height);
                down = Math.min(endingLW, nextBounds != null ? nextBounds.height : 0);
            }
            gc.setLineWidth(insertionLW);
            gc.drawLine(x, y, x + width, y);
            gc.setLineWidth(Math.min(1, insertionLW / 2));
            int subPixelCorrection = (insertionLW + 1) % 2;
            gc.drawLine(x, y - up, x, y + down - subPixelCorrection);
            gc.drawLine(x + width - 1, y - up, x + width - 1, y + down - subPixelCorrection);
            gc.drawLine(x + 1, y - up / 2 - (up == 0 ? 0 : 1), x + 1, y + down / 2);
            gc.drawLine(x + width - 2, y - up / 2 - (up == 0 ? 0 : 1), x + width - 2, y + down / 2);
        }
        finally {
            gc.setLineWidth(lineWidth);
            gc.setForeground(foreground);
            gc.setAntialias(antialias);
        }
    }

    void doMouseDown(MouseEvent e) {
        this.setFocus();
        this.fMouseDown = true;
        if (this.fCurrentTextEditor != null) {
            if (this.fCurrentTextEditor.isActive()) {
                this.stopEditSession();
            }
            this.fCurrentTextEditor = null;
        }
        Point pane = this.fTransformation.toPane(e.x, e.y);
        IEventHandler handler = this.fRoot.findEventHandlerUnder(pane, 2);
        boolean bl = this.fSelectionUpdatedOnMouseDown = this.fSelectedItems.size() <= 1 || handler != null && handler.getOutlineItem() != null && !this.fSelectedItems.contains(handler.getOutlineItem());
        if (this.fSelectionUpdatedOnMouseDown) {
            this.updateSelection(e, handler);
        }
        if (handler != null && !(handler instanceof GText)) {
            handler.handleMouseDown(e);
        }
        if (handler instanceof GText && this.fSelectedItems.size() == 1 && this.fSelectedItems.get(0) == handler.getOutlineItem()) {
            IGadgetEditor editor = handler.handleMouseDown(e);
            if (this.fCurrentTextEditor != null && this.fCurrentTextEditor == editor) {
                this.fCurrentTextEditor.forwardMouseDown(e);
            }
        }
    }

    void doMouseUp(MouseEvent e) {
        if (e.count >= 2) {
            return;
        }
        Point pane = this.fTransformation.toPane(e.x, e.y);
        IEventHandler handler = this.fRoot.findEventHandlerUnder(pane, 2);
        if (!this.fSelectionUpdatedOnMouseDown && this.fSelectedItems.size() > 1) {
            this.updateSelection(e, handler);
        }
        if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && this.fMouseDown) {
            this.fCurrentTextEditor.forwardMouseUp(e);
        } else if (handler != null) {
            handler.handleMouseUp(e);
        }
        this.fLastMouseUpPosition = new Point(e.x, e.y);
        this.fMouseDown = false;
    }

    private void updateSelection(MouseEvent e, IEventHandler handler) {
        if (handler == null) {
            this.clearSelection();
            this.updateSelection(null, null, true);
        } else if (!handler.isDisposed() && handler.requestsSelection()) {
            boolean ignore;
            OutlineItem outlineItem = handler.getOutlineItem();
            boolean bl = ignore = (e.stateMask & 0x10000) == 0 && e.button != 1 && !this.fSelectedItems.isEmpty() && this.fSelectedItems.contains(outlineItem);
            if (!ignore) {
                if ((e.stateMask & 0x40000) == 0 && (e.stateMask & 0x20000) == 0) {
                    this.setSelectionByUserInteraction(outlineItem, SelectionMode.SINGLE, new Point(e.x, e.y));
                } else if ((e.stateMask & 0x40000) != 0) {
                    this.setSelectionByUserInteraction(outlineItem, SelectionMode.MULTI, new Point(e.x, e.y));
                } else if ((e.stateMask & 0x20000) != 0) {
                    this.setSelectionByUserInteraction(outlineItem, SelectionMode.RANGE, new Point(e.x, e.y));
                }
            }
        }
    }

    void doMouseDoubleClick(MouseEvent e) {
        if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && this.fMouseDown) {
            this.fCurrentTextEditor.forwardMouseDoubleClick(e);
        } else {
            Point pane = this.fTransformation.toPane(e.x, e.y);
            IEventHandler handler = this.fRoot.findEventHandlerUnder(pane, 2);
            if (handler != null) {
                handler.handleMouseDoubleClick(e);
            }
        }
    }

    void doMouseMove(MouseEvent e) {
        Point pane;
        IEventHandler handler;
        if (this.fCurrentTextEditor != null && this.fCurrentTextEditor.isActive() && this.fMouseDown) {
            this.fCurrentTextEditor.forwardMouseMove(e);
        }
        if ((handler = this.fRoot.findEventHandlerUnder(pane = this.fTransformation.toPane(e.x, e.y), 2)) != this.fCurrentHandler) {
            if (this.fCurrentHandler != null && !this.fCurrentHandler.isDisposed()) {
                this.fCurrentHandler.handleMouseExit(e);
            }
            this.fCurrentHandler = handler;
            if (this.fCurrentHandler != null) {
                this.fCurrentHandler.handleMouseEnter(e);
            }
        }
    }

    protected void doKeyPressed(KeyEvent e) {
        if (e.keyCode == 131072) {
            return;
        }
        SelectionMode mode = (e.stateMask & 0x20000) != 0 ? SelectionMode.RANGE : SelectionMode.SINGLE;
        OutlineItem oldSelection = this.fLastSelectedItem;
        if (e.keyCode == 0x1000002) {
            this.doArrowDown(mode);
        } else if (e.keyCode == 0x1000001) {
            this.doArrowUp(mode);
        } else if (e.keyCode == 0x1000004) {
            if (this.fLastSelectedItem != null && !this.fLastSelectedItem.getExpanded() && this.fLastSelectedItem.getItemCount() > 0) {
                this.doArrowRight();
            } else {
                this.doArrowDown(mode);
            }
        } else if (e.keyCode == 0x1000003) {
            if (this.fLastSelectedItem != null && this.fLastSelectedItem.getExpanded()) {
                this.doArrowLeft();
            } else {
                this.doArrowUp(mode);
            }
        } else if (e.keyCode == 0x1000007) {
            this.doHome(mode);
        } else if (e.keyCode == 0x1000008) {
            this.doEnd(mode);
        } else if (e.keyCode == 0x1000005) {
            this.doPageUp(mode);
        } else if (e.keyCode == 0x1000006) {
            this.doPageDown(mode);
        } else {
            return;
        }
        if (this.fLastSelectedItem != null && oldSelection != this.fLastSelectedItem) {
            this.showItem(this.fLastSelectedItem);
        }
    }

    private void doArrowDown(SelectionMode mode) {
        if (this.fLastSelectedItem == null && this.getItemCount() > 0) {
            this.setSelectionByUserInteraction(this.getItem(0), mode, null);
        } else {
            OutlineItem next = this.getNextVisibleItem(this.fLastSelectedItem);
            if (next != null) {
                this.setSelectionByUserInteraction(next, mode, null);
            }
        }
    }

    private void doArrowUp(SelectionMode mode) {
        if (this.fLastSelectedItem == null && this.getItemCount() > 0) {
            this.setSelectionByUserInteraction(this.getItem(this.getItemCount() - 1), mode, null);
        } else {
            OutlineItem previous = this.getPreviousVisibleItem(this.fLastSelectedItem);
            if (previous != null) {
                this.setSelectionByUserInteraction(previous, mode, null);
            }
        }
    }

    private void doArrowRight() {
        this.fLastSelectedItem.setExpanded(true, true);
    }

    private void doArrowLeft() {
        this.fLastSelectedItem.setExpanded(false, true);
    }

    private void doHome(SelectionMode mode) {
        if (this.getItemCount() > 0) {
            this.setSelectionByUserInteraction(this.getItem(0), mode, null);
        }
    }

    private void doEnd(SelectionMode mode) {
        if (this.getItemCount() == 0) {
            return;
        }
        OutlineItem last = this.getItem(this.getItemCount() - 1);
        this.setSelectionByUserInteraction(this.getDeepestChild(last), mode, null);
    }

    private void doPageUp(SelectionMode mode) {
        if (this.getItemCount() == 0) {
            return;
        }
        OutlineItem item = this.fLastSelectedItem != null ? this.fLastSelectedItem : this.getTopItem();
        Rectangle area = this.getClientArea();
        Rectangle itemBounds = this.getContentBounds(item);
        Rectangle visibleBounds = this.fTransformation.toPane(area).intersection(itemBounds);
        OutlineItem newItem = null;
        newItem = this.fRoot.findItemUnderY(visibleBounds.y + visibleBounds.height - area.height);
        if (newItem == item) {
            this.scroll(0, -(area.height - this.getOutlineResources().getFontMetrics().getHeight()));
            return;
        }
        if (newItem == null || newItem == this.fRoot) {
            newItem = this.getItem(0);
        } else {
            OutlineItem newNewItem;
            Rectangle newContentBounds = this.getContentBounds(newItem);
            if (newContentBounds.y < itemBounds.y + itemBounds.height - area.height && (newNewItem = this.getNextVisibleItem(newItem)) != item) {
                newItem = newNewItem;
            }
        }
        this.setSelectionByUserInteraction(newItem, mode, null);
    }

    private void doPageDown(SelectionMode mode) {
        if (this.getItemCount() == 0) {
            return;
        }
        OutlineItem item = this.fLastSelectedItem != null ? this.fLastSelectedItem : this.getTopItem();
        Rectangle area = this.getClientArea();
        Rectangle itemBounds = this.getContentBounds(item);
        Rectangle visibleBounds = this.fTransformation.toPane(area).intersection(itemBounds);
        OutlineItem newItem = null;
        Insets insets = this.fRoot.getInsets();
        boolean isFirstItem = this.fLastSelectedItem == this.getItem(0);
        newItem = this.fRoot.findItemUnderY(visibleBounds.y + (area.height - (isFirstItem ? insets.top() : 0)));
        if (newItem == item) {
            this.scroll(0, area.height - this.getOutlineResources().getFontMetrics().getHeight());
            return;
        }
        if (newItem == null || newItem == this.fRoot) {
            newItem = this.getDeepestChild(this.getItem(this.getItemCount() - 1));
        } else {
            OutlineItem newNewItem;
            Rectangle newContentBounds = this.getContentBounds(newItem);
            if (newContentBounds.y + newContentBounds.height > itemBounds.y + area.height && (newNewItem = this.getPreviousVisibleItem(newItem)) != item) {
                newItem = newNewItem;
            }
        }
        this.setSelectionByUserInteraction(newItem, mode, null);
    }

    public OutlineItem[] getVisibleItemRange(OutlineItem from, OutlineItem to) {
        OutlineItem next;
        OutlineItem fromCopy = from;
        LinkedList<OutlineItem> tmp = new LinkedList<OutlineItem>();
        tmp.add(fromCopy);
        while ((next = this.getNextVisibleItem(fromCopy)) != null) {
            tmp.add(next);
            if (next.equals(to)) {
                return tmp.toArray(new OutlineItem[tmp.size()]);
            }
            fromCopy = next;
        }
        fromCopy = from;
        next = null;
        tmp.clear();
        tmp.add(fromCopy);
        while ((next = this.getPreviousVisibleItem(fromCopy)) != null) {
            tmp.add(next);
            if (next.equals(to)) {
                return tmp.toArray(new OutlineItem[tmp.size()]);
            }
            fromCopy = next;
        }
        return new OutlineItem[]{to};
    }

    public OutlineItem getPreviousVisibleItem(OutlineItem item) {
        OutlineItem previous;
        OutlineItem parent = item.getParentIncludingRoot();
        if (parent == null) {
            return null;
        }
        int index = parent.indexOf(item);
        OutlineItem outlineItem = previous = index == 0 ? null : parent.getItem(index - 1);
        if (previous == null) {
            if (parent != this.fRoot) {
                return parent;
            }
        } else {
            return this.getDeepestChild(previous);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public OutlineItem getNextVisibleItem(OutlineItem item) {
        if (!item.getExpanded() || item.getItemCount() <= 0) ** GOTO lbl7
        return item.getItem(0);
lbl-1000:
        // 1 sources

        {
            index = parent.indexOf(item);
            if (index < parent.getItemCount() - 1) {
                return parent.getItem(index + 1);
            }
            item = parent;
lbl7:
            // 2 sources

            ** while ((parent = item.getParentIncludingRoot()) != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    private OutlineItem getDeepestChild(OutlineItem item) {
        if (!item.getExpanded() || item.getItemCount() == 0) {
            return item;
        }
        OutlineItem[] children = item.getItems();
        return this.getDeepestChild(children[children.length - 1]);
    }

    public void addGadgetEditorActivationListener(IGadgetEditorActivationListener listener) {
        this.fGadgetEditorActivationListeners.add((Object)listener);
    }

    private void fireActivated(IGadgetEditor editor) {
        Object[] listeners = this.fGadgetEditorActivationListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IGadgetEditorActivationListener)listeners[i]).activated(editor);
            ++i;
        }
    }

    public void removeGadgetEditorActivationListener(IGadgetEditorActivationListener listener) {
        this.fGadgetEditorActivationListeners.remove((Object)listener);
    }

    private void fireDeactivated(IGadgetEditor editor) {
        Object[] listeners = this.fGadgetEditorActivationListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IGadgetEditorActivationListener)listeners[i]).deactivated(editor);
            ++i;
        }
    }

    public final IGadgetEditor startEditSession(GText owner) {
        this.stopEditSession();
        this.fCurrentTextEditor = this.doStartEditSession(owner);
        this.fireActivated(this.fCurrentTextEditor);
        if (this.fCurrentTextEditor != null) {
            this.fCurrentTextEditor.setFocus();
        }
        return this.fCurrentTextEditor;
    }

    protected AbstractTextEditor doStartEditSession(GText owner) {
        return null;
    }

    public void storeData() {
        if (this.fCurrentTextEditor != null) {
            this.fCurrentTextEditor.storeData();
        }
    }

    public void stopEditSession() {
        this.fireDeactivated(this.fCurrentTextEditor);
        if (this.fCurrentTextEditor != null) {
            this.fCurrentTextEditor.stopEditSession();
            this.fCurrentTextEditor = null;
            this.setFocus();
        }
    }

    public void cancelEditSession() {
        this.fireDeactivated(this.fCurrentTextEditor);
        if (this.fCurrentTextEditor != null) {
            this.fCurrentTextEditor.cancelEditSession();
            this.fCurrentTextEditor = null;
            this.setFocus();
        }
    }

    public void setTextEditorFullSelection() {
        if (this.fCurrentTextEditor != null) {
            this.fCurrentTextEditor.setFullSelection();
        }
    }

    public void hookContextMenu(IMenuListener listener) {
    }

    void transferEdit(Gadget from, Gadget to) {
    }

    public IGadgetEditor handleMouseDown(IEventHandler receiver, MouseEvent e) {
        return null;
    }

    public void handleMouseUp(IEventHandler receiver, MouseEvent e) {
    }

    public void handleMouseDoubleClick(IEventHandler receiver, MouseEvent e) {
    }

    public void handleMouseMove(IEventHandler receiver, MouseEvent e) {
    }

    public void handleMouseEnter(IEventHandler receiver, MouseEvent e) {
    }

    public void handleMouseExit(IEventHandler receiver, MouseEvent e) {
    }

    public void handleContextMenuShown(IEventHandler receiver, Menu menu, MenuEvent e) {
    }

    public void stop(IEventHandler receiver) {
    }

    public void showDropTargetEffect(int effect, int x, int y) {
        Point pane = this.fTransformation.toPane(this.toControl(x, y));
        OutlineItem item = this.getRootItem().findItemUnder(pane);
        if (item != this.fLastSelectedItem) {
            if (this.fLastSelectedItem != null && !this.fLastSelectedItem.isDisposed()) {
                if (this.fCurrentTextEditor != null) {
                    this.fCurrentTextEditor.stopEditSession();
                    this.fCurrentTextEditor = null;
                }
                this.fLastSelectedItem.setSelectionMode(0);
            }
            this.fLastSelectedItem = item;
            if (this.fLastSelectedItem != null && !this.fLastSelectedItem.isDisposed()) {
                this.fLastSelectedItem.setSelectionMode(1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SelectionMode {
        SINGLE,
        MULTI,
        RANGE;

    }
}

