/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ResizeMode;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;

public abstract class GShell
extends CompositeGadget {
    private ContentOutlineItem fOutlineItem;
    private static final int CUSTOM_MASK = 65280;
    public static final int NONE = 0;
    public static final int DRAW = 1;
    private int fSelectionMode;

    public GShell(ContentOutlineItem item) {
        super(item);
        this.fOutlineItem = item;
        this.fSelectionMode = 0;
    }

    public GShell getShell() {
        return this;
    }

    public Outline getOutline() {
        return this.fOutlineItem.getOutline();
    }

    public OutlineItem getOutlineItem() {
        return this.fOutlineItem;
    }

    public ContentOutlineItem getContentOutlineItem() {
        return this.fOutlineItem;
    }

    protected void resized(Gadget resizedChild, int deltaWidth, int deltaHeight, Gadget origin) {
        int oldWidth = this.getBounds().width;
        int oldHeight = this.getBounds().height;
        super.resized(resizedChild, deltaWidth, deltaHeight, origin);
        this.fOutlineItem.resize(this.getBounds().width - oldWidth, this.getBounds().height - oldHeight, ResizeMode.CONTENT);
    }

    public int getSelectionMode() {
        return this.fSelectionMode & 0xFFFF00FF;
    }

    protected void setSelectionMode(int newMode) {
        this.internalSetSelectionMode(this.fSelectionMode & 0xFF00 | newMode & 0xFFFF00FF);
    }

    protected int getCustomSelectionMode() {
        return this.fSelectionMode & 0xFF00;
    }

    protected void setCustomSelectionMode(int value) {
        this.internalSetSelectionMode(this.fSelectionMode & 0xFFFF00FF | value & 0xFF00);
    }

    void internalSetSelectionMode(int newMode) {
        int oldMode = this.fSelectionMode;
        if (oldMode == newMode) {
            return;
        }
        this.fSelectionMode = newMode;
        if ((oldMode & 1) == 1 && (newMode & 1) == 0) {
            this.selectionLost();
        }
        if ((oldMode & 1) == 0 && (newMode & 1) == 1) {
            this.selectionGained();
        }
        if ((oldMode & 0xFF00) != (newMode & 0xFF00)) {
            this.customSelectionModeChange(newMode & 0xFF00);
        }
    }

    int internalGetSelectionMode() {
        return this.fSelectionMode;
    }

    protected void selectionGained() {
    }

    protected void selectionLost() {
    }

    protected void customSelectionModeChange(int newMode) {
    }

    public void paint(GC gc, OutlineResources resources) {
        if ((this.fSelectionMode & 1) == 1) {
            this.paintSelection(gc, resources);
            super.paint(gc, resources);
        } else {
            super.paint(gc, resources);
        }
        if (this.getOutlineResources().debugLayout) {
            Rectangle bounds = this.getTransformation().toViewPort(this.fBounds);
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
    }

    protected void paintSelection(GC gc, OutlineResources resources) {
        Rectangle rect = this.getTransformation().toViewPort(this.getSelectionBounds());
        Rectangles.resize(rect, 0, -1);
        GCState state = GCState.save(gc, 10);
        gc.setAlpha(resources.getSelectionAlpha());
        gc.setBackground(resources.getSelectionColor());
        gc.fillRectangle(rect);
        state.restore();
    }

    public abstract Rectangle getSelectionBounds();

    public abstract boolean isLabelProperty(String var1);

    protected IGadgetEditor handleMouseDown(IEventHandler receiver, MouseEvent e) {
        return this.fOutlineItem.handleMouseDown(receiver, e);
    }

    protected void handleMouseUp(IEventHandler receiver, MouseEvent e) {
        this.fOutlineItem.handleMouseUp(receiver, e);
    }

    protected void handleMouseDoubleClick(IEventHandler receiver, MouseEvent e) {
        this.fOutlineItem.handleMouseDoubleClick(receiver, e);
    }

    protected void handleMouseMove(IEventHandler receiver, MouseEvent e) {
        this.fOutlineItem.handleMouseMove(receiver, e);
    }

    protected void handleMouseEnter(IEventHandler receiver, MouseEvent e) {
        this.fOutlineItem.handleMouseEnter(receiver, e);
    }

    protected void handleMouseExit(IEventHandler handler, MouseEvent e) {
        this.fOutlineItem.handleMouseExit(this, e);
    }

    protected void handleContextMenuShown(IEventHandler receiver, Menu menu, MenuEvent e) {
        this.fOutlineItem.handleContextMenuShown(receiver, menu, e);
    }

    protected void stop(IEventHandler receiver) {
        this.fOutlineItem.stop(receiver);
    }
}

